# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from seaplane.gen.carrier.models.docker_processor import DockerProcessor
from typing import Any, List
from pydantic import StrictStr, Field

PROCESSOR_ANY_OF_SCHEMAS = ["DockerProcessor", "object"]


class Processor(BaseModel):
    """
    Processor
    """

    # data type: DockerProcessor
    anyof_schema_1_validator: Optional[DockerProcessor] = None
    # data type: object
    anyof_schema_2_validator: Optional[Dict[str, Any]] = Field(
        None, description="Value may be missing"
    )
    actual_instance: Any
    any_of_schemas: List[str] = Field(PROCESSOR_ANY_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    def __init__(self, *args, **kwargs):
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator("actual_instance")
    def actual_instance_must_validate_anyof(cls, v):
        if v is None:
            return v

        instance = Processor.construct()
        error_messages = []
        # validate data type: DockerProcessor
        if not isinstance(v, DockerProcessor):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `DockerProcessor`"
            )
        else:
            return v

        # validate data type: object
        try:
            instance.anyof_schema_2_validator = v
            return v
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        if error_messages:
            # no match
            raise ValueError(
                "No match found when setting the actual_instance in Processor with anyOf schemas: DockerProcessor, object. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> Processor:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Processor:
        """Returns the object represented by the json string"""
        instance = Processor.construct()
        if json_str is None:
            return instance

        error_messages = []
        # anyof_schema_1_validator: Optional[DockerProcessor] = None
        try:
            instance.actual_instance = DockerProcessor.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into object
        try:
            # validation
            instance.anyof_schema_2_validator = json.loads(json_str)
            # assign value to actual_instance
            instance.actual_instance = instance.anyof_schema_2_validator
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into Processor with anyOf schemas: DockerProcessor, object. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_dict()
        else:
            return json.dumps(self.actual_instance)

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())
