# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from pydantic import BaseModel, Field, StrictInt, StrictStr


class ObjectStat(BaseModel):
    """
    Information about an object
    """

    name: StrictStr = Field(..., description="Object name")
    size: StrictInt = Field(..., description="Object size")
    mod_time: StrictInt = Field(..., description="MTIME (modification timestamp, unix)")
    digest: StrictStr = Field(
        ..., description="Object digest/hash, prefixed with hash method."
    )
    __properties = ["name", "size", "mod_time", "digest"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ObjectStat:
        """Create an instance of ObjectStat from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ObjectStat:
        """Create an instance of ObjectStat from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ObjectStat.parse_obj(obj)

        _obj = ObjectStat.parse_obj(
            {
                "name": obj.get("name"),
                "size": obj.get("size"),
                "mod_time": obj.get("mod_time"),
                "digest": obj.get("digest"),
            }
        )
        return _obj
