# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictStr, conlist


class MetadataHeaders(BaseModel):
    """
    Specify criteria for which metadata values are added to the response as headers.
    """

    include_prefixes: conlist(StrictStr) = Field(
        ...,
        description="Provide a list of explicit metadata key prefixes to match against.",
    )
    include_patterns: conlist(StrictStr) = Field(
        ...,
        description="Provide a list of explicit metadata key regular expression (re2) patterns to match against.",
    )
    __properties = ["include_prefixes", "include_patterns"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MetadataHeaders:
        """Create an instance of MetadataHeaders from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MetadataHeaders:
        """Create an instance of MetadataHeaders from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MetadataHeaders.parse_obj(obj)

        _obj = MetadataHeaders.parse_obj(
            {
                "include_prefixes": obj.get("include_prefixes"),
                "include_patterns": obj.get("include_patterns"),
            }
        )
        return _obj
