# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, conint, conlist, constr, validator


class KeyValueConfig(BaseModel):
    """
    The set of possible values to configure on a specific key-value store.
    """

    max_value_size: Optional[StrictInt] = Field(
        2097152, description="The maximum size of a value, in bytes"
    )
    history: Optional[conint(strict=True, le=64, ge=1)] = Field(
        16, description="The number of versions to keep in history for each key"
    )
    ttl: Optional[conint(strict=True, le=315360000, ge=0)] = Field(
        None, description="Optionally sets a key to expire after this many seconds."
    )
    replicas: Optional[StrictInt] = Field(3, description="Number of replicas (1/3/5)")
    allow_locations: Optional[conlist(constr(strict=True))] = Field(
        None, description="Array of allowed locations"
    )
    deny_locations: Optional[conlist(constr(strict=True))] = Field(
        None, description="Array of denied locations"
    )
    __properties = [
        "max_value_size",
        "history",
        "ttl",
        "replicas",
        "allow_locations",
        "deny_locations",
    ]

    @validator("replicas")
    def replicas_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (1, 3, 5):
            raise ValueError("must be one of enum values (1, 3, 5)")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> KeyValueConfig:
        """Create an instance of KeyValueConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> KeyValueConfig:
        """Create an instance of KeyValueConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return KeyValueConfig.parse_obj(obj)

        _obj = KeyValueConfig.parse_obj(
            {
                "max_value_size": obj.get("max_value_size")
                if obj.get("max_value_size") is not None
                else 2097152,
                "history": obj.get("history") if obj.get("history") is not None else 16,
                "ttl": obj.get("ttl"),
                "replicas": obj.get("replicas")
                if obj.get("replicas") is not None
                else 3,
                "allow_locations": obj.get("allow_locations"),
                "deny_locations": obj.get("deny_locations"),
            }
        )
        return _obj
