# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from seaplane.gen.carrier.models.carrier_input import CarrierInput
from seaplane.gen.carrier.models.http_server import HTTPServer
from typing import Any, List
from pydantic import StrictStr, Field

INPUT_ANY_OF_SCHEMAS = ["CarrierInput", "HTTPServer"]


class Input(BaseModel):
    """
    Input
    """

    # data type: CarrierInput
    anyof_schema_1_validator: Optional[CarrierInput] = None
    # data type: HTTPServer
    anyof_schema_2_validator: Optional[HTTPServer] = None
    actual_instance: Any
    any_of_schemas: List[str] = Field(INPUT_ANY_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    def __init__(self, *args, **kwargs):
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator("actual_instance")
    def actual_instance_must_validate_anyof(cls, v):
        instance = Input.construct()
        error_messages = []
        # validate data type: CarrierInput
        if not isinstance(v, CarrierInput):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CarrierInput`"
            )
        else:
            return v

        # validate data type: HTTPServer
        if not isinstance(v, HTTPServer):
            error_messages.append(f"Error! Input type `{type(v)}` is not `HTTPServer`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError(
                "No match found when setting the actual_instance in Input with anyOf schemas: CarrierInput, HTTPServer. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> Input:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Input:
        """Returns the object represented by the json string"""
        instance = Input.construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[CarrierInput] = None
        try:
            instance.actual_instance = CarrierInput.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[HTTPServer] = None
        try:
            instance.actual_instance = HTTPServer.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into Input with anyOf schemas: CarrierInput, HTTPServer. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_dict()
        else:
            return json.dumps(self.actual_instance)

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())
