# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator


class HttpClientOutputHttpClient(BaseModel):
    """
    HTTP Client output configuration
    """

    url: constr(strict=True) = Field(..., description="The URL to connect to")
    method: Optional[StrictStr] = Field(
        "POST", description="The HTTP method to use for the request."
    )
    headers: Optional[Dict[str, StrictStr]] = Field(
        None, description="A set of extra header values to set on the request"
    )
    __properties = ["url", "method", "headers"]

    @validator("url")
    def url_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"[^ ]+", value):
            raise ValueError(r"must validate the regular expression /[^ ]+/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> HttpClientOutputHttpClient:
        """Create an instance of HttpClientOutputHttpClient from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> HttpClientOutputHttpClient:
        """Create an instance of HttpClientOutputHttpClient from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return HttpClientOutputHttpClient.parse_obj(obj)

        _obj = HttpClientOutputHttpClient.parse_obj(
            {
                "url": obj.get("url"),
                "method": obj.get("method")
                if obj.get("method") is not None
                else "POST",
                "headers": obj.get("headers"),
            }
        )
        return _obj
