# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, conint
from seaplane.gen.carrier.models.input import Input
from seaplane.gen.carrier.models.output import Output
from seaplane.gen.carrier.models.processor import Processor


class Flow(BaseModel):
    """
    defines model for Flow
    """

    input: Optional[Input] = None
    processor: Optional[Processor] = None
    output: Optional[Output] = None
    replicas: Optional[conint(strict=True, ge=0)] = Field(
        1, description="Number of task replicas"
    )
    __properties = ["input", "processor", "output", "replicas"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Flow:
        """Create an instance of Flow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of input
        if self.input:
            _dict["input"] = self.input.to_dict()
        # override the default output from pydantic by calling `to_dict()` of processor
        if self.processor:
            _dict["processor"] = self.processor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of output
        if self.output:
            _dict["output"] = self.output.to_dict()
        # set to None if processor (nullable) is None
        # and __fields_set__ contains the field
        if self.processor is None and "processor" in self.__fields_set__:
            _dict["processor"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Flow:
        """Create an instance of Flow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Flow.parse_obj(obj)

        _obj = Flow.parse_obj(
            {
                "input": Input.from_dict(obj.get("input"))
                if obj.get("input") is not None
                else None,
                "processor": Processor.from_dict(obj.get("processor"))
                if obj.get("processor") is not None
                else None,
                "output": Output.from_dict(obj.get("output"))
                if obj.get("output") is not None
                else None,
                "replicas": obj.get("replicas")
                if obj.get("replicas") is not None
                else 1,
            }
        )
        return _obj
