# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from pydantic import BaseModel, Field
from seaplane.gen.carrier.models.docker_processor_docker import DockerProcessorDocker


class DockerProcessor(BaseModel):
    """
    Carrier Flow docker processor
    """

    docker: DockerProcessorDocker = Field(...)
    __properties = ["docker"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DockerProcessor:
        """Create an instance of DockerProcessor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of docker
        if self.docker:
            _dict["docker"] = self.docker.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DockerProcessor:
        """Create an instance of DockerProcessor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DockerProcessor.parse_obj(obj)

        _obj = DockerProcessor.parse_obj(
            {
                "docker": DockerProcessorDocker.from_dict(obj.get("docker"))
                if obj.get("docker") is not None
                else None
            }
        )
        return _obj
