# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist


class Cors(BaseModel):
    """
    Adds Cross-Origin Resource Sharing headers. Only valid with a custom address.
    """

    enabled: StrictBool = Field(..., description="Allow cross-origin requests")
    allowed_origins: conlist(StrictStr) = Field(
        ..., description="List of allowed origins"
    )
    __properties = ["enabled", "allowed_origins"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Cors:
        """Create an instance of Cors from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Cors:
        """Create an instance of Cors from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Cors.parse_obj(obj)

        _obj = Cors.parse_obj(
            {
                "enabled": obj.get("enabled"),
                "allowed_origins": obj.get("allowed_origins"),
            }
        )
        return _obj
