# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import (
    BaseModel,
    Field,
    StrictBool,
    StrictInt,
    StrictStr,
    conint,
    conlist,
    constr,
    validator,
)


class CarrierStreamOptions(BaseModel):
    """
    Stream configuration options
    """

    message_ttl: Optional[conint(strict=True, le=86400, ge=0)] = Field(
        0, description="Message TTL in seconds"
    )
    max_messages: Optional[conint(strict=True, le=1000000, ge=0)] = Field(
        1000000, description="Max messages in stream"
    )
    max_size: Optional[conint(strict=True, le=1000000000, ge=0)] = Field(
        100000000, description="Max total size od messages in stream in bytes"
    )
    replicas: Optional[StrictInt] = Field(3, description="Number of replicas (1/3/5)")
    allow_locations: Optional[conlist(constr(strict=True))] = Field(
        None, description="Array of allowed locations"
    )
    deny_locations: Optional[conlist(constr(strict=True))] = Field(
        None, description="Array of denied locations"
    )
    wait_for_ack: Optional[StrictBool] = Field(
        True, description="Should the stream wait for ack"
    )
    ack_timeout: Optional[conint(strict=True, le=60, ge=1)] = Field(
        5, description="How long should the stream wait for ack in seconds"
    )
    max_delivery_attempts: Optional[conint(strict=True, le=1000, ge=1)] = Field(
        5, description="Maximum number of delivery attempts"
    )
    max_delivery_time: Optional[conint(strict=True, le=3600, ge=0)] = Field(
        60, description="Maximum delivery time in seconds"
    )
    dead_letter_sink: Optional[StrictStr] = Field(None, description="TBD")
    allow_direct: Optional[StrictBool] = Field(
        None, description="allow direct message retrieval by subject"
    )
    __properties = [
        "message_ttl",
        "max_messages",
        "max_size",
        "replicas",
        "allow_locations",
        "deny_locations",
        "wait_for_ack",
        "ack_timeout",
        "max_delivery_attempts",
        "max_delivery_time",
        "dead_letter_sink",
        "allow_direct",
    ]

    @validator("replicas")
    def replicas_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (1, 3, 5):
            raise ValueError("must be one of enum values (1, 3, 5)")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CarrierStreamOptions:
        """Create an instance of CarrierStreamOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CarrierStreamOptions:
        """Create an instance of CarrierStreamOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CarrierStreamOptions.parse_obj(obj)

        _obj = CarrierStreamOptions.parse_obj(
            {
                "message_ttl": obj.get("message_ttl")
                if obj.get("message_ttl") is not None
                else 0,
                "max_messages": obj.get("max_messages")
                if obj.get("max_messages") is not None
                else 1000000,
                "max_size": obj.get("max_size")
                if obj.get("max_size") is not None
                else 100000000,
                "replicas": obj.get("replicas")
                if obj.get("replicas") is not None
                else 3,
                "allow_locations": obj.get("allow_locations"),
                "deny_locations": obj.get("deny_locations"),
                "wait_for_ack": obj.get("wait_for_ack")
                if obj.get("wait_for_ack") is not None
                else True,
                "ack_timeout": obj.get("ack_timeout")
                if obj.get("ack_timeout") is not None
                else 5,
                "max_delivery_attempts": obj.get("max_delivery_attempts")
                if obj.get("max_delivery_attempts") is not None
                else 5,
                "max_delivery_time": obj.get("max_delivery_time")
                if obj.get("max_delivery_time") is not None
                else 60,
                "dead_letter_sink": obj.get("dead_letter_sink"),
                "allow_direct": obj.get("allow_direct"),
            }
        )
        return _obj
