# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, Optional
from pydantic import BaseModel, Field, StrictInt


class CarrierStreamDetails(BaseModel):
    """
    Stream details
    """

    creation_ts: Optional[StrictInt] = Field(
        None, description="Stream creation timestamp"
    )
    stored_messages: Optional[StrictInt] = Field(
        None, description="Number of all stored messages"
    )
    stored_messages_size: Optional[StrictInt] = Field(
        None, description="Size od all stored messages in bytes"
    )
    first_message_seq: Optional[StrictInt] = Field(
        None, description="Sequence number of the first message"
    )
    first_message_ts: Optional[StrictInt] = Field(
        None, description="Timestamp of the first message"
    )
    last_message_seq: Optional[StrictInt] = Field(
        None, description="Sequence number of the last message"
    )
    last_message_ts: Optional[StrictInt] = Field(
        None, description="Timestamp of the last message"
    )
    subjects: Optional[Dict[str, StrictInt]] = Field(
        None, description="Number of messages per subject"
    )
    __properties = [
        "creation_ts",
        "stored_messages",
        "stored_messages_size",
        "first_message_seq",
        "first_message_ts",
        "last_message_seq",
        "last_message_ts",
        "subjects",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CarrierStreamDetails:
        """Create an instance of CarrierStreamDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CarrierStreamDetails:
        """Create an instance of CarrierStreamDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CarrierStreamDetails.parse_obj(obj)

        _obj = CarrierStreamDetails.parse_obj(
            {
                "creation_ts": obj.get("creation_ts"),
                "stored_messages": obj.get("stored_messages"),
                "stored_messages_size": obj.get("stored_messages_size"),
                "first_message_seq": obj.get("first_message_seq"),
                "first_message_ts": obj.get("first_message_ts"),
                "last_message_seq": obj.get("last_message_seq"),
                "last_message_ts": obj.get("last_message_ts"),
                "subjects": obj.get("subjects"),
            }
        )
        return _obj
