# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from seaplane.gen.carrier.models.carrier_stream_details import CarrierStreamDetails
from seaplane.gen.carrier.models.carrier_stream_options import CarrierStreamOptions


class CarrierStream(BaseModel):
    """
    Information about the stream
    """

    name: Optional[StrictStr] = Field(None, description="Stream name")
    options: Optional[CarrierStreamOptions] = None
    details: Optional[CarrierStreamDetails] = None
    __properties = ["name", "options", "details"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CarrierStream:
        """Create an instance of CarrierStream from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict["options"] = self.options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of details
        if self.details:
            _dict["details"] = self.details.to_dict()
        # set to None if options (nullable) is None
        # and __fields_set__ contains the field
        if self.options is None and "options" in self.__fields_set__:
            _dict["options"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CarrierStream:
        """Create an instance of CarrierStream from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CarrierStream.parse_obj(obj)

        _obj = CarrierStream.parse_obj(
            {
                "name": obj.get("name"),
                "options": CarrierStreamOptions.from_dict(obj.get("options"))
                if obj.get("options") is not None
                else None,
                "details": CarrierStreamDetails.from_dict(obj.get("details"))
                if obj.get("details") is not None
                else None,
            }
        )
        return _obj
