# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel
from seaplane.gen.carrier.models.carrier_input_config import CarrierInputConfig


class CarrierInput(BaseModel):
    """
    Carrier stream input source
    """

    carrier: Optional[CarrierInputConfig] = None
    __properties = ["carrier"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CarrierInput:
        """Create an instance of CarrierInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of carrier
        if self.carrier:
            _dict["carrier"] = self.carrier.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CarrierInput:
        """Create an instance of CarrierInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CarrierInput.parse_obj(obj)

        _obj = CarrierInput.parse_obj(
            {
                "carrier": CarrierInputConfig.from_dict(obj.get("carrier"))
                if obj.get("carrier") is not None
                else None
            }
        )
        return _obj
