# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import (
    BaseModel,
    Field,
    StrictInt,
    StrictStr,
    conint,
    conlist,
    constr,
    validator,
)


class Bucket(BaseModel):
    """
    Bucket configuration
    """

    description: Optional[StrictStr] = Field(
        None, description="Description of a bucket"
    )
    replicas: Optional[StrictInt] = Field(3, description="Number of replicas (1/3/5)")
    allow_locations: Optional[conlist(constr(strict=True))] = Field(
        None, description="Array of allowed locations"
    )
    deny_locations: Optional[conlist(constr(strict=True))] = Field(
        None, description="Array of denied locations"
    )
    max_bytes: Optional[conint(strict=True, ge=-1)] = Field(
        None, description="Maximum size of bucket, -1 and 0/missing are unlimited."
    )
    notify: Optional[StrictStr] = Field(
        None, description="Publish object notifications to this subject."
    )
    __properties = [
        "description",
        "replicas",
        "allow_locations",
        "deny_locations",
        "max_bytes",
        "notify",
    ]

    @validator("replicas")
    def replicas_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (1, 3, 5):
            raise ValueError("must be one of enum values (1, 3, 5)")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Bucket:
        """Create an instance of Bucket from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Bucket:
        """Create an instance of Bucket from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Bucket.parse_obj(obj)

        _obj = Bucket.parse_obj(
            {
                "description": obj.get("description"),
                "replicas": obj.get("replicas")
                if obj.get("replicas") is not None
                else 3,
                "allow_locations": obj.get("allow_locations"),
                "deny_locations": obj.get("deny_locations"),
                "max_bytes": obj.get("max_bytes"),
                "notify": obj.get("notify"),
            }
        )
        return _obj
