# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from seaplane.gen.carrier.models.broker_output_broker_outputs_inner import (
    BrokerOutputBrokerOutputsInner,
)


class BrokerOutputBroker(BaseModel):
    """
    Broker output configuration
    """

    outputs: Optional[conlist(BrokerOutputBrokerOutputsInner)] = Field(
        None, description="List of outputs"
    )
    __properties = ["outputs"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BrokerOutputBroker:
        """Create an instance of BrokerOutputBroker from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in outputs (list)
        _items = []
        if self.outputs:
            for _item in self.outputs:
                if _item:
                    _items.append(_item.to_dict())
            _dict["outputs"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BrokerOutputBroker:
        """Create an instance of BrokerOutputBroker from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BrokerOutputBroker.parse_obj(obj)

        _obj = BrokerOutputBroker.parse_obj(
            {
                "outputs": [
                    BrokerOutputBrokerOutputsInner.from_dict(_item)
                    for _item in obj.get("outputs")
                ]
                if obj.get("outputs") is not None
                else None
            }
        )
        return _obj
