# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from pydantic import BaseModel, Field
from seaplane.gen.carrier.models.broker_output_broker import BrokerOutputBroker


class BrokerOutput(BaseModel):
    """
    Allows you to route messages to multiple child outputs using a range of brokering patterns.
    """

    broker: BrokerOutputBroker = Field(...)
    __properties = ["broker"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BrokerOutput:
        """Create an instance of BrokerOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of broker
        if self.broker:
            _dict["broker"] = self.broker.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BrokerOutput:
        """Create an instance of BrokerOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BrokerOutput.parse_obj(obj)

        _obj = BrokerOutput.parse_obj(
            {
                "broker": BrokerOutputBroker.from_dict(obj.get("broker"))
                if obj.get("broker") is not None
                else None
            }
        )
        return _obj
