# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator


class AzureBlobStorageOutputAzureBlobStorage(BaseModel):
    """
    Azure Blob Storage configuration
    """

    storage_account: Optional[StrictStr] = Field(
        "",
        description="The storage account to access. This field is ignored if storage_connection_string is set.",
    )
    storage_access_key: Optional[StrictStr] = Field(
        "",
        description="The storage account access key. This field is ignored if storage_connection_string is set.",
    )
    storage_sas_token: Optional[StrictStr] = Field(
        "",
        description="The storage account SAS token. This field is ignored if storage_connection_string or storage_access_key are set.",
    )
    storage_connection_string: Optional[StrictStr] = Field(
        "",
        description="A storage account connection string. This field is required if storage_account and storage_access_key / storage_sas_token are not set.",
    )
    container: constr(strict=True) = Field(
        ...,
        description="The container for uploading the messages to. This field supports interpolation functions.",
    )
    path: Optional[StrictStr] = Field(
        '${!count("files")}-${!timestamp_unix_nano()}.txt',
        description="The path of each message to upload. This field supports interpolation functions.",
    )
    blob_type: Optional[StrictStr] = Field(
        "BLOCK",
        description='Block and Append blobs are comprised of blocks, and each blob can support up to 50,000 blocks. The default value is +"BLOCK"+.` This field supports interpolation functions.',
    )
    public_access_level: Optional[StrictStr] = Field(
        "PRIVATE",
        description="The container's public access level. The default value is PRIVATE. This field supports interpolation functions.",
    )
    max_in_flight: Optional[StrictInt] = Field(
        64,
        description="The maximum number of messages to have in flight at a given time. Increase this to improve throughput.",
    )
    __properties = [
        "storage_account",
        "storage_access_key",
        "storage_sas_token",
        "storage_connection_string",
        "container",
        "path",
        "blob_type",
        "public_access_level",
        "max_in_flight",
    ]

    @validator("container")
    def container_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^.+$", value):
            raise ValueError(r"must validate the regular expression /^.+$/")
        return value

    @validator("blob_type")
    def blob_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("BLOCK", "APPEND"):
            raise ValueError("must be one of enum values ('BLOCK', 'APPEND')")
        return value

    @validator("public_access_level")
    def public_access_level_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("PRIVATE", "BLOB", "CONTAINER"):
            raise ValueError(
                "must be one of enum values ('PRIVATE', 'BLOB', 'CONTAINER')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AzureBlobStorageOutputAzureBlobStorage:
        """Create an instance of AzureBlobStorageOutputAzureBlobStorage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AzureBlobStorageOutputAzureBlobStorage:
        """Create an instance of AzureBlobStorageOutputAzureBlobStorage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AzureBlobStorageOutputAzureBlobStorage.parse_obj(obj)

        _obj = AzureBlobStorageOutputAzureBlobStorage.parse_obj(
            {
                "storage_account": obj.get("storage_account")
                if obj.get("storage_account") is not None
                else "",
                "storage_access_key": obj.get("storage_access_key")
                if obj.get("storage_access_key") is not None
                else "",
                "storage_sas_token": obj.get("storage_sas_token")
                if obj.get("storage_sas_token") is not None
                else "",
                "storage_connection_string": obj.get("storage_connection_string")
                if obj.get("storage_connection_string") is not None
                else "",
                "container": obj.get("container"),
                "path": obj.get("path")
                if obj.get("path") is not None
                else '${!count("files")}-${!timestamp_unix_nano()}.txt',
                "blob_type": obj.get("blob_type")
                if obj.get("blob_type") is not None
                else "BLOCK",
                "public_access_level": obj.get("public_access_level")
                if obj.get("public_access_level") is not None
                else "PRIVATE",
                "max_in_flight": obj.get("max_in_flight")
                if obj.get("max_in_flight") is not None
                else 64,
            }
        )
        return _obj
