# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from typing_extensions import Annotated
from pydantic import Field, StrictStr

from typing import Any, Dict, Optional


from seaplane.gen.carrier.api_client import ApiClient
from seaplane.gen.carrier.api_response import ApiResponse
from seaplane.gen.carrier.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class WebhookApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def receive_webhook(
        self,
        provider: Annotated[
            StrictStr,
            Field(..., description="Name of a Webhook provider we expect results from"),
        ],
        division: Annotated[
            StrictStr,
            Field(
                ..., description="Subdivison of the Webhook stream to post results to"
            ),
        ],
        request_body: Optional[Dict[str, Any]] = None,
        **kwargs
    ) -> None:  # noqa: E501
        """Accepts a webhook from an async AI request  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.receive_webhook(provider, division, request_body, async_req=True)
        >>> result = thread.get()

        :param provider: Name of a Webhook provider we expect results from (required)
        :type provider: str
        :param division: Subdivison of the Webhook stream to post results to (required)
        :type division: str
        :param request_body:
        :type request_body: Dict[str, object]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the receive_webhook_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.receive_webhook_with_http_info(
            provider, division, request_body, **kwargs
        )  # noqa: E501

    @validate_arguments
    def receive_webhook_with_http_info(
        self,
        provider: Annotated[
            StrictStr,
            Field(..., description="Name of a Webhook provider we expect results from"),
        ],
        division: Annotated[
            StrictStr,
            Field(
                ..., description="Subdivison of the Webhook stream to post results to"
            ),
        ],
        request_body: Optional[Dict[str, Any]] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Accepts a webhook from an async AI request  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.receive_webhook_with_http_info(provider, division, request_body, async_req=True)
        >>> result = thread.get()

        :param provider: Name of a Webhook provider we expect results from (required)
        :type provider: str
        :param division: Subdivison of the Webhook stream to post results to (required)
        :type division: str
        :param request_body:
        :type request_body: Dict[str, object]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["provider", "division", "request_body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method receive_webhook" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["provider"]:
            _path_params["provider"] = _params["provider"]

        if _params["division"]:
            _path_params["division"] = _params["division"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["request_body"] is not None:
            _body_params = _params["request_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/webhook/{provider}/{division}",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
