# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from typing_extensions import Annotated
from pydantic import Field, StrictStr, constr, validator

from typing import List, Optional

from seaplane.gen.carrier.models.carrier_stream import CarrierStream
from seaplane.gen.carrier.models.carrier_stream_options import CarrierStreamOptions

from seaplane.gen.carrier.api_client import ApiClient
from seaplane.gen.carrier.api_response import ApiResponse
from seaplane.gen.carrier.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class StreamApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_stream(
        self,
        stream_name: Annotated[
            constr(strict=True),
            Field(
                ...,
                description='Name of the stream. Must be less than 32 characters long. Allowed characters are: a-z, A-Z, 0-9, "-" and "_". ',
            ),
        ],
        carrier_stream_options: Annotated[
            Optional[CarrierStreamOptions],
            Field(description="Stream configuration options"),
        ] = None,
        **kwargs
    ) -> None:  # noqa: E501
        """Create a new stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_stream(stream_name, carrier_stream_options, async_req=True)
        >>> result = thread.get()

        :param stream_name: Name of the stream. Must be less than 32 characters long. Allowed characters are: a-z, A-Z, 0-9, \"-\" and \"_\".  (required)
        :type stream_name: str
        :param carrier_stream_options: Stream configuration options
        :type carrier_stream_options: CarrierStreamOptions
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the create_stream_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.create_stream_with_http_info(
            stream_name, carrier_stream_options, **kwargs
        )  # noqa: E501

    @validate_arguments
    def create_stream_with_http_info(
        self,
        stream_name: Annotated[
            constr(strict=True),
            Field(
                ...,
                description='Name of the stream. Must be less than 32 characters long. Allowed characters are: a-z, A-Z, 0-9, "-" and "_". ',
            ),
        ],
        carrier_stream_options: Annotated[
            Optional[CarrierStreamOptions],
            Field(description="Stream configuration options"),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Create a new stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_stream_with_http_info(stream_name, carrier_stream_options, async_req=True)
        >>> result = thread.get()

        :param stream_name: Name of the stream. Must be less than 32 characters long. Allowed characters are: a-z, A-Z, 0-9, \"-\" and \"_\".  (required)
        :type stream_name: str
        :param carrier_stream_options: Stream configuration options
        :type carrier_stream_options: CarrierStreamOptions
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["stream_name", "carrier_stream_options"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_stream" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["stream_name"]:
            _path_params["stream_name"] = _params["stream_name"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["carrier_stream_options"] is not None:
            _body_params = _params["carrier_stream_options"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/stream/{stream_name}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_stream(
        self,
        stream_name: Annotated[
            constr(strict=True),
            Field(
                ...,
                description='Name of the stream. Must be less than 32 characters long. Allowed characters are: a-z, A-Z, 0-9, "-" and "_". ',
            ),
        ],
        **kwargs
    ) -> None:  # noqa: E501
        """Delete a stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_stream(stream_name, async_req=True)
        >>> result = thread.get()

        :param stream_name: Name of the stream. Must be less than 32 characters long. Allowed characters are: a-z, A-Z, 0-9, \"-\" and \"_\".  (required)
        :type stream_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the delete_stream_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.delete_stream_with_http_info(stream_name, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_stream_with_http_info(
        self,
        stream_name: Annotated[
            constr(strict=True),
            Field(
                ...,
                description='Name of the stream. Must be less than 32 characters long. Allowed characters are: a-z, A-Z, 0-9, "-" and "_". ',
            ),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete a stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_stream_with_http_info(stream_name, async_req=True)
        >>> result = thread.get()

        :param stream_name: Name of the stream. Must be less than 32 characters long. Allowed characters are: a-z, A-Z, 0-9, \"-\" and \"_\".  (required)
        :type stream_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["stream_name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_stream" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["stream_name"]:
            _path_params["stream_name"] = _params["stream_name"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/stream/{stream_name}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_stream(
        self,
        stream_name: Annotated[
            constr(strict=True),
            Field(
                ...,
                description='Name of the stream. Must be less than 32 characters long. Allowed characters are: a-z, A-Z, 0-9, "-" and "_". ',
            ),
        ],
        **kwargs
    ) -> CarrierStream:  # noqa: E501
        """Get the details of a stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_stream(stream_name, async_req=True)
        >>> result = thread.get()

        :param stream_name: Name of the stream. Must be less than 32 characters long. Allowed characters are: a-z, A-Z, 0-9, \"-\" and \"_\".  (required)
        :type stream_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CarrierStream
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the get_stream_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.get_stream_with_http_info(stream_name, **kwargs)  # noqa: E501

    @validate_arguments
    def get_stream_with_http_info(
        self,
        stream_name: Annotated[
            constr(strict=True),
            Field(
                ...,
                description='Name of the stream. Must be less than 32 characters long. Allowed characters are: a-z, A-Z, 0-9, "-" and "_". ',
            ),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get the details of a stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_stream_with_http_info(stream_name, async_req=True)
        >>> result = thread.get()

        :param stream_name: Name of the stream. Must be less than 32 characters long. Allowed characters are: a-z, A-Z, 0-9, \"-\" and \"_\".  (required)
        :type stream_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CarrierStream, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["stream_name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stream" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["stream_name"]:
            _path_params["stream_name"] = _params["stream_name"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "CarrierStream",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/stream/{stream_name}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_streams(
        self,
        internal: Annotated[
            Optional[StrictStr], Field(description="List internal system streams.")
        ] = None,
        **kwargs
    ) -> List[str]:  # noqa: E501
        """Get list of all streams  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_streams(internal, async_req=True)
        >>> result = thread.get()

        :param internal: List internal system streams.
        :type internal: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[str]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the list_streams_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.list_streams_with_http_info(internal, **kwargs)  # noqa: E501

    @validate_arguments
    def list_streams_with_http_info(
        self,
        internal: Annotated[
            Optional[StrictStr], Field(description="List internal system streams.")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get list of all streams  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_streams_with_http_info(internal, async_req=True)
        >>> result = thread.get()

        :param internal: List internal system streams.
        :type internal: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[str], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["internal"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_streams" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get("internal") is not None:  # noqa: E501
            _query_params.append(("internal", _params["internal"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "List[str]",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/stream",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
