# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from typing_extensions import Annotated
from pydantic import Field, StrictBytes, StrictStr, constr, validator

from typing import Dict, List, Optional, Union

from seaplane.gen.carrier.models.bucket import Bucket
from seaplane.gen.carrier.models.object_stat import ObjectStat

from seaplane.gen.carrier.api_client import ApiClient
from seaplane.gen.carrier.api_response import ApiResponse
from seaplane.gen.carrier.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class ObjectApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_bucket(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        bucket: Annotated[
            Optional[Bucket], Field(description="Bucket definition")
        ] = None,
        **kwargs
    ) -> None:  # noqa: E501
        """Create a Bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_bucket(bucket_name, bucket, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param bucket: Bucket definition
        :type bucket: Bucket
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the create_bucket_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.create_bucket_with_http_info(
            bucket_name, bucket, **kwargs
        )  # noqa: E501

    @validate_arguments
    def create_bucket_with_http_info(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        bucket: Annotated[
            Optional[Bucket], Field(description="Bucket definition")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Create a Bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_bucket_with_http_info(bucket_name, bucket, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param bucket: Bucket definition
        :type bucket: Bucket
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["bucket_name", "bucket"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bucket" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["bucket_name"]:
            _path_params["bucket_name"] = _params["bucket_name"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["bucket"] is not None:
            _body_params = _params["bucket"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/object/{bucket_name}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def create_object(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        path: Annotated[
            StrictStr, Field(..., description="URL-encoded path within a bucket.")
        ],
        body: Optional[Union[StrictBytes, StrictStr]] = None,
        **kwargs
    ) -> None:  # noqa: E501
        """Create an object in a bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_object(bucket_name, path, body, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param path: URL-encoded path within a bucket. (required)
        :type path: str
        :param body:
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the create_object_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.create_object_with_http_info(
            bucket_name, path, body, **kwargs
        )  # noqa: E501

    @validate_arguments
    def create_object_with_http_info(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        path: Annotated[
            StrictStr, Field(..., description="URL-encoded path within a bucket.")
        ],
        body: Optional[Union[StrictBytes, StrictStr]] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Create an object in a bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_object_with_http_info(bucket_name, path, body, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param path: URL-encoded path within a bucket. (required)
        :type path: str
        :param body:
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["bucket_name", "path", "body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_object" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["bucket_name"]:
            _path_params["bucket_name"] = _params["bucket_name"]

        # process the query parameters
        _query_params = []
        if _params.get("path") is not None:  # noqa: E501
            _query_params.append(("path", _params["path"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["body"] is not None:
            _body_params = _params["body"]
            # convert to byte array if the input is a file name (str)
            if isinstance(_body_params, str):
                with io.open(_body_params, "rb") as _fp:
                    _body_params_from_file = _fp.read()
                _body_params = _body_params_from_file

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/octet-stream"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/object/{bucket_name}/store",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_bucket(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        **kwargs
    ) -> None:  # noqa: E501
        """Delete a bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_bucket(bucket_name, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the delete_bucket_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.delete_bucket_with_http_info(bucket_name, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_bucket_with_http_info(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete a bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_bucket_with_http_info(bucket_name, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["bucket_name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bucket" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["bucket_name"]:
            _path_params["bucket_name"] = _params["bucket_name"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/object/{bucket_name}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_object(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        path: Annotated[
            StrictStr, Field(..., description="URL-encoded path within a bucket.")
        ],
        **kwargs
    ) -> None:  # noqa: E501
        """Delete an object in a bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_object(bucket_name, path, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param path: URL-encoded path within a bucket. (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the delete_object_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.delete_object_with_http_info(
            bucket_name, path, **kwargs
        )  # noqa: E501

    @validate_arguments
    def delete_object_with_http_info(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        path: Annotated[
            StrictStr, Field(..., description="URL-encoded path within a bucket.")
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete an object in a bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_object_with_http_info(bucket_name, path, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param path: URL-encoded path within a bucket. (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["bucket_name", "path"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_object" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["bucket_name"]:
            _path_params["bucket_name"] = _params["bucket_name"]

        # process the query parameters
        _query_params = []
        if _params.get("path") is not None:  # noqa: E501
            _query_params.append(("path", _params["path"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/object/{bucket_name}/store",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_bucket(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        **kwargs
    ) -> Bucket:  # noqa: E501
        """Get a bucket summary  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bucket(bucket_name, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Bucket
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the get_bucket_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.get_bucket_with_http_info(bucket_name, **kwargs)  # noqa: E501

    @validate_arguments
    def get_bucket_with_http_info(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a bucket summary  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bucket_with_http_info(bucket_name, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Bucket, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["bucket_name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bucket" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["bucket_name"]:
            _path_params["bucket_name"] = _params["bucket_name"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "Bucket",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/object/{bucket_name}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_object(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        path: Annotated[
            StrictStr, Field(..., description="URL-encoded path within a bucket.")
        ],
        **kwargs
    ) -> bytearray:  # noqa: E501
        """Get an object in a bucket or list under a prefix  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_object(bucket_name, path, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param path: URL-encoded path within a bucket. (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the get_object_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.get_object_with_http_info(bucket_name, path, **kwargs)  # noqa: E501

    @validate_arguments
    def get_object_with_http_info(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        path: Annotated[
            StrictStr, Field(..., description="URL-encoded path within a bucket.")
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get an object in a bucket or list under a prefix  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_object_with_http_info(bucket_name, path, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param path: URL-encoded path within a bucket. (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["bucket_name", "path"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_object" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["bucket_name"]:
            _path_params["bucket_name"] = _params["bucket_name"]

        # process the query parameters
        _query_params = []
        if _params.get("path") is not None:  # noqa: E501
            _query_params.append(("path", _params["path"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "bytearray",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/object/{bucket_name}/store",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_buckets(self, **kwargs) -> Dict[str, Bucket]:  # noqa: E501
        """Get list of all buckets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_buckets(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, Bucket]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the list_buckets_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.list_buckets_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def list_buckets_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Get list of all buckets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_buckets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, Bucket], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_buckets" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "Dict[str, Bucket]",
            "400": "Error",
            "401": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/object",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_objects(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        path: Annotated[
            StrictStr, Field(..., description="URL-encoded path within a bucket.")
        ],
        **kwargs
    ) -> List[ObjectStat]:  # noqa: E501
        """Get an object in a bucket or list under a prefix  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_objects(bucket_name, path, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param path: URL-encoded path within a bucket. (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[ObjectStat]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the list_objects_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.list_objects_with_http_info(
            bucket_name, path, **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_objects_with_http_info(
        self,
        bucket_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        path: Annotated[
            StrictStr, Field(..., description="URL-encoded path within a bucket.")
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get an object in a bucket or list under a prefix  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_objects_with_http_info(bucket_name, path, async_req=True)
        >>> result = thread.get()

        :param bucket_name: Name of a bucket, must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type bucket_name: str
        :param path: URL-encoded path within a bucket. (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[ObjectStat], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["bucket_name", "path"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_objects" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["bucket_name"]:
            _path_params["bucket_name"] = _params["bucket_name"]

        # process the query parameters
        _query_params = []
        if _params.get("path") is not None:  # noqa: E501
            _query_params.append(("path", _params["path"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "List[ObjectStat]",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/object/{bucket_name}/list",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
