# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from typing_extensions import Annotated
from pydantic import Field, StrictBytes, StrictStr, constr, validator

from typing import List, Optional, Union

from seaplane.gen.carrier.models.get_store200_response import GetStore200Response
from seaplane.gen.carrier.models.key_value_config import KeyValueConfig

from seaplane.gen.carrier.api_client import ApiClient
from seaplane.gen.carrier.api_response import ApiResponse
from seaplane.gen.carrier.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class KeyValueApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_store(
        self,
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        key_value_config: Optional[KeyValueConfig] = None,
        **kwargs
    ) -> None:  # noqa: E501
        """Create a new key-value store.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_store(kv_store, key_value_config, async_req=True)
        >>> result = thread.get()

        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param key_value_config:
        :type key_value_config: KeyValueConfig
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the create_store_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.create_store_with_http_info(
            kv_store, key_value_config, **kwargs
        )  # noqa: E501

    @validate_arguments
    def create_store_with_http_info(
        self,
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        key_value_config: Optional[KeyValueConfig] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Create a new key-value store.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_store_with_http_info(kv_store, key_value_config, async_req=True)
        >>> result = thread.get()

        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param key_value_config:
        :type key_value_config: KeyValueConfig
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["kv_store", "key_value_config"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_store" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["kv_store"]:
            _path_params["kv_store"] = _params["kv_store"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["key_value_config"] is not None:
            _body_params = _params["key_value_config"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/kv/{kv_store}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_key(
        self,
        key: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key in the key-value store."),
        ],
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        if_match: Annotated[
            Optional[constr(strict=True, max_length=128, min_length=1)],
            Field(
                description="The ETag value to delete. If omitted will delete any value encountered at that key name."
            ),
        ] = None,
        purge: Annotated[
            Optional[StrictStr],
            Field(
                description='Whether or not to delete all history related to a key. A "false" value (default) means that previous versions will be retained & visible if the key is recreated.'
            ),
        ] = None,
        **kwargs
    ) -> None:  # noqa: E501
        """Remove an entry from the key-value store.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_key(key, kv_store, if_match, purge, async_req=True)
        >>> result = thread.get()

        :param key: Name of a key in the key-value store. (required)
        :type key: str
        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param if_match: The ETag value to delete. If omitted will delete any value encountered at that key name.
        :type if_match: str
        :param purge: Whether or not to delete all history related to a key. A \"false\" value (default) means that previous versions will be retained & visible if the key is recreated.
        :type purge: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the delete_key_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.delete_key_with_http_info(
            key, kv_store, if_match, purge, **kwargs
        )  # noqa: E501

    @validate_arguments
    def delete_key_with_http_info(
        self,
        key: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key in the key-value store."),
        ],
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        if_match: Annotated[
            Optional[constr(strict=True, max_length=128, min_length=1)],
            Field(
                description="The ETag value to delete. If omitted will delete any value encountered at that key name."
            ),
        ] = None,
        purge: Annotated[
            Optional[StrictStr],
            Field(
                description='Whether or not to delete all history related to a key. A "false" value (default) means that previous versions will be retained & visible if the key is recreated.'
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Remove an entry from the key-value store.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_key_with_http_info(key, kv_store, if_match, purge, async_req=True)
        >>> result = thread.get()

        :param key: Name of a key in the key-value store. (required)
        :type key: str
        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param if_match: The ETag value to delete. If omitted will delete any value encountered at that key name.
        :type if_match: str
        :param purge: Whether or not to delete all history related to a key. A \"false\" value (default) means that previous versions will be retained & visible if the key is recreated.
        :type purge: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["key", "kv_store", "if_match", "purge"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_key" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["key"]:
            _path_params["key"] = _params["key"]

        if _params["kv_store"]:
            _path_params["kv_store"] = _params["kv_store"]

        # process the query parameters
        _query_params = []
        if _params.get("purge") is not None:  # noqa: E501
            _query_params.append(("purge", _params["purge"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        if _params["if_match"]:
            _header_params["If-Match"] = _params["if_match"]

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/kv/{kv_store}/key/{key}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_store(
        self,
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        **kwargs
    ) -> None:  # noqa: E501
        """Deletes an existing key-value store.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_store(kv_store, async_req=True)
        >>> result = thread.get()

        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the delete_store_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.delete_store_with_http_info(kv_store, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_store_with_http_info(
        self,
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Deletes an existing key-value store.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_store_with_http_info(kv_store, async_req=True)
        >>> result = thread.get()

        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["kv_store"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_store" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["kv_store"]:
            _path_params["kv_store"] = _params["kv_store"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/kv/{kv_store}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_key(
        self,
        key: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key in the key-value store."),
        ],
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        if_match: Annotated[
            Optional[constr(strict=True, max_length=128, min_length=1)],
            Field(
                description="The Etag version of the value to get. If omitted will retrieve the latest version."
            ),
        ] = None,
        **kwargs
    ) -> bytearray:  # noqa: E501
        """Get a Key-Value entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_key(key, kv_store, if_match, async_req=True)
        >>> result = thread.get()

        :param key: Name of a key in the key-value store. (required)
        :type key: str
        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param if_match: The Etag version of the value to get. If omitted will retrieve the latest version.
        :type if_match: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the get_key_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.get_key_with_http_info(
            key, kv_store, if_match, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_key_with_http_info(
        self,
        key: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key in the key-value store."),
        ],
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        if_match: Annotated[
            Optional[constr(strict=True, max_length=128, min_length=1)],
            Field(
                description="The Etag version of the value to get. If omitted will retrieve the latest version."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a Key-Value entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_key_with_http_info(key, kv_store, if_match, async_req=True)
        >>> result = thread.get()

        :param key: Name of a key in the key-value store. (required)
        :type key: str
        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param if_match: The Etag version of the value to get. If omitted will retrieve the latest version.
        :type if_match: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["key", "kv_store", "if_match"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_key" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["key"]:
            _path_params["key"] = _params["key"]

        if _params["kv_store"]:
            _path_params["kv_store"] = _params["kv_store"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        if _params["if_match"]:
            _header_params["If-Match"] = _params["if_match"]

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "bytearray",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/kv/{kv_store}/key/{key}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_store(
        self,
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        **kwargs
    ) -> GetStore200Response:  # noqa: E501
        """Get information about a Key-Value store  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_store(kv_store, async_req=True)
        >>> result = thread.get()

        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStore200Response
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the get_store_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.get_store_with_http_info(kv_store, **kwargs)  # noqa: E501

    @validate_arguments
    def get_store_with_http_info(
        self,
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get information about a Key-Value store  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_store_with_http_info(kv_store, async_req=True)
        >>> result = thread.get()

        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStore200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["kv_store"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_store" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["kv_store"]:
            _path_params["kv_store"] = _params["kv_store"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "GetStore200Response",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/kv/{kv_store}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_keys(
        self,
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        **kwargs
    ) -> List[str]:  # noqa: E501
        """Get the list of keys currently in a store.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_keys(kv_store, async_req=True)
        >>> result = thread.get()

        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[str]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the list_keys_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.list_keys_with_http_info(kv_store, **kwargs)  # noqa: E501

    @validate_arguments
    def list_keys_with_http_info(
        self,
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get the list of keys currently in a store.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_keys_with_http_info(kv_store, async_req=True)
        >>> result = thread.get()

        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[str], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["kv_store"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_keys" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["kv_store"]:
            _path_params["kv_store"] = _params["kv_store"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "List[str]",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/kv/{kv_store}/key",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_stores(self, **kwargs) -> List[str]:  # noqa: E501
        """Get information about all Key-Value stores  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_stores(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[str]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the list_stores_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.list_stores_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def list_stores_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Get information about all Key-Value stores  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_stores_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[str], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_stores" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "List[str]",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/kv",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def put_key(
        self,
        key: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key in the key-value store."),
        ],
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        if_match: Annotated[
            Optional[constr(strict=True, max_length=128, min_length=1)],
            Field(
                description="The previous ETag value to replace. If omitted will unconditionally overwrite any existing value at that key."
            ),
        ] = None,
        if_not_match: Annotated[
            Optional[constr(strict=True)],
            Field(
                description="If set, then this will only create the key if it does not already exist."
            ),
        ] = None,
        body: Optional[Union[StrictBytes, StrictStr]] = None,
        **kwargs
    ) -> None:  # noqa: E501
        """Place an entry into the key-value store.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_key(key, kv_store, if_match, if_not_match, body, async_req=True)
        >>> result = thread.get()

        :param key: Name of a key in the key-value store. (required)
        :type key: str
        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param if_match: The previous ETag value to replace. If omitted will unconditionally overwrite any existing value at that key.
        :type if_match: str
        :param if_not_match: If set, then this will only create the key if it does not already exist.
        :type if_not_match: str
        :param body:
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the put_key_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.put_key_with_http_info(
            key, kv_store, if_match, if_not_match, body, **kwargs
        )  # noqa: E501

    @validate_arguments
    def put_key_with_http_info(
        self,
        key: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key in the key-value store."),
        ],
        kv_store: Annotated[
            constr(strict=True),
            Field(..., description="Name of a key-value store to operate on."),
        ],
        if_match: Annotated[
            Optional[constr(strict=True, max_length=128, min_length=1)],
            Field(
                description="The previous ETag value to replace. If omitted will unconditionally overwrite any existing value at that key."
            ),
        ] = None,
        if_not_match: Annotated[
            Optional[constr(strict=True)],
            Field(
                description="If set, then this will only create the key if it does not already exist."
            ),
        ] = None,
        body: Optional[Union[StrictBytes, StrictStr]] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Place an entry into the key-value store.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_key_with_http_info(key, kv_store, if_match, if_not_match, body, async_req=True)
        >>> result = thread.get()

        :param key: Name of a key in the key-value store. (required)
        :type key: str
        :param kv_store: Name of a key-value store to operate on. (required)
        :type kv_store: str
        :param if_match: The previous ETag value to replace. If omitted will unconditionally overwrite any existing value at that key.
        :type if_match: str
        :param if_not_match: If set, then this will only create the key if it does not already exist.
        :type if_not_match: str
        :param body:
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["key", "kv_store", "if_match", "if_not_match", "body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_key" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["key"]:
            _path_params["key"] = _params["key"]

        if _params["kv_store"]:
            _path_params["kv_store"] = _params["kv_store"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        if _params["if_match"]:
            _header_params["If-Match"] = _params["if_match"]

        if _params["if_not_match"]:
            _header_params["If-Not-Match"] = _params["if_not_match"]

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["body"] is not None:
            _body_params = _params["body"]
            # convert to byte array if the input is a file name (str)
            if isinstance(_body_params, str):
                with io.open(_body_params, "rb") as _fp:
                    _body_params_from_file = _fp.read()
                _body_params = _body_params_from_file

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/octet-stream"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/kv/{kv_store}/key/{key}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
