# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr, constr, validator

from typing import Dict, List, Optional

from seaplane.gen.carrier.models.flow import Flow
from seaplane.gen.carrier.models.secret import Secret

from seaplane.gen.carrier.api_client import ApiClient
from seaplane.gen.carrier.api_response import ApiResponse
from seaplane.gen.carrier.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class FlowApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_flow(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        flow: Annotated[Optional[Flow], Field(description="Flow definition")] = None,
        **kwargs
    ) -> None:  # noqa: E501
        """Create a Flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_flow(flow_name, region, flow, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param flow: Flow definition
        :type flow: Flow
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the create_flow_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.create_flow_with_http_info(
            flow_name, region, flow, **kwargs
        )  # noqa: E501

    @validate_arguments
    def create_flow_with_http_info(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        flow: Annotated[Optional[Flow], Field(description="Flow definition")] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Create a Flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_flow_with_http_info(flow_name, region, flow, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param flow: Flow definition
        :type flow: Flow
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["flow_name", "region", "flow"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_flow" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["flow_name"]:
            _path_params["flow_name"] = _params["flow_name"]

        # process the query parameters
        _query_params = []
        if _params.get("region") is not None:  # noqa: E501
            _query_params.append(("region", _params["region"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["flow"] is not None:
            _body_params = _params["flow"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/flow/{flow_name}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_flow(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> None:  # noqa: E501
        """Delete a Flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_flow(flow_name, region, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the delete_flow_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.delete_flow_with_http_info(
            flow_name, region, **kwargs
        )  # noqa: E501

    @validate_arguments
    def delete_flow_with_http_info(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete a Flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_flow_with_http_info(flow_name, region, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["flow_name", "region"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flow" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["flow_name"]:
            _path_params["flow_name"] = _params["flow_name"]

        # process the query parameters
        _query_params = []
        if _params.get("region") is not None:  # noqa: E501
            _query_params.append(("region", _params["region"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/flow/{flow_name}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_secret(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        secret_name: Annotated[
            constr(strict=True),
            Field(
                ...,
                description="Name of a secret, must be a valid shell variable name.",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> None:  # noqa: E501
        """Delete a single secret k/v.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_secret(flow_name, secret_name, region, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param secret_name: Name of a secret, must be a valid shell variable name. (required)
        :type secret_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the delete_secret_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.delete_secret_with_http_info(
            flow_name, secret_name, region, **kwargs
        )  # noqa: E501

    @validate_arguments
    def delete_secret_with_http_info(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        secret_name: Annotated[
            constr(strict=True),
            Field(
                ...,
                description="Name of a secret, must be a valid shell variable name.",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Delete a single secret k/v.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_secret_with_http_info(flow_name, secret_name, region, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param secret_name: Name of a secret, must be a valid shell variable name. (required)
        :type secret_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["flow_name", "secret_name", "region"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_secret" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["flow_name"]:
            _path_params["flow_name"] = _params["flow_name"]

        if _params["secret_name"]:
            _path_params["secret_name"] = _params["secret_name"]

        # process the query parameters
        _query_params = []
        if _params.get("region") is not None:  # noqa: E501
            _query_params.append(("region", _params["region"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/flow/{flow_name}/secrets/{secret_name}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_flow(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> Flow:  # noqa: E501
        """Get a Flow summary  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow(flow_name, region, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Flow
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the get_flow_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.get_flow_with_http_info(flow_name, region, **kwargs)  # noqa: E501

    @validate_arguments
    def get_flow_with_http_info(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get a Flow summary  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow_with_http_info(flow_name, region, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Flow, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["flow_name", "region"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["flow_name"]:
            _path_params["flow_name"] = _params["flow_name"]

        # process the query parameters
        _query_params = []
        if _params.get("region") is not None:  # noqa: E501
            _query_params.append(("region", _params["region"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "Flow",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/flow/{flow_name}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_flow_status(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> Dict[str, str]:  # noqa: E501
        """Get the status of a flow's composite allocations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow_status(flow_name, region, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, str]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the get_flow_status_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.get_flow_status_with_http_info(
            flow_name, region, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_flow_status_with_http_info(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get the status of a flow's composite allocations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_flow_status_with_http_info(flow_name, region, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, str], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["flow_name", "region"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_status" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["flow_name"]:
            _path_params["flow_name"] = _params["flow_name"]

        # process the query parameters
        _query_params = []
        if _params.get("region") is not None:  # noqa: E501
            _query_params.append(("region", _params["region"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "Dict[str, str]",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/flow/{flow_name}/status",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_secret(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        secret_name: Annotated[
            constr(strict=True),
            Field(
                ...,
                description="Name of a secret, must be a valid shell variable name.",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> Secret:  # noqa: E501
        """Get secret details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_secret(flow_name, secret_name, region, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param secret_name: Name of a secret, must be a valid shell variable name. (required)
        :type secret_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Secret
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the get_secret_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.get_secret_with_http_info(
            flow_name, secret_name, region, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_secret_with_http_info(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        secret_name: Annotated[
            constr(strict=True),
            Field(
                ...,
                description="Name of a secret, must be a valid shell variable name.",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get secret details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_secret_with_http_info(flow_name, secret_name, region, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param secret_name: Name of a secret, must be a valid shell variable name. (required)
        :type secret_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Secret, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["flow_name", "secret_name", "region"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_secret" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["flow_name"]:
            _path_params["flow_name"] = _params["flow_name"]

        if _params["secret_name"]:
            _path_params["secret_name"] = _params["secret_name"]

        # process the query parameters
        _query_params = []
        if _params.get("region") is not None:  # noqa: E501
            _query_params.append(("region", _params["region"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "Secret",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/flow/{flow_name}/secrets/{secret_name}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_flows(
        self,
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> List[str]:  # noqa: E501
        """Get list of all flows  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_flows(region, async_req=True)
        >>> result = thread.get()

        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[str]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the list_flows_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.list_flows_with_http_info(region, **kwargs)  # noqa: E501

    @validate_arguments
    def list_flows_with_http_info(
        self,
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get list of all flows  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_flows_with_http_info(region, async_req=True)
        >>> result = thread.get()

        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[str], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["region"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_flows" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get("region") is not None:  # noqa: E501
            _query_params.append(("region", _params["region"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "List[str]",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/flow",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_secrets(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> Dict[str, Secret]:  # noqa: E501
        """List all secrets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_secrets(flow_name, region, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, Secret]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the list_secrets_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.list_secrets_with_http_info(
            flow_name, region, **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_secrets_with_http_info(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """List all secrets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_secrets_with_http_info(flow_name, region, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, Secret], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["flow_name", "region"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_secrets" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["flow_name"]:
            _path_params["flow_name"] = _params["flow_name"]

        # process the query parameters
        _query_params = []
        if _params.get("region") is not None:  # noqa: E501
            _query_params.append(("region", _params["region"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "Dict[str, Secret]",
            "400": "Error",
            "401": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/flow/{flow_name}/secrets",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def set_secret(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        secret_name: Annotated[
            constr(strict=True),
            Field(
                ...,
                description="Name of a secret, must be a valid shell variable name.",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        secret: Annotated[Optional[Secret], Field(description="Secret value")] = None,
        **kwargs
    ) -> Secret:  # noqa: E501
        """Set the secret value  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_secret(flow_name, secret_name, region, secret, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param secret_name: Name of a secret, must be a valid shell variable name. (required)
        :type secret_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param secret: Secret value
        :type secret: Secret
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Secret
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the set_secret_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.set_secret_with_http_info(
            flow_name, secret_name, region, secret, **kwargs
        )  # noqa: E501

    @validate_arguments
    def set_secret_with_http_info(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        secret_name: Annotated[
            constr(strict=True),
            Field(
                ...,
                description="Name of a secret, must be a valid shell variable name.",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        secret: Annotated[Optional[Secret], Field(description="Secret value")] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Set the secret value  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_secret_with_http_info(flow_name, secret_name, region, secret, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param secret_name: Name of a secret, must be a valid shell variable name. (required)
        :type secret_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param secret: Secret value
        :type secret: Secret
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Secret, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["flow_name", "secret_name", "region", "secret"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_secret" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["flow_name"]:
            _path_params["flow_name"] = _params["flow_name"]

        if _params["secret_name"]:
            _path_params["secret_name"] = _params["secret_name"]

        # process the query parameters
        _query_params = []
        if _params.get("region") is not None:  # noqa: E501
            _query_params.append(("region", _params["region"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["secret"] is not None:
            _body_params = _params["secret"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "Secret",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/flow/{flow_name}/secrets/{secret_name}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def set_secrets(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        request_body: Annotated[
            Optional[Dict[str, Secret]], Field(description="Flow secrets manifest")
        ] = None,
        **kwargs
    ) -> Dict[str, Secret]:  # noqa: E501
        """Set all secrets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_secrets(flow_name, region, request_body, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param request_body: Flow secrets manifest
        :type request_body: Dict[str, Secret]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, Secret]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the set_secrets_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.set_secrets_with_http_info(
            flow_name, region, request_body, **kwargs
        )  # noqa: E501

    @validate_arguments
    def set_secrets_with_http_info(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        region: Annotated[
            Optional[StrictStr],
            Field(description="Flow region (TBD, not spec'd for product)."),
        ] = None,
        request_body: Annotated[
            Optional[Dict[str, Secret]], Field(description="Flow secrets manifest")
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Set all secrets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_secrets_with_http_info(flow_name, region, request_body, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param region: Flow region (TBD, not spec'd for product).
        :type region: str
        :param request_body: Flow secrets manifest
        :type request_body: Dict[str, Secret]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, Secret], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["flow_name", "region", "request_body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_secrets" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["flow_name"]:
            _path_params["flow_name"] = _params["flow_name"]

        # process the query parameters
        _query_params = []
        if _params.get("region") is not None:  # noqa: E501
            _query_params.append(("region", _params["region"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["request_body"] is not None:
            _body_params = _params["request_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "Dict[str, Secret]",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/flow/{flow_name}/secrets",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def stream_flow_events(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        last_event_id: Annotated[
            Optional[StrictInt],
            Field(
                description="Last Event ID as described in the SSE spec, if present, resume streaming at that ID. Negative offsets count back from the end, and a 0 offset starts at the very end (tail with -n 0)."
            ),
        ] = None,
        alloc: Annotated[
            Optional[constr(strict=True)],
            Field(description="Optionally filter to a specific alloc"),
        ] = None,
        output: Annotated[
            Optional[StrictStr],
            Field(description="Filter output (e.g. stderr vs stdout)"),
        ] = None,
        **kwargs
    ) -> str:  # noqa: E501
        """Stream flow events with SSE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stream_flow_events(flow_name, last_event_id, alloc, output, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param last_event_id: Last Event ID as described in the SSE spec, if present, resume streaming at that ID. Negative offsets count back from the end, and a 0 offset starts at the very end (tail with -n 0).
        :type last_event_id: int
        :param alloc: Optionally filter to a specific alloc
        :type alloc: str
        :param output: Filter output (e.g. stderr vs stdout)
        :type output: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the stream_flow_events_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.stream_flow_events_with_http_info(
            flow_name, last_event_id, alloc, output, **kwargs
        )  # noqa: E501

    @validate_arguments
    def stream_flow_events_with_http_info(
        self,
        flow_name: Annotated[
            constr(strict=True, max_length=32, min_length=1),
            Field(
                ...,
                description="Name of a Flow. Must be less than 32 characters long. ",
            ),
        ],
        last_event_id: Annotated[
            Optional[StrictInt],
            Field(
                description="Last Event ID as described in the SSE spec, if present, resume streaming at that ID. Negative offsets count back from the end, and a 0 offset starts at the very end (tail with -n 0)."
            ),
        ] = None,
        alloc: Annotated[
            Optional[constr(strict=True)],
            Field(description="Optionally filter to a specific alloc"),
        ] = None,
        output: Annotated[
            Optional[StrictStr],
            Field(description="Filter output (e.g. stderr vs stdout)"),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Stream flow events with SSE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stream_flow_events_with_http_info(flow_name, last_event_id, alloc, output, async_req=True)
        >>> result = thread.get()

        :param flow_name: Name of a Flow. Must be less than 32 characters long.  (required)
        :type flow_name: str
        :param last_event_id: Last Event ID as described in the SSE spec, if present, resume streaming at that ID. Negative offsets count back from the end, and a 0 offset starts at the very end (tail with -n 0).
        :type last_event_id: int
        :param alloc: Optionally filter to a specific alloc
        :type alloc: str
        :param output: Filter output (e.g. stderr vs stdout)
        :type output: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["flow_name", "last_event_id", "alloc", "output"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stream_flow_events" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["flow_name"]:
            _path_params["flow_name"] = _params["flow_name"]

        # process the query parameters
        _query_params = []
        if _params.get("alloc") is not None:  # noqa: E501
            _query_params.append(("alloc", _params["alloc"]))

        if _params.get("output") is not None:  # noqa: E501
            _query_params.append(("output", _params["output"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        if _params["last_event_id"]:
            _header_params["Last-Event-ID"] = _params["last_event_id"]

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["text/event-stream", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "str",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/flow/{flow_name}/events",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
