# coding: utf-8

"""
    Carrier API

    **Seaplane Global Messaging Service**  For information about authentication see [authentication](/docs/authentication)   # noqa: E501

    The version of the OpenAPI document: 1.0.0-beta
    Contact: support@seaplane.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from typing_extensions import Annotated
from pydantic import Field, StrictBytes, StrictStr, conlist, constr, validator

from typing import Dict, List, Optional, Union

from seaplane.gen.carrier.models.submit_to_endpoint201_response import (
    SubmitToEndpoint201Response,
)

from seaplane.gen.carrier.api_client import ApiClient
from seaplane.gen.carrier.api_response import ApiResponse
from seaplane.gen.carrier.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class EndpointApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_archive_from_endpoint(
        self,
        endpoint: Annotated[
            constr(strict=True, max_length=31, min_length=1),
            Field(
                ...,
                description="Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        message_id: Annotated[
            constr(strict=True),
            Field(
                ...,
                description="Seaplane-generated message ID, a request Id with an optional set of batch indices",
            ),
        ],
        pattern: Annotated[
            constr(strict=True), Field(..., description="message matching pattern")
        ],
        format: Annotated[
            StrictStr,
            Field(..., description="Archive format (json_array, ndjson, tar, etc.)"),
        ],
        **kwargs
    ) -> bytearray:  # noqa: E501
        """GET archive from a endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_archive_from_endpoint(endpoint, message_id, pattern, format, async_req=True)
        >>> result = thread.get()

        :param endpoint: Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type endpoint: str
        :param message_id: Seaplane-generated message ID, a request Id with an optional set of batch indices (required)
        :type message_id: str
        :param pattern: message matching pattern (required)
        :type pattern: str
        :param format: Archive format (json_array, ndjson, tar, etc.) (required)
        :type format: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the get_archive_from_endpoint_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.get_archive_from_endpoint_with_http_info(
            endpoint, message_id, pattern, format, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_archive_from_endpoint_with_http_info(
        self,
        endpoint: Annotated[
            constr(strict=True, max_length=31, min_length=1),
            Field(
                ...,
                description="Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        message_id: Annotated[
            constr(strict=True),
            Field(
                ...,
                description="Seaplane-generated message ID, a request Id with an optional set of batch indices",
            ),
        ],
        pattern: Annotated[
            constr(strict=True), Field(..., description="message matching pattern")
        ],
        format: Annotated[
            StrictStr,
            Field(..., description="Archive format (json_array, ndjson, tar, etc.)"),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """GET archive from a endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_archive_from_endpoint_with_http_info(endpoint, message_id, pattern, format, async_req=True)
        >>> result = thread.get()

        :param endpoint: Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type endpoint: str
        :param message_id: Seaplane-generated message ID, a request Id with an optional set of batch indices (required)
        :type message_id: str
        :param pattern: message matching pattern (required)
        :type pattern: str
        :param format: Archive format (json_array, ndjson, tar, etc.) (required)
        :type format: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["endpoint", "message_id", "pattern", "format"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_archive_from_endpoint" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["endpoint"]:
            _path_params["endpoint"] = _params["endpoint"]

        if _params["message_id"]:
            _path_params["message_id"] = _params["message_id"]

        # process the query parameters
        _query_params = []
        if _params.get("pattern") is not None:  # noqa: E501
            _query_params.append(("pattern", _params["pattern"]))

        if _params.get("format") is not None:  # noqa: E501
            _query_params.append(("format", _params["format"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "bytearray",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/endpoints/{endpoint}/response/{message_id}/archive",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_from_endpoint(
        self,
        endpoint: Annotated[
            constr(strict=True, max_length=31, min_length=1),
            Field(
                ...,
                description="Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        message_id: Annotated[
            constr(strict=True),
            Field(
                ...,
                description="Seaplane-generated message ID, a request Id with an optional set of batch indices",
            ),
        ],
        **kwargs
    ) -> bytearray:  # noqa: E501
        """GET data from a endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_from_endpoint(endpoint, message_id, async_req=True)
        >>> result = thread.get()

        :param endpoint: Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type endpoint: str
        :param message_id: Seaplane-generated message ID, a request Id with an optional set of batch indices (required)
        :type message_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the get_from_endpoint_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.get_from_endpoint_with_http_info(
            endpoint, message_id, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_from_endpoint_with_http_info(
        self,
        endpoint: Annotated[
            constr(strict=True, max_length=31, min_length=1),
            Field(
                ...,
                description="Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        message_id: Annotated[
            constr(strict=True),
            Field(
                ...,
                description="Seaplane-generated message ID, a request Id with an optional set of batch indices",
            ),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """GET data from a endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_from_endpoint_with_http_info(endpoint, message_id, async_req=True)
        >>> result = thread.get()

        :param endpoint: Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type endpoint: str
        :param message_id: Seaplane-generated message ID, a request Id with an optional set of batch indices (required)
        :type message_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["endpoint", "message_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_from_endpoint" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["endpoint"]:
            _path_params["endpoint"] = _params["endpoint"]

        if _params["message_id"]:
            _path_params["message_id"] = _params["message_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/problem+json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "200": "bytearray",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/endpoints/{endpoint}/response/{message_id}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def submit_to_endpoint(
        self,
        endpoint: Annotated[
            constr(strict=True, max_length=31, min_length=1),
            Field(
                ...,
                description="Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        x_meta_data: Annotated[
            Optional[Dict[str, conlist(constr(strict=True))]],
            Field(description="Message metadata"),
        ] = None,
        body: Optional[Union[StrictBytes, StrictStr]] = None,
        **kwargs
    ) -> SubmitToEndpoint201Response:  # noqa: E501
        """Create a endpoint request (i.e. ingress)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_to_endpoint(endpoint, x_meta_data, body, async_req=True)
        >>> result = thread.get()

        :param endpoint: Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type endpoint: str
        :param x_meta_data: Message metadata
        :type x_meta_data: Dict[str, List[str]]
        :param body:
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SubmitToEndpoint201Response
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            raise ValueError(
                "Error! Please call the submit_to_endpoint_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            )
        return self.submit_to_endpoint_with_http_info(
            endpoint, x_meta_data, body, **kwargs
        )  # noqa: E501

    @validate_arguments
    def submit_to_endpoint_with_http_info(
        self,
        endpoint: Annotated[
            constr(strict=True, max_length=31, min_length=1),
            Field(
                ...,
                description="Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).",
            ),
        ],
        x_meta_data: Annotated[
            Optional[Dict[str, conlist(constr(strict=True))]],
            Field(description="Message metadata"),
        ] = None,
        body: Optional[Union[StrictBytes, StrictStr]] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Create a endpoint request (i.e. ingress)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_to_endpoint_with_http_info(endpoint, x_meta_data, body, async_req=True)
        >>> result = thread.get()

        :param endpoint: Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting). (required)
        :type endpoint: str
        :param x_meta_data: Message metadata
        :type x_meta_data: Dict[str, List[str]]
        :param body:
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SubmitToEndpoint201Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["endpoint", "x_meta_data", "body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_to_endpoint" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["endpoint"]:
            _path_params["endpoint"] = _params["endpoint"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        if _params["x_meta_data"]:
            _header_params["X-Meta-Data"] = _params["x_meta_data"]

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["body"] is not None:
            _body_params = _params["body"]
            # convert to byte array if the input is a file name (str)
            if isinstance(_body_params, str):
                with io.open(_body_params, "rb") as _fp:
                    _body_params_from_file = _fp.read()
                _body_params = _body_params_from_file

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/octet-stream"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BasicAuth"]  # noqa: E501

        _response_types_map = {
            "201": "SubmitToEndpoint201Response",
            "400": "Error",
            "401": "Error",
            "404": "Error",
            "503": "Error",
            "5XX": "Error",
        }

        return self.api_client.call_api(
            "/endpoints/{endpoint}/request",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
