# seaplane.api
**Seaplane Global Messaging Service**

For information about authentication see [authentication](/docs/authentication)


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0-beta
- Package version: 0.0.14.beta3
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import seaplane.gen.carrier
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import seaplane.gen.carrier
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import seaplane.gen.carrier
from seaplane.gen.carrier.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://carrier.cplane.cloud/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = seaplane.gen.carrier.Configuration(
    host = "https://carrier.cplane.cloud/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BasicAuth
configuration = seaplane.gen.carrier.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with seaplane.gen.carrier.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = seaplane.gen.carrier.EndpointApi(api_client)
    endpoint = 'pipe-123' # str | Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).
    message_id = 'abcf8181-f54d-412a-b708-86b8a0c38e90.1.2' # str | Seaplane-generated message ID, a request Id with an optional set of batch indices
    pattern = '.*' # str | message matching pattern
    format = 'json_array' # str | Archive format (json_array, ndjson, tar, etc.)

    try:
        # GET archive from a endpoint
        api_response = api_instance.get_archive_from_endpoint(endpoint, message_id, pattern, format)
        print("The response of EndpointApi->get_archive_from_endpoint:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling EndpointApi->get_archive_from_endpoint: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://carrier.cplane.cloud/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*EndpointApi* | [**get_archive_from_endpoint**](docs/EndpointApi.md#get_archive_from_endpoint) | **GET** /endpoints/{endpoint}/response/{message_id}/archive | GET archive from a endpoint
*EndpointApi* | [**get_from_endpoint**](docs/EndpointApi.md#get_from_endpoint) | **GET** /endpoints/{endpoint}/response/{message_id} | GET data from a endpoint
*EndpointApi* | [**submit_to_endpoint**](docs/EndpointApi.md#submit_to_endpoint) | **POST** /endpoints/{endpoint}/request | Create a endpoint request (i.e. ingress)
*FlowApi* | [**create_flow**](docs/FlowApi.md#create_flow) | **PUT** /flow/{flow_name} | Create a Flow
*FlowApi* | [**delete_flow**](docs/FlowApi.md#delete_flow) | **DELETE** /flow/{flow_name} | Delete a Flow
*FlowApi* | [**delete_secret**](docs/FlowApi.md#delete_secret) | **DELETE** /flow/{flow_name}/secrets/{secret_name} | Delete a single secret k/v.
*FlowApi* | [**get_flow**](docs/FlowApi.md#get_flow) | **GET** /flow/{flow_name} | Get a Flow summary
*FlowApi* | [**get_flow_status**](docs/FlowApi.md#get_flow_status) | **GET** /flow/{flow_name}/status | Get the status of a flow&#39;s composite allocations
*FlowApi* | [**get_secret**](docs/FlowApi.md#get_secret) | **GET** /flow/{flow_name}/secrets/{secret_name} | Get secret details
*FlowApi* | [**list_flows**](docs/FlowApi.md#list_flows) | **GET** /flow | Get list of all flows
*FlowApi* | [**list_secrets**](docs/FlowApi.md#list_secrets) | **GET** /flow/{flow_name}/secrets | List all secrets
*FlowApi* | [**set_secret**](docs/FlowApi.md#set_secret) | **PUT** /flow/{flow_name}/secrets/{secret_name} | Set the secret value
*FlowApi* | [**set_secrets**](docs/FlowApi.md#set_secrets) | **PUT** /flow/{flow_name}/secrets | Set all secrets
*FlowApi* | [**stream_flow_events**](docs/FlowApi.md#stream_flow_events) | **GET** /flow/{flow_name}/events | Stream flow events with SSE
*KeyValueApi* | [**create_store**](docs/KeyValueApi.md#create_store) | **PUT** /kv/{kv_store} | Create a new key-value store.
*KeyValueApi* | [**delete_key**](docs/KeyValueApi.md#delete_key) | **DELETE** /kv/{kv_store}/key/{key} | Remove an entry from the key-value store.
*KeyValueApi* | [**delete_store**](docs/KeyValueApi.md#delete_store) | **DELETE** /kv/{kv_store} | Deletes an existing key-value store.
*KeyValueApi* | [**get_key**](docs/KeyValueApi.md#get_key) | **GET** /kv/{kv_store}/key/{key} | Get a Key-Value entry
*KeyValueApi* | [**get_store**](docs/KeyValueApi.md#get_store) | **GET** /kv/{kv_store} | Get information about a Key-Value store
*KeyValueApi* | [**list_keys**](docs/KeyValueApi.md#list_keys) | **GET** /kv/{kv_store}/key | Get the list of keys currently in a store.
*KeyValueApi* | [**list_stores**](docs/KeyValueApi.md#list_stores) | **GET** /kv | Get information about all Key-Value stores
*KeyValueApi* | [**put_key**](docs/KeyValueApi.md#put_key) | **PUT** /kv/{kv_store}/key/{key} | Place an entry into the key-value store.
*ObjectApi* | [**create_bucket**](docs/ObjectApi.md#create_bucket) | **PUT** /object/{bucket_name} | Create a Bucket
*ObjectApi* | [**create_object**](docs/ObjectApi.md#create_object) | **PUT** /object/{bucket_name}/store | Create an object in a bucket
*ObjectApi* | [**delete_bucket**](docs/ObjectApi.md#delete_bucket) | **DELETE** /object/{bucket_name} | Delete a bucket
*ObjectApi* | [**delete_object**](docs/ObjectApi.md#delete_object) | **DELETE** /object/{bucket_name}/store | Delete an object in a bucket
*ObjectApi* | [**get_bucket**](docs/ObjectApi.md#get_bucket) | **GET** /object/{bucket_name} | Get a bucket summary
*ObjectApi* | [**get_object**](docs/ObjectApi.md#get_object) | **GET** /object/{bucket_name}/store | Get an object in a bucket or list under a prefix
*ObjectApi* | [**list_buckets**](docs/ObjectApi.md#list_buckets) | **GET** /object | Get list of all buckets
*ObjectApi* | [**list_objects**](docs/ObjectApi.md#list_objects) | **GET** /object/{bucket_name}/list | Get an object in a bucket or list under a prefix
*StreamApi* | [**create_stream**](docs/StreamApi.md#create_stream) | **PUT** /stream/{stream_name} | Create a new stream
*StreamApi* | [**delete_stream**](docs/StreamApi.md#delete_stream) | **DELETE** /stream/{stream_name} | Delete a stream
*StreamApi* | [**get_stream**](docs/StreamApi.md#get_stream) | **GET** /stream/{stream_name} | Get the details of a stream
*StreamApi* | [**list_streams**](docs/StreamApi.md#list_streams) | **GET** /stream | Get list of all streams
*WebhookApi* | [**receive_webhook**](docs/WebhookApi.md#receive_webhook) | **POST** /webhook/{provider}/{division} | Accepts a webhook from an async AI request


## Documentation For Models

 - [AzureBlobStorageOutput](docs/AzureBlobStorageOutput.md)
 - [Bucket](docs/Bucket.md)
 - [CarrierInput](docs/CarrierInput.md)
 - [CarrierInputConfig](docs/CarrierInputConfig.md)
 - [CarrierOutput](docs/CarrierOutput.md)
 - [CarrierStream](docs/CarrierStream.md)
 - [CarrierStreamDetails](docs/CarrierStreamDetails.md)
 - [CarrierStreamOptions](docs/CarrierStreamOptions.md)
 - [Cors](docs/Cors.md)
 - [DockerProcessor](docs/DockerProcessor.md)
 - [DockerProcessorDocker](docs/DockerProcessorDocker.md)
 - [Error](docs/Error.md)
 - [Flow](docs/Flow.md)
 - [GetStore200Response](docs/GetStore200Response.md)
 - [HTTPServer](docs/HTTPServer.md)
 - [HTTPServerHttpServer](docs/HTTPServerHttpServer.md)
 - [HttpClientOutput](docs/HttpClientOutput.md)
 - [Input](docs/Input.md)
 - [KeyValueConfig](docs/KeyValueConfig.md)
 - [MetadataHeaders](docs/MetadataHeaders.md)
 - [ObjectStat](docs/ObjectStat.md)
 - [Output](docs/Output.md)
 - [Processor](docs/Processor.md)
 - [Secret](docs/Secret.md)
 - [SqlRaw](docs/SqlRaw.md)
 - [SubmitToEndpoint201Response](docs/SubmitToEndpoint201Response.md)
 - [Switch](docs/Switch.md)
 - [SwitchCasesInner](docs/SwitchCasesInner.md)
 - [SwitchCasesInnerOutput](docs/SwitchCasesInnerOutput.md)
 - [SyncResponse](docs/SyncResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BasicAuth"></a>
### BasicAuth

- **Type**: Bearer authentication


## Author

support@seaplane.io


