# apicurioregistryclient
Apicurio Registry is a datastore for standard event schemas and API designs. Apicurio Registry enables developers to manage and share the structure of their data using a REST interface. For example, client applications can dynamically push or pull the latest updates to or from the registry without needing to redeploy. Apicurio Registry also enables developers to create rules that govern how registry content can evolve over time. For example, this includes rules for content validation and version compatibility.

The Apicurio Registry REST API enables client applications to manage the artifacts in the registry. This API provides create, read, update, and delete operations for schema and API artifacts, rules, versions, and metadata. 

The supported artifact types include:
- Apache Avro schema
- AsyncAPI specification
- Google protocol buffers
- GraphQL schema
- JSON Schema
- Kafka Connect schema
- OpenAPI specification
- Web Services Description Language
- XML Schema Definition


**Important**: The Apicurio Registry REST API is available from `https://MY-REGISTRY-URL/apis/registry/v2` by default. Therefore you must prefix all API operation paths with `../apis/registry/v2` in this case. For example: `../apis/registry/v2/ids/globalIds/{globalId}`.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.2.0.Final
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://github.com/apicurio/apicurio-registry](https://github.com/apicurio/apicurio-registry)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/Apicurio/apicurio-registry-client-sdk-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/Apicurio/apicurio-registry-client-sdk-python.git`)

Then import the package:
```python
import apicurioregistryclient
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import apicurioregistryclient
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import apicurioregistryclient
from pprint import pprint
from apicurioregistryclient.api import admin_api
from apicurioregistryclient.model.error import Error
from apicurioregistryclient.model.log_configuration import LogConfiguration
from apicurioregistryclient.model.named_log_configuration import NamedLogConfiguration
from apicurioregistryclient.model.role_mapping import RoleMapping
from apicurioregistryclient.model.rule import Rule
from apicurioregistryclient.model.rule_type import RuleType
from apicurioregistryclient.model.update_role import UpdateRole
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = apicurioregistryclient.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with apicurioregistryclient.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = admin_api.AdminApi(api_client)
    rule = Rule(
        config="config_example",
        type=RuleType("VALIDITY"),
    ) # Rule | 

    try:
        # Create global rule
        api_instance.create_global_rule(rule)
    except apicurioregistryclient.ApiException as e:
        print("Exception when calling AdminApi->create_global_rule: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminApi* | [**create_global_rule**](docs/AdminApi.md#create_global_rule) | **POST** /admin/rules | Create global rule
*AdminApi* | [**create_role_mapping**](docs/AdminApi.md#create_role_mapping) | **POST** /admin/roleMappings | Create a new role mapping
*AdminApi* | [**delete_all_global_rules**](docs/AdminApi.md#delete_all_global_rules) | **DELETE** /admin/rules | Delete all global rules
*AdminApi* | [**delete_global_rule**](docs/AdminApi.md#delete_global_rule) | **DELETE** /admin/rules/{rule} | Delete global rule
*AdminApi* | [**delete_role_mapping**](docs/AdminApi.md#delete_role_mapping) | **DELETE** /admin/roleMappings/{principalId} | Delete a role mapping
*AdminApi* | [**export_data**](docs/AdminApi.md#export_data) | **GET** /admin/export | Export registry data
*AdminApi* | [**get_global_rule_config**](docs/AdminApi.md#get_global_rule_config) | **GET** /admin/rules/{rule} | Get global rule configuration
*AdminApi* | [**get_log_configuration**](docs/AdminApi.md#get_log_configuration) | **GET** /admin/loggers/{logger} | Get a single logger configuration
*AdminApi* | [**get_role_mapping**](docs/AdminApi.md#get_role_mapping) | **GET** /admin/roleMappings/{principalId} | Return a single role mapping
*AdminApi* | [**import_data**](docs/AdminApi.md#import_data) | **POST** /admin/import | Import registry data
*AdminApi* | [**list_global_rules**](docs/AdminApi.md#list_global_rules) | **GET** /admin/rules | List global rules
*AdminApi* | [**list_log_configurations**](docs/AdminApi.md#list_log_configurations) | **GET** /admin/loggers | List logging configurations
*AdminApi* | [**list_role_mappings**](docs/AdminApi.md#list_role_mappings) | **GET** /admin/roleMappings | List all role mappings
*AdminApi* | [**remove_log_configuration**](docs/AdminApi.md#remove_log_configuration) | **DELETE** /admin/loggers/{logger} | Removes logger configuration
*AdminApi* | [**set_log_configuration**](docs/AdminApi.md#set_log_configuration) | **PUT** /admin/loggers/{logger} | Set a logger&#39;s configuration
*AdminApi* | [**update_global_rule_config**](docs/AdminApi.md#update_global_rule_config) | **PUT** /admin/rules/{rule} | Update global rule configuration
*AdminApi* | [**update_role_mapping**](docs/AdminApi.md#update_role_mapping) | **PUT** /admin/roleMappings/{principalId} | Update a role mapping
*ArtifactRulesApi* | [**create_artifact_rule**](docs/ArtifactRulesApi.md#create_artifact_rule) | **POST** /groups/{groupId}/artifacts/{artifactId}/rules | Create artifact rule
*ArtifactRulesApi* | [**delete_artifact_rule**](docs/ArtifactRulesApi.md#delete_artifact_rule) | **DELETE** /groups/{groupId}/artifacts/{artifactId}/rules/{rule} | Delete artifact rule
*ArtifactRulesApi* | [**delete_artifact_rules**](docs/ArtifactRulesApi.md#delete_artifact_rules) | **DELETE** /groups/{groupId}/artifacts/{artifactId}/rules | Delete artifact rules
*ArtifactRulesApi* | [**get_artifact_rule_config**](docs/ArtifactRulesApi.md#get_artifact_rule_config) | **GET** /groups/{groupId}/artifacts/{artifactId}/rules/{rule} | Get artifact rule configuration
*ArtifactRulesApi* | [**list_artifact_rules**](docs/ArtifactRulesApi.md#list_artifact_rules) | **GET** /groups/{groupId}/artifacts/{artifactId}/rules | List artifact rules
*ArtifactRulesApi* | [**test_update_artifact**](docs/ArtifactRulesApi.md#test_update_artifact) | **PUT** /groups/{groupId}/artifacts/{artifactId}/test | Test update artifact
*ArtifactRulesApi* | [**update_artifact_rule_config**](docs/ArtifactRulesApi.md#update_artifact_rule_config) | **PUT** /groups/{groupId}/artifacts/{artifactId}/rules/{rule} | Update artifact rule configuration
*ArtifactsApi* | [**create_artifact**](docs/ArtifactsApi.md#create_artifact) | **POST** /groups/{groupId}/artifacts | Create artifact
*ArtifactsApi* | [**delete_artifact**](docs/ArtifactsApi.md#delete_artifact) | **DELETE** /groups/{groupId}/artifacts/{artifactId} | Delete artifact
*ArtifactsApi* | [**delete_artifacts_in_group**](docs/ArtifactsApi.md#delete_artifacts_in_group) | **DELETE** /groups/{groupId}/artifacts | Deletes all artifacts in a group
*ArtifactsApi* | [**get_content_by_global_id**](docs/ArtifactsApi.md#get_content_by_global_id) | **GET** /ids/globalIds/{globalId} | Get artifact by global ID
*ArtifactsApi* | [**get_content_by_hash**](docs/ArtifactsApi.md#get_content_by_hash) | **GET** /ids/contentHashes/{contentHash}/ | Get artifact content by SHA-256 hash
*ArtifactsApi* | [**get_content_by_id**](docs/ArtifactsApi.md#get_content_by_id) | **GET** /ids/contentIds/{contentId}/ | Get artifact content by ID
*ArtifactsApi* | [**get_latest_artifact**](docs/ArtifactsApi.md#get_latest_artifact) | **GET** /groups/{groupId}/artifacts/{artifactId} | Get latest artifact
*ArtifactsApi* | [**list_artifacts_in_group**](docs/ArtifactsApi.md#list_artifacts_in_group) | **GET** /groups/{groupId}/artifacts | List artifacts in group
*ArtifactsApi* | [**search_artifacts**](docs/ArtifactsApi.md#search_artifacts) | **GET** /search/artifacts | Search for artifacts
*ArtifactsApi* | [**search_artifacts_by_content**](docs/ArtifactsApi.md#search_artifacts_by_content) | **POST** /search/artifacts | Search for artifacts by content
*ArtifactsApi* | [**update_artifact**](docs/ArtifactsApi.md#update_artifact) | **PUT** /groups/{groupId}/artifacts/{artifactId} | Update artifact
*ArtifactsApi* | [**update_artifact_state**](docs/ArtifactsApi.md#update_artifact_state) | **PUT** /groups/{groupId}/artifacts/{artifactId}/state | Update artifact state
*MetadataApi* | [**delete_artifact_version_meta_data**](docs/MetadataApi.md#delete_artifact_version_meta_data) | **DELETE** /groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta | Delete artifact version metadata
*MetadataApi* | [**get_artifact_meta_data**](docs/MetadataApi.md#get_artifact_meta_data) | **GET** /groups/{groupId}/artifacts/{artifactId}/meta | Get artifact metadata
*MetadataApi* | [**get_artifact_version_meta_data**](docs/MetadataApi.md#get_artifact_version_meta_data) | **GET** /groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta | Get artifact version metadata
*MetadataApi* | [**get_artifact_version_meta_data_by_content**](docs/MetadataApi.md#get_artifact_version_meta_data_by_content) | **POST** /groups/{groupId}/artifacts/{artifactId}/meta | Get artifact version metadata by content
*MetadataApi* | [**update_artifact_meta_data**](docs/MetadataApi.md#update_artifact_meta_data) | **PUT** /groups/{groupId}/artifacts/{artifactId}/meta | Update artifact metadata
*MetadataApi* | [**update_artifact_version_meta_data**](docs/MetadataApi.md#update_artifact_version_meta_data) | **PUT** /groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta | Update artifact version metadata
*SystemApi* | [**get_system_info**](docs/SystemApi.md#get_system_info) | **GET** /system/info | Get system information
*UsersApi* | [**get_current_user_info**](docs/UsersApi.md#get_current_user_info) | **GET** /users/me | Get current user
*VersionsApi* | [**create_artifact_version**](docs/VersionsApi.md#create_artifact_version) | **POST** /groups/{groupId}/artifacts/{artifactId}/versions | Create artifact version
*VersionsApi* | [**get_artifact_version**](docs/VersionsApi.md#get_artifact_version) | **GET** /groups/{groupId}/artifacts/{artifactId}/versions/{version} | Get artifact version
*VersionsApi* | [**list_artifact_versions**](docs/VersionsApi.md#list_artifact_versions) | **GET** /groups/{groupId}/artifacts/{artifactId}/versions | List artifact versions
*VersionsApi* | [**update_artifact_version_state**](docs/VersionsApi.md#update_artifact_version_state) | **PUT** /groups/{groupId}/artifacts/{artifactId}/versions/{version}/state | Update artifact version state


## Documentation For Models

 - [ArtifactMetaData](docs/ArtifactMetaData.md)
 - [ArtifactSearchResults](docs/ArtifactSearchResults.md)
 - [ArtifactState](docs/ArtifactState.md)
 - [ArtifactType](docs/ArtifactType.md)
 - [EditableMetaData](docs/EditableMetaData.md)
 - [Error](docs/Error.md)
 - [IfExists](docs/IfExists.md)
 - [LogConfiguration](docs/LogConfiguration.md)
 - [LogLevel](docs/LogLevel.md)
 - [NamedLogConfiguration](docs/NamedLogConfiguration.md)
 - [NamedLogConfigurationAllOf](docs/NamedLogConfigurationAllOf.md)
 - [Properties](docs/Properties.md)
 - [RoleMapping](docs/RoleMapping.md)
 - [RoleType](docs/RoleType.md)
 - [Rule](docs/Rule.md)
 - [RuleType](docs/RuleType.md)
 - [RuleViolationCause](docs/RuleViolationCause.md)
 - [RuleViolationError](docs/RuleViolationError.md)
 - [RuleViolationErrorAllOf](docs/RuleViolationErrorAllOf.md)
 - [SearchedArtifact](docs/SearchedArtifact.md)
 - [SearchedVersion](docs/SearchedVersion.md)
 - [SortBy](docs/SortBy.md)
 - [SortOrder](docs/SortOrder.md)
 - [SystemInfo](docs/SystemInfo.md)
 - [UpdateRole](docs/UpdateRole.md)
 - [UpdateState](docs/UpdateState.md)
 - [UserInfo](docs/UserInfo.md)
 - [VersionMetaData](docs/VersionMetaData.md)
 - [VersionSearchResults](docs/VersionSearchResults.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

apicurio@lists.jboss.org


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in apicurioregistryclient.apis and apicurioregistryclient.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from apicurioregistryclient.api.default_api import DefaultApi`
- `from apicurioregistryclient.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import apicurioregistryclient
from apicurioregistryclient.apis import *
from apicurioregistryclient.models import *
```

