# -*- coding: utf-8 -*-
# Generated by Django 1.11.26 on 2019-12-11 18:23


from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import simple_history.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('assessment', '0003_expand_course_id'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalSharedFileUpload',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('team_id', models.CharField(db_index=True, max_length=255)),
                ('course_id', models.CharField(db_index=True, max_length=255)),
                ('item_id', models.CharField(db_index=True, max_length=255)),
                ('owner_id', models.CharField(db_index=True, max_length=255)),
                ('file_key', models.CharField(db_index=True, max_length=255)),
                ('description', models.TextField(blank=True, default='')),
                ('size', models.BigIntegerField(blank=True, default=0)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'verbose_name': 'historical shared file upload',
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='SharedFileUpload',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('team_id', models.CharField(db_index=True, max_length=255)),
                ('course_id', models.CharField(db_index=True, max_length=255)),
                ('item_id', models.CharField(db_index=True, max_length=255)),
                ('owner_id', models.CharField(db_index=True, max_length=255)),
                ('file_key', models.CharField(max_length=255, unique=True)),
                ('description', models.TextField(blank=True, default='')),
                ('size', models.BigIntegerField(blank=True, default=0)),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
