import os
import sys
from importlib.machinery import ModuleSpec
from types import CodeType, ModuleType
from typing import Any

if sys.version_info >= (3, 7):
    from importlib.abc import ResourceReader

class ZipImportError(ImportError): ...

class zipimporter(object):
    archive: str
    prefix: str
    def __init__(self, path: str | bytes | os.PathLike[Any]) -> None: ...
    def find_loader(self, fullname: str, path: str | None = ...) -> tuple[zipimporter | None, list[str]]: ...  # undocumented
    def find_module(self, fullname: str, path: str | None = ...) -> zipimporter | None: ...
    def get_code(self, fullname: str) -> CodeType: ...
    def get_data(self, pathname: str) -> str: ...
    def get_filename(self, fullname: str) -> str: ...
    if sys.version_info >= (3, 7):
        def get_resource_reader(self, fullname: str) -> ResourceReader | None: ...  # undocumented
    def get_source(self, fullname: str) -> str | None: ...
    def is_package(self, fullname: str) -> bool: ...
    def load_module(self, fullname: str) -> ModuleType: ...
    if sys.version_info >= (3, 10):
        def find_spec(self, fullname: str, target: ModuleType | None = ...) -> ModuleSpec | None: ...
        def invalidate_caches(self) -> None: ...
