from colorama import Fore
import anipick
import argparse
import tabulate

parse = argparse.ArgumentParser()
parse.add_argument('-a', '--anime', help='get info of anime', nargs='+')
parse.add_argument('-m', '--manga', help='get manga info', nargs='+')
parse.add_argument('-ly', '--lyrics', help='get lyrics of the anime song', nargs='+')
parse.add_argument('-s', '--song', help='usage: False/True')
parse.add_argument('-tf', '--tablefmt', help='setting the table fmt')
parse.add_argument('-q', '--quote',action='store_true' ,help='random quotes nime', required=False)
parse.add_argument('-c', '--char', help='get character info', nargs='+')
parse.add_argument('--author', action='version', version='Kenzawa/Babwa')
parse.add_argument('-v', '--version', action='version', version='1.4.8')


args = parse.parse_args()

if args.anime:
    ' '.join(args.anime)
    title = anipick.Animegraphy(args.anime)
    name = title.title
    genre = title.genre
    eps = title.eps
    aired = title.aired
    studio = title.studio
    id = title.mal_id
    broadcast = title.broadcast
    adaptation = title.adaptation
    synopsis = title.synopsis
    duration = title.duration
    nsfw = title.nsfw_scan()
    score = title.score
    rank = title.rank
    sequel = title.sequel
    status = title.status
    op = title.op_song
    ed = title.ed_song
    op = op.split('#')[0:3]
    op = ', '.join(op)
    ed = ed.split('#')[0:3]
    ed = ', '.join(ed)
    table = [['Anime', name], ['MAL ID', id], ['Status', status], ['Episode', eps], ['Aired', aired], ['Studio', studio],['Broadcast', broadcast], ['Duration', duration], ['NSFW', nsfw], [
    'Sequel', sequel], ['Score', score], ['RANK', rank], ['Genre', genre],['Adaptation', adaptation]]
    try:
        if 'rue' in args.song:
            table = [['Anime', name], ['MAL ID', id], ['Status', status], ['Episode', eps], ['Aired', aired], ['Studio', studio],['Broadcast', broadcast], ['Duration', duration], ['NSFW', nsfw], [
        'Sequel', sequel], ['Score', score], ['RANK', rank], ['Genre', genre],['Adaptation', adaptation], ['Opening', op], ['Ending', ed]]
        if 'lse' in args.song:
            table = [['Anime', name], ['MAL ID', id], ['Status', status], ['Episode', eps], ['Aired', aired], ['Studio', studio],['Broadcast', broadcast], ['Duration', duration], ['NSFW', nsfw], [
        'Sequel', sequel], ['Score', score], ['RANK', rank], ['Genre', genre],['Adaptation', adaptation]]
    except:
        table = [['Anime', name], ['MAL ID', id], ['Status', status], ['Episode', eps], ['Aired', aired], ['Studio', studio],['Broadcast', broadcast], ['Duration', duration], ['NSFW', nsfw], [
    'Sequel', sequel], ['Score', score], ['RANK', rank], ['Genre', genre],['Adaptation', adaptation]]
    if args.tablefmt:
        print(tabulate.tabulate(table, headers='firstrow', tablefmt=args.tablefmt))
    else:
        print(tabulate.tabulate(table, headers='firstrow'))
if args.manga:
    ' '.join(args.manga)
    manga = anipick.Mangaography(args.manga)
    title = f'{manga.name} ({manga.name_jp})'
    aired = manga.aired
    genre = manga.genres
    author = manga.author
    status = manga.status
    publish = manga.is_publishing
    serialization = manga.serialization
    chapter = manga.chapter
    volume = manga.volume
    score = manga.score
    id = manga.manga_id
    related = manga.related
    table = [['Manga', title], ['MAL ID', id], ['Score', score], ['Publish', publish], ['Author', author], ['Status', status],
    ['Chapter', chapter], ['Volume', volume], ['Genre', genre], ['Related', related], ['Serialization', serialization], ['Aired', aired]]
    if args.tablefmt:
        print(tabulate.tabulate(table, headers='firstrow', tablefmt=args.tablefmt))
    else:
        print(tabulate.tabulate(table, headers='firstrow'))
if args.quote:
        quotenime = anipick.Quotenime()
        anime = quotenime.anime
        quote = quotenime.quote
        char = quotenime.char
        table = [['Anime', anime], ['Character', char], ['Quotes', quote]]
        if args.tablefmt:
            print(tabulate.tabulate(table, headers='firstrow', tablefmt=args.tablefmt))
        else:
            print(tabulate.tabulate(table, headers='firstrow'))
if args.lyrics:
    ' '.join(args.lyrics)
    query = anipick.Lyricspedia(args.lyrics)
    romaji = query.lyrics_romaji
    print(romaji)

if args.char:
    ' '.join(args.char)
    char = anipick.Charapedia(args.char)
    name = char.name
    nickname = char.nickname
    about = f'Height: {char.height}, Weight: {char.weight}, Birthday: {char.birthday}'
    id = char.mal_char_id
    animm = str(char.anime)
    animm = animm.replace(',', ',:').split(':')[0:5]
    animm = ', '.join(animm)
    mangaa = str(char.manga)
    mangaa = mangaa.replace(',', ',:').split(':')[0:5]
    mangaa = ', '.join(mangaa)
    table = [['Name', name], ['NickName', nickname], ['MAL CHAR ID', id], ['About:', about], ['Anime', animm], ['Manga', mangaa]]
    if args.tablefmt:
            print(tabulate.tabulate(table, headers='firstrow', tablefmt=args.tablefmt))
    else:
            print(tabulate.tabulate(table, headers='firstrow'))