
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: src/ai/backend/accelerator/mock:dist

from setuptools import setup

setup(**{
    'author': 'Lablup Inc. and contributors',
    'classifiers': [
        'Intended Audience :: Developers',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Environment :: No Input/Output (Daemon)',
        'Topic :: Scientific/Engineering',
        'Topic :: Software Development',
        'Development Status :: 4 - Beta',
        'Programming Language :: Python :: 3.13',
        'License :: OSI Approved :: GNU Lesser General Public License v3 or later (LGPLv3+)',
    ],
    'description': 'Backend.AI Mockup Accelerator Plugin',
    'entry_points': {
        'backendai_accelerator_v21': [
            'mock = ai.backend.accelerator.mock.plugin:MockPlugin',
        ],
    },
    'install_requires': (
        'aiodocker==0.24.0',
        'backend.ai-agent==25.6.8rc1',
        'backend.ai-cli==25.6.8rc1',
        'backend.ai-common==25.6.8rc1',
        'backend.ai-kernel-binary==25.6.8rc1',
        'backend.ai-kernel-helper==25.6.8rc1',
        'backend.ai-logging==25.6.8rc1',
        'backend.ai-plugin==25.6.8rc1',
        'trafaret~=2.1',
    ),
    'license': 'LGPLv3',
    'long_description': """# backend.ai-accelerator-mock

A mockup plugin for accelerators

This plugin deceives the agent and manager to think as if there are accelerator devices.
The configuration follows `mock-accelerator.toml` placed in the same location of `agent.toml`.
Please refer the sample configurations in the `configs/accelerator` directory and copy one of them as a starting point.

The statistics are randomly generated in reasonable ranges, but it may seem like "jumping around" because there is no smoothing mechanism of generated values.
The configurations for fractional/discrete mode, fraction size, and device masks in etcd are exactly same as the original plugin.

## Notes when setting up mock CUDA devices

The containers are created without any real CUDA device mounts but with `BACKENDAI_MOCK_CUDA_DEVICES` and `BACKENDAI_MOCK_CUDA_DEVICE_COUNT` environment variables.
Since the manager does not know if the reported devices are real or not, you can start any CUDA-only containers (but of course they won't work as expected).
""",
    'long_description_content_type': 'text/markdown',
    'name': 'backend.ai-accelerator-mock',
    'namespace_packages': (
    ),
    'package_data': {
        'ai.backend.accelerator.mock': (
            'VERSION',
            'py.typed',
        ),
    },
    'packages': (
        'ai.backend.accelerator.mock',
    ),
    'project_urls': {
        'Documentation': 'https://docs.backend.ai/',
        'Source': 'https://github.com/lablup/backend.ai',
    },
    'python_requires': '>=3.13,<3.14',
    'url': 'https://github.com/lablup/backend.ai',
    'version': '25.6.8rc1',
    'zip_safe': False,
})
