"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobQueue = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_batch_1 = require("aws-cdk-lib/aws-batch");
/**
 * Batch Job Queue.
 *
 * Defines a batch job queue to define how submitted batch jobs
 * should be ran based on specified batch compute environments.
 */
class JobQueue extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.jobQueueName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_batch_alpha_JobQueueProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.computeEnvironments.length === 0) {
            throw new Error('computeEnvironments must be non-empty');
        }
        const jobQueue = new aws_batch_1.CfnJobQueue(this, 'Resource', {
            computeEnvironmentOrder: props.computeEnvironments.map(cp => ({
                computeEnvironment: cp.computeEnvironment.computeEnvironmentArn,
                order: cp.order,
            })),
            jobQueueName: this.physicalName,
            priority: props.priority || 1,
            state: props.enabled === undefined ? 'ENABLED' : (props.enabled ? 'ENABLED' : 'DISABLED'),
        });
        this.jobQueueArn = this.getResourceArnAttribute(jobQueue.ref, {
            service: 'batch',
            resource: 'job-queue',
            resourceName: this.physicalName,
        });
        this.jobQueueName = this.getResourceNameAttribute(jobQueue.ref);
    }
    /**
     * Fetches an existing batch job queue by its amazon resource name.
     *
     * @param scope
     * @param id
     * @param jobQueueArn
     */
    static fromJobQueueArn(scope, id, jobQueueArn) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const jobQueueName = stack.splitArn(jobQueueArn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.jobQueueArn = jobQueueArn;
                this.jobQueueName = jobQueueName;
            }
        }
        return new Import(scope, id);
    }
}
exports.JobQueue = JobQueue;
_a = JSII_RTTI_SYMBOL_1;
JobQueue[_a] = { fqn: "@aws-cdk/aws-batch-alpha.JobQueue", version: "2.27.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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