# Generated by Django 3.2.4 on 2022-01-08 21:05

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('custom', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('custom_development', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Activity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(null=True, verbose_name='Data Atividade')),
                ('name', models.CharField(blank=True, max_length=300, verbose_name='Naran Atividade')),
                ('place', models.CharField(blank=True, max_length=250, verbose_name='Fatin')),
                ('participation', models.CharField(max_length=255, null=True, verbose_name='Partisipasaun')),
                ('benefit', models.CharField(max_length=250, null=True, verbose_name='Benefísiu')),
                ('obs', models.TextField(verbose_name='OBS')),
                ('hashed', models.CharField(blank=True, max_length=50, null=True)),
                ('datetime', models.DateTimeField(auto_now_add=True, null=True)),
                ('administrativepost', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('municipality', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Author')),
                ('village', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
                ('year', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.year', verbose_name='Tinan')),
            ],
            options={
                'verbose_name_plural': 'C.2. Livru Dadus Atividade Suku',
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300, null=True, verbose_name='Naran Projetu')),
                ('start_period', models.DateField(null=True, verbose_name='Data Hahu')),
                ('end_period', models.DateField(null=True, verbose_name='Data Remata')),
                ('benefit', models.CharField(max_length=200, null=True, verbose_name='Benefísiu')),
                ('obs', models.TextField(verbose_name='OBS')),
                ('hashed', models.CharField(blank=True, max_length=50, null=True)),
                ('datetime', models.DateTimeField(auto_now_add=True, null=True)),
                ('administrativepost', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('company', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom_development.company', verbose_name='Naran Kompañia')),
                ('municipality', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Author')),
                ('village', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
                ('year', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.year', verbose_name='Tinan')),
            ],
            options={
                'verbose_name_plural': 'C.1. Livru Dadus Projetu Suku',
            },
        ),
        migrations.CreateModel(
            name='ImageProject',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.FileField(blank=True, null=True, upload_to='development/project/', validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['jpg', 'jpeg', 'png'])], verbose_name='Aneksu Imajen')),
                ('datetime', models.DateTimeField(null=True)),
                ('project', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='development.project', verbose_name='Naran Projetu')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Aneksu Imajen Projetu',
            },
        ),
        migrations.CreateModel(
            name='ImageActivity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.FileField(blank=True, null=True, upload_to='development/activity/', validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['jpg', 'jpeg', 'png'])], verbose_name='Aneksu Imajen')),
                ('datetime', models.DateTimeField(null=True)),
                ('activity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='activityfiles', to='development.activity', verbose_name='Naran Atividade')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Aneksu Imajen Atividade',
            },
        ),
        migrations.CreateModel(
            name='FundVolunteer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('volunteer', models.CharField(blank=True, max_length=200, null=True, verbose_name='Voluntáriu')),
                ('volunteer_material', models.CharField(blank=True, max_length=50, null=True, verbose_name='Ajuda Material')),
                ('volunteer_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=11, null=True, verbose_name='Total Osan')),
                ('hashed', models.CharField(blank=True, max_length=50, null=True)),
                ('project', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='development.project', verbose_name='Naran Projetu')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Author')),
            ],
            options={
                'verbose_name_plural': 'Fundus Husi Voluntáriu',
            },
        ),
        migrations.CreateModel(
            name='FundONG',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ong_material', models.CharField(blank=True, max_length=50, null=True, verbose_name='Ajuda Material')),
                ('ong_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=11, null=True, verbose_name='Total Osan')),
                ('hashed', models.CharField(blank=True, max_length=50, null=True)),
                ('ong', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom_development.ong', verbose_name='ONG')),
                ('project', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='development.project', verbose_name='Naran Projetu')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Author')),
            ],
            options={
                'verbose_name_plural': 'Fundus Husi ONG',
            },
        ),
        migrations.CreateModel(
            name='FundNational',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('national_material', models.CharField(blank=True, max_length=50, null=True, verbose_name='Ajuda Material')),
                ('national_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=11, null=True, verbose_name='Total Osan')),
                ('hashed', models.CharField(blank=True, max_length=50, null=True)),
                ('activity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='development.activity', verbose_name='Naran Atividade')),
                ('national', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom_development.national', verbose_name='Nasional')),
                ('project', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='development.project', verbose_name='Naran Projetu')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Author')),
            ],
            options={
                'verbose_name_plural': 'Fundus Husi Nasional',
            },
        ),
        migrations.CreateModel(
            name='FundMunicipality',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('municipality_material', models.CharField(blank=True, max_length=50, null=True, verbose_name='Ajuda Material')),
                ('municipality_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=11, null=True, verbose_name='Total Osan')),
                ('hashed', models.CharField(blank=True, max_length=50, null=True)),
                ('activity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='development.activity', verbose_name='Naran Atividade')),
                ('municipality', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality', verbose_name='Munisípiu')),
                ('project', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='development.project', verbose_name='Naran Projetu')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Author')),
            ],
            options={
                'verbose_name_plural': 'Fundus Husi Munisípiu',
            },
        ),
        migrations.CreateModel(
            name='FundCommunityContribute',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('community_contribute', models.CharField(blank=True, max_length=200, null=True, verbose_name='Kontribuisaun Komunidade')),
                ('communitycontribute_material', models.CharField(blank=True, max_length=50, null=True, verbose_name='Ajuda Material')),
                ('communitycontribute_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=11, null=True, verbose_name='Total Osan')),
                ('hashed', models.CharField(blank=True, max_length=50, null=True)),
                ('activity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='development.activity', verbose_name='Naran Atividade')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Author')),
            ],
            options={
                'verbose_name_plural': 'Fundus Husi Kontribuisaun Komunidade',
            },
        ),
        migrations.CreateModel(
            name='FundAgency',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('agency_material', models.CharField(blank=True, max_length=50, null=True, verbose_name='Ajuda Material')),
                ('agency_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=11, null=True, verbose_name='Total Osan')),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
                ('activity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='development.activity', verbose_name='Naran Projetu')),
                ('agency', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom_development.agency', verbose_name='Ajénsia')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Author')),
            ],
            options={
                'verbose_name_plural': 'Fundus Husi Ajénsia',
            },
        ),
    ]
