import pyssage.quadvar
import pyssage.graph
from tests.test_common import create_test_transect, create_test_surface


def test_ttlqv():
    # answer calculated from PASSaGE 2 and exported to 5 decimals
    answer = (0.00769,
              0.02311,
              0.04888,
              0.08508,
              0.13175,
              0.18896,
              0.25678,
              0.33527,
              0.4245,
              0.52453,
              0.63542,
              0.75726,
              0.89009,
              1.034,
              1.18904,
              1.35529,
              1.53282,
              1.7217,
              1.92199,
              2.13378,
              2.35636,
              2.58468,
              2.81373,
              3.03927,
              3.25774,
              3.46607,
              3.66163,
              3.84213,
              4.00555,
              4.15014,
              4.27432,
              4.37669,
              4.456,
              4.51111,
              4.54099,
              4.54468,
              4.52133,
              4.47013,
              4.39034,
              4.28126,
              4.14399,
              3.98866,
              3.81838,
              3.63601,
              3.44417,
              3.24524,
              3.04146,
              2.83486,
              2.62733,
              2.42063,
              2.2164,
              2.01616,
              1.82132,
              1.63322,
              1.45311,
              1.28216,
              1.12148,
              0.97211,
              0.83503,
              0.71119,
              0.60121,
              0.50417,
              0.41902,
              0.34474,
              0.28041,
              0.22512,
              0.17803,
              0.13836,
              0.10534,
              0.07826,
              0.05645,
              0.03925,
              0.02606,
              0.01628,
              0.00938,
              0.0048,
              0.00205,
              0.00064,
              0.00011,
              0,
              0.00009,
              0.00056,
              0.00175,
              0.00402,
              0.0077,
              0.01311,
              0.02055,
              0.03033,
              0.04273,
              0.05803,
              0.07651,
              0.09843,
              0.12404,
              0.15359,
              0.18732,
              0.22546,
              0.26825,
              0.3159,
              0.36864,
              0.42667,
              0.49004,
              0.55783,
              0.62894,
              0.70233,
              0.77697,
              0.85186,
              0.92605,
              0.99858,
              1.06853,
              1.13503,
              1.19719,
              1.25417,
              1.30514,
              1.34929,
              1.38582,
              1.41396,
              1.43296,
              1.44207,
              1.44057,
              1.42774,
              1.40356,
              1.37157,
              1.33258,
              1.28738,
              1.23674,
              1.18144,
              1.1222,
              1.05976,
              0.99482,
              0.92808,
              0.86021,
              0.79189,
              0.72376,
              0.65647,
              0.59065,
              0.5269,
              0.46585,
              0.40808,
              0.35418,
              0.30472,
              0.26016,
              0.2203,
              0.18484,
              0.15349,
              0.12599,
              0.10205,
              0.08142,
              0.06382,
              0.049,
              0.0367,
              0.02669,
              0.0187,
              0.01251,
              0.00788,
              0.00457,
              0.00236,
              0.00101,
              0.00032,
              0.00005,
              0,
              0.00005,
              0.00028,
              0.00088,
              0.00204,
              0.00393,
              0.00673,
              0.01062,
              0.01577,
              0.02234,
              0.03053,
              0.04048,
              0.05238,
              0.06637,
              0.08264,
              0.10134,
              0.12264,
              0.14669,
              0.17365,
              0.20369,
              0.23696,
              0.27353,
              0.31292,
              0.35453,
              0.39779,
              0.44211,
              0.48693,
              0.53168,
              0.57579,
              0.61872,
              0.65991,
              0.6988,
              0.73487,
              0.76756,
              0.79634,
              0.82067,
              0.84004,
              0.8539,
              0.86173,
              0.86302,
              0.85724,
              0.84438,
              0.82691,
              0.80528,
              0.77988,
              0.75114,
              0.71948,
              0.6853,
              0.649,
              0.61101,
              0.5717,
              0.5315,
              0.49078,
              0.44996,
              0.40941,
              0.36954,
              0.33073,
              0.29337,
              0.25784,
              0.22453,
              0.19384,
              0.16605,
              0.14108,
              0.11876,
              0.09895,
              0.08149,
              0.06622,
              0.053,
              0.04168,
              0.0321,
              0.02412,
              0.01759,
              0.01237,
              0.0083,
              0.00524,
              0.00305,
              0.00158,
              0.00068,
              0.00022,
              0.00004,
              0,
              0.00003,
              0.00018,
              0.00058,
              0.00135,
              0.00261,
              0.00448,
              0.00708,
              0.01055,
              0.01499,
              0.02054,
              0.02732,
              0.03544,
              0.04504,
              0.05624,
              0.06916,
              0.08393,
              0.10066,
              0.1195,
              0.14056,
              0.16397,
              0.18979,
              0.21771,
              0.24731,
              0.2782,
              0.30996,
              0.3422,
              0.3745,
              0.40645,
              0.43766,
              0.4677,
              0.49617,
              0.52265,
              0.54674,
              0.56801,
              0.58605,
              0.60044,
              0.61076,
              0.61659,
              0.61749,
              0.61305,
              0.6033,
              0.59052,
              0.57496,
              0.5569,
              0.53658,
              0.51427,
              0.49023,
              0.46473,
              0.43803,
              0.4104,
              0.3821,
              0.3534,
              0.32457,
              0.29588,
              0.2676,
              0.24001,
              0.21338,
              0.18799,
              0.16411,
              0.14204,
              0.12201,
              0.10393,
              0.08772,
              0.07328,
              0.06051,
              0.0493,
              0.03957,
              0.0312,
              0.02409,
              0.01815,
              0.01328,
              0.00936,
              0.0063,
              0.00399,
              0.00233,
              0.00121,
              0.00052,
              0.00017,
              0.00003,
              0,
              0.00002,
              0.00013,
              0.00042,
              0.00098,
              0.00191,
              0.00329,
              0.00521,
              0.00778,
              0.01109,
              0.01524,
              0.02033,
              0.02645,
              0.03371,
              0.04221,
              0.05206,
              0.06336,
              0.07622,
              0.09075,
              0.10706,
              0.12526,
              0.14542,
              0.1673,
              0.19059,
              0.21498,
              0.24015,
              0.26576,
              0.2915,
              0.31702,
              0.342,
              0.36608,
              0.38892,
              0.41016,
              0.42945,
              0.44641,
              0.46068,
              0.47187,
              0.4796,
              0.48347,
              0.48309,
              0.47804,
              0.46846,
              0.45698,
              0.44374,
              0.42891,
              0.41264,
              0.39509,
              0.37642,
              0.3568,
              0.3364,
              0.31539,
              0.29395,
              0.27224,
              0.25046,
              0.22879,
              0.20742,
              0.18654,
              0.16635,
              0.14705,
              0.12885,
              0.11195,
              0.09655,
              0.08258,
              0.06999,
              0.05871,
              0.04868,
              0.03984,
              0.03211,
              0.02542,
              0.01972,
              0.01493,
              0.01096,
              0.00776,
              0.00525,
              0.00334,
              0.00196,
              0.00102,
              0.00044,
              0.00014,
              0.00002,
              0,
              0.00002,
              0.0001,
              0.00031,
              0.00072,
              0.00141,
              0.00244,
              0.00388,
              0.00583,
              0.00836,
              0.01156,
              0.0155,
              0.02029,
              0.02602,
              0.03278,
              0.04067,
              0.04981,
              0.06031,
              0.07227,
              0.08582,
              0.10108,
              0.11815,
              0.13686,
              0.15694,
              0.17813,
              0.20015,
              0.22271,
              0.2455,
              0.26821,
              0.2905,
              0.31203,
              0.33243,
              0.35132,
              0.36829,
              0.38292,
              0.39477,
              0.40336,
              0.4082,
              0.40876,
              0.40448,
              0.39477,
              0.38002,
              0.36496,
              0.34963,
              0.33406,
              0.31828,
              0.30235,
              0.28629,
              0.27015,
              0.25398,
              0.23783,
              0.22176,
              0.20582,
              0.19007,
              0.17459,
              0.15944,
              0.1447,
              0.13047,
              0.11682,
              0.10387,
              0.09172,
              0.08047,
              0.07006,
              0.06047,
              0.0517,
              0.04371,
              0.0365,
              0.03005,
              0.02432,
              0.0193,
              0.01496,
              0.01126,
              0.00818,
              0.00568,
              0.00372,
              0.00225,
              0.00121,
              0.00054,
              0.00018,
              0.00003,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0)

    result = pyssage.quadvar.ttlqv(create_test_transect())
    pyssage.graph.draw_quadvar_result(result, title="TTLQV Test", figoutput=pyssage.graph.FigOutput(figshow=True))
    for i in range(500):
        assert round(result[i, 1], 5) == answer[i]


def test_ttlqv_wrap():
    # answer calculated from PASSaGE 2 and exported to 5 decimals
    answer = (0.00768,
              0.02304,
              0.04864,
              0.08448,
              0.13056,
              0.18688,
              0.25344,
              0.33024,
              0.41728,
              0.51456,
              0.62208,
              0.73984,
              0.86784,
              1.00608,
              1.15456,
              1.31328,
              1.48224,
              1.66144,
              1.85088,
              2.05056,
              2.25978,
              2.47395,
              2.68864,
              2.90016,
              3.10541,
              3.30176,
              3.48698,
              3.65915,
              3.81663,
              3.95797,
              4.08194,
              4.18744,
              4.27351,
              4.33931,
              4.38409,
              4.40718,
              4.40799,
              4.38599,
              4.34069,
              4.27168,
              4.17889,
              4.06558,
              3.93505,
              3.79025,
              3.63392,
              3.46852,
              3.29633,
              3.11941,
              2.93969,
              2.75891,
              2.5787,
              2.40054,
              2.22582,
              2.05582,
              1.89172,
              1.73463,
              1.58556,
              1.44547,
              1.31525,
              1.19573,
              1.08749,
              0.98987,
              0.90211,
              0.82344,
              0.75318,
              0.69068,
              0.63531,
              0.5865,
              0.54371,
              0.50642,
              0.47415,
              0.44644,
              0.42285,
              0.40298,
              0.38643,
              0.37285,
              0.36188,
              0.3532,
              0.34648,
              0.34144,
              0.33792,
              0.33592,
              0.33558,
              0.33701,
              0.34033,
              0.34566,
              0.3531,
              0.36276,
              0.37474,
              0.38912,
              0.406,
              0.42546,
              0.44759,
              0.47246,
              0.50014,
              0.53072,
              0.56426,
              0.60082,
              0.64047,
              0.68326,
              0.72918,
              0.7776,
              0.82787,
              0.87934,
              0.93138,
              0.98341,
              1.03486,
              1.08516,
              1.13378,
              1.18022,
              1.22397,
              1.26457,
              1.30155,
              1.33447,
              1.36289,
              1.38642,
              1.40464,
              1.41717,
              1.42363,
              1.42368,
              1.41702,
              1.4042,
              1.3858,
              1.36239,
              1.33453,
              1.30274,
              1.26753,
              1.22942,
              1.18888,
              1.14639,
              1.10239,
              1.05734,
              1.01165,
              0.96575,
              0.92004,
              0.8749,
              0.83072,
              0.78787,
              0.7467,
              0.70757,
              0.67075,
              0.63624,
              0.60397,
              0.57387,
              0.54588,
              0.51993,
              0.49598,
              0.47396,
              0.45382,
              0.4355,
              0.41895,
              0.40411,
              0.39094,
              0.37939,
              0.3694,
              0.36094,
              0.35396,
              0.34841,
              0.34425,
              0.34144,
              0.33997,
              0.33978,
              0.34086,
              0.34316,
              0.34669,
              0.3514,
              0.35728,
              0.36431,
              0.37247,
              0.38174,
              0.3921,
              0.40353,
              0.41601,
              0.42952,
              0.44405,
              0.45958,
              0.47609,
              0.49356,
              0.51199,
              0.53134,
              0.55159,
              0.57255,
              0.594,
              0.61575,
              0.6376,
              0.65934,
              0.68081,
              0.70179,
              0.72213,
              0.74163,
              0.76012,
              0.77743,
              0.79339,
              0.80784,
              0.82063,
              0.83158,
              0.84055,
              0.84739,
              0.85195,
              0.85408,
              0.85366,
              0.85085,
              0.84582,
              0.83874,
              0.82978,
              0.81911,
              0.80689,
              0.79327,
              0.77841,
              0.76245,
              0.74556,
              0.72787,
              0.70953,
              0.69069,
              0.67146,
              0.65201,
              0.63244,
              0.61291,
              0.59353,
              0.57443,
              0.55573,
              0.53748,
              0.51974,
              0.50256,
              0.48599,
              0.47007,
              0.45486,
              0.4404,
              0.42673,
              0.41391,
              0.40198,
              0.39097,
              0.38094,
              0.37193,
              0.36397,
              0.35711,
              0.35139,
              0.34684,
              0.34351,
              0.34144,
              0.34066,
              0.34109,
              0.34266,
              0.34529,
              0.34889,
              0.3534,
              0.35875,
              0.36486,
              0.37166,
              0.37908,
              0.38706,
              0.39552,
              0.4044,
              0.41363,
              0.42315,
              0.4329,
              0.44281,
              0.45282,
              0.46288,
              0.47291,
              0.48287,
              0.49272,
              0.50241,
              0.51191,
              0.52119,
              0.5302,
              0.53892,
              0.54731,
              0.55532,
              0.56294,
              0.57012,
              0.57684,
              0.58305,
              0.58874,
              0.59386,
              0.59839,
              0.6023,
              0.60555,
              0.60811,
              0.60997,
              0.61107,
              0.61145,
              0.61112,
              0.6101,
              0.6084,
              0.60605,
              0.60305,
              0.59942,
              0.59518,
              0.59034,
              0.58492,
              0.57894,
              0.5724,
              0.56532,
              0.55771,
              0.5496,
              0.54098,
              0.53189,
              0.52232,
              0.5123,
              0.50184,
              0.49104,
              0.47999,
              0.46878,
              0.45752,
              0.44628,
              0.43517,
              0.42427,
              0.41367,
              0.40347,
              0.39374,
              0.38457,
              0.37606,
              0.36827,
              0.3613,
              0.35522,
              0.35011,
              0.34606,
              0.34315,
              0.34144,
              0.34101,
              0.34175,
              0.34357,
              0.34636,
              0.35001,
              0.35443,
              0.3595,
              0.36514,
              0.37125,
              0.37772,
              0.38446,
              0.39137,
              0.39837,
              0.40535,
              0.41224,
              0.41893,
              0.42533,
              0.43137,
              0.43694,
              0.44198,
              0.4464,
              0.45023,
              0.45354,
              0.45637,
              0.45877,
              0.46078,
              0.46246,
              0.46385,
              0.46499,
              0.46594,
              0.46674,
              0.46743,
              0.46805,
              0.46866,
              0.4693,
              0.47,
              0.47082,
              0.47179,
              0.47295,
              0.47435,
              0.476,
              0.47786,
              0.47987,
              0.48196,
              0.48407,
              0.48613,
              0.48808,
              0.48986,
              0.49141,
              0.49266,
              0.49357,
              0.49406,
              0.49408,
              0.49358,
              0.49249,
              0.49076,
              0.48834,
              0.48516,
              0.48118,
              0.47633,
              0.47059,
              0.46405,
              0.45684,
              0.44908,
              0.44088,
              0.43235,
              0.42362,
              0.41479,
              0.40599,
              0.39731,
              0.38887,
              0.38079,
              0.37316,
              0.3661,
              0.3597,
              0.35409,
              0.34935,
              0.3456,
              0.34293,
              0.34144,
              0.34121,
              0.34215,
              0.34412,
              0.34701,
              0.35069,
              0.35505,
              0.35996,
              0.36531,
              0.37099,
              0.37688,
              0.38287,
              0.38883,
              0.39467,
              0.40028,
              0.40553,
              0.41033,
              0.41456,
              0.41813,
              0.42092,
              0.42283,
              0.42378,
              0.42386,
              0.42316,
              0.42179,
              0.41985,
              0.41743,
              0.41465,
              0.41159,
              0.40835,
              0.40503,
              0.40173,
              0.39854,
              0.39555,
              0.39286,
              0.39055,
              0.38873,
              0.38748,
              0.38689,
              0.38705,
              0.38804,
              0.38994,
              0.39264,
              0.39603,
              0.4,
              0.40444,
              0.40923,
              0.41426,
              0.41942,
              0.42461,
              0.42971,
              0.43462,
              0.43923,
              0.44343,
              0.44713,
              0.45021,
              0.45258,
              0.45413,
              0.45476,
              0.45437,
              0.45287,
              0.45018,
              0.44641,
              0.4417,
              0.43617,
              0.42996,
              0.4232,
              0.41603,
              0.40856,
              0.40092,
              0.39325,
              0.38566,
              0.37828,
              0.37124,
              0.36466,
              0.35865,
              0.35334,
              0.34885,
              0.34529,
              0.34278,
              0.34144,
              0.34135,
              0.34241,
              0.34449,
              0.34744,
              0.35114,
              0.35546,
              0.36027,
              0.36543,
              0.37082,
              0.37632,
              0.38179,
              0.38712,
              0.39218,
              0.39684,
              0.40099,
              0.4045,
              0.40726,
              0.40914,
              0.41003,
              0.4098)

    result = pyssage.quadvar.ttlqv(create_test_transect(), wrap=True)
    pyssage.graph.draw_quadvar_result(result, title="TTLQV Wrap Test", figoutput=pyssage.graph.FigOutput(figshow=True))
    for i in range(500):
        assert round(result[i, 1], 5) == answer[i]


def test_3tlqv():
    # answer calculated from PASSaGE 2 and exported to 5 decimals
    answer = (0.00385,
              0.00965,
              0.01935,
              0.033,
              0.05063,
              0.07227,
              0.09796,
              0.12774,
              0.16164,
              0.19971,
              0.24198,
              0.2885,
              0.33929,
              0.39467,
              0.45869,
              0.53658,
              0.63242,
              0.74946,
              0.89035,
              1.05726,
              1.25191,
              1.47135,
              1.70943,
              1.96102,
              2.22175,
              2.48791,
              2.7563,
              3.02261,
              3.28056,
              3.52436,
              3.74893,
              3.94972,
              4.12266,
              4.26406,
              4.37059,
              4.4392,
              4.4671,
              4.45171,
              4.39065,
              4.28168,
              4.12797,
              3.94743,
              3.74516,
              3.52585,
              3.2938,
              3.05297,
              2.80707,
              2.55949,
              2.31342,
              2.07182,
              1.83748,
              1.613,
              1.40083,
              1.20321,
              1.02119,
              0.85522,
              0.70575,
              0.57319,
              0.45799,
              0.36054,
              0.28122,
              0.21871,
              0.17023,
              0.13315,
              0.10498,
              0.08334,
              0.06597,
              0.05137,
              0.03919,
              0.02919,
              0.02111,
              0.01472,
              0.00981,
              0.00616,
              0.00357,
              0.00185,
              0.00081,
              0.00027,
              0.00005,
              0,
              0.00005,
              0.00023,
              0.00069,
              0.00156,
              0.00295,
              0.005,
              0.00783,
              0.01155,
              0.01627,
              0.02211,
              0.02917,
              0.03757,
              0.0474,
              0.0588,
              0.0725,
              0.08952,
              0.11088,
              0.13755,
              0.17052,
              0.21072,
              0.25912,
              0.31589,
              0.38016,
              0.45107,
              0.5278,
              0.60955,
              0.69551,
              0.78454,
              0.87476,
              0.96428,
              1.05126,
              1.13388,
              1.21034,
              1.27889,
              1.33778,
              1.38532,
              1.41981,
              1.43959,
              1.44301,
              1.42843,
              1.39658,
              1.3544,
              1.30318,
              1.24415,
              1.17853,
              1.10754,
              1.03235,
              0.95414,
              0.87407,
              0.79326,
              0.71286,
              0.63397,
              0.5577,
              0.48511,
              0.41683,
              0.35331,
              0.29496,
              0.24223,
              0.19554,
              0.15532,
              0.12206,
              0.09561,
              0.07495,
              0.05907,
              0.04696,
              0.03762,
              0.03007,
              0.02364,
              0.01821,
              0.01369,
              0.00999,
              0.00703,
              0.00473,
              0.003,
              0.00175,
              0.00092,
              0.0004,
              0.00013,
              0.00003,
              0,
              0.00002,
              0.00012,
              0.00035,
              0.00078,
              0.00149,
              0.00255,
              0.00402,
              0.00598,
              0.00849,
              0.01162,
              0.01544,
              0.02002,
              0.02544,
              0.03179,
              0.03943,
              0.04893,
              0.06081,
              0.07562,
              0.09391,
              0.11623,
              0.14325,
              0.17536,
              0.21216,
              0.25323,
              0.29817,
              0.34655,
              0.39797,
              0.45177,
              0.50685,
              0.56205,
              0.6162,
              0.66812,
              0.71663,
              0.76052,
              0.79861,
              0.82966,
              0.85245,
              0.86572,
              0.86821,
              0.85865,
              0.83786,
              0.81192,
              0.78138,
              0.74679,
              0.70872,
              0.66772,
              0.62437,
              0.57924,
              0.53291,
              0.48597,
              0.43901,
              0.39264,
              0.34747,
              0.3041,
              0.2629,
              0.22417,
              0.18821,
              0.15533,
              0.12584,
              0.10007,
              0.07848,
              0.06134,
              0.04799,
              0.03779,
              0.03009,
              0.02421,
              0.01947,
              0.01541,
              0.01194,
              0.00904,
              0.00664,
              0.0047,
              0.00318,
              0.00203,
              0.0012,
              0.00063,
              0.00028,
              0.00009,
              0.00002,
              0,
              0.00001,
              0.00007,
              0.00022,
              0.0005,
              0.00096,
              0.00165,
              0.00262,
              0.00392,
              0.0056,
              0.00773,
              0.01035,
              0.01353,
              0.01733,
              0.02182,
              0.02722,
              0.03384,
              0.04197,
              0.05192,
              0.06403,
              0.07864,
              0.09635,
              0.11805,
              0.14351,
              0.17254,
              0.2049,
              0.24038,
              0.27873,
              0.31952,
              0.36189,
              0.40487,
              0.44746,
              0.48859,
              0.52715,
              0.56197,
              0.59182,
              0.61538,
              0.63128,
              0.63805,
              0.63413,
              0.61785,
              0.59106,
              0.56373,
              0.53595,
              0.50776,
              0.47925,
              0.45049,
              0.42156,
              0.39255,
              0.36356,
              0.33468,
              0.30602,
              0.2777,
              0.24985,
              0.22259,
              0.19598,
              0.17016,
              0.14531,
              0.12161,
              0.09929,
              0.07857,
              0.06027,
              0.0459,
              0.03499,
              0.02701,
              0.02138,
              0.01742,
              0.0144,
              0.01174,
              0.00939,
              0.00734,
              0.00558,
              0.0041,
              0.00289,
              0.00192,
              0.00118,
              0.00065,
              0.0003,
              0.00011,
              0.00002,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0)

    result = pyssage.quadvar.three_tlqv(create_test_transect())
    pyssage.graph.draw_quadvar_result(result, title="3TLQV Test", figoutput=pyssage.graph.FigOutput(figshow=True))
    for i in range(333):
        assert round(result[i, 1], 5) == answer[i]


def test_pqv():
    # answer calculated from PASSaGE 2 and exported to 5 decimals
    answer = (0.00769,
              0.01539,
              0.02311,
              0.03084,
              0.03859,
              0.04636,
              0.05414,
              0.06194,
              0.06975,
              0.07758,
              0.08542,
              0.09328,
              0.10116,
              0.10905,
              0.11695,
              0.12488,
              0.13282,
              0.14077,
              0.14875,
              0.15673,
              0.16474,
              0.17276,
              0.1808,
              0.18885,
              0.19692,
              0.20501,
              0.21311,
              0.22123,
              0.22937,
              0.23753,
              0.2457,
              0.25388,
              0.26209,
              0.27031,
              0.27855,
              0.2868,
              0.29508,
              0.30337,
              0.31168,
              0.32,
              0.31233,
              0.30463,
              0.29693,
              0.28921,
              0.28147,
              0.27371,
              0.26594,
              0.25815,
              0.25035,
              0.24253,
              0.23469,
              0.22684,
              0.21897,
              0.21108,
              0.20317,
              0.19525,
              0.18732,
              0.17936,
              0.17139,
              0.1634,
              0.1554,
              0.14738,
              0.13934,
              0.13128,
              0.12321,
              0.11512,
              0.10701,
              0.09888,
              0.09074,
              0.08258,
              0.0744,
              0.06621,
              0.05799,
              0.04976,
              0.04151,
              0.03325,
              0.02496,
              0.01666,
              0.00834,
              0,
              0.00766,
              0.01534,
              0.02303,
              0.03074,
              0.03847,
              0.04621,
              0.05398,
              0.06175,
              0.06955,
              0.07736,
              0.08519,
              0.09304,
              0.1009,
              0.10879,
              0.11669,
              0.1246,
              0.13254,
              0.14049,
              0.14846,
              0.15644,
              0.16445,
              0.17247,
              0.18051,
              0.18857,
              0.19665,
              0.20474,
              0.21286,
              0.22099,
              0.22914,
              0.2373,
              0.24549,
              0.25369,
              0.26192,
              0.27016,
              0.27842,
              0.2867,
              0.29499,
              0.30331,
              0.31165,
              0.32,
              0.31235,
              0.30469,
              0.29701,
              0.28932,
              0.2816,
              0.27387,
              0.26612,
              0.25835,
              0.25056,
              0.24276,
              0.23494,
              0.2271,
              0.21924,
              0.21136,
              0.20347,
              0.19556,
              0.18762,
              0.17968,
              0.17171,
              0.16372,
              0.15572,
              0.14769,
              0.13965,
              0.13159,
              0.12351,
              0.11541,
              0.10729,
              0.09915,
              0.091,
              0.08282,
              0.07463,
              0.06642,
              0.05818,
              0.04993,
              0.04166,
              0.03336,
              0.02505,
              0.01672,
              0.00837,
              0,
              0.00763,
              0.01527,
              0.02294,
              0.03062,
              0.03832,
              0.04604,
              0.05378,
              0.06154,
              0.06931,
              0.07711,
              0.08492,
              0.09275,
              0.1006,
              0.10847,
              0.11636,
              0.12427,
              0.1322,
              0.14015,
              0.14811,
              0.1561,
              0.1641,
              0.17213,
              0.18017,
              0.18824,
              0.19632,
              0.20442,
              0.21255,
              0.22069,
              0.22885,
              0.23704,
              0.24524,
              0.25347,
              0.26171,
              0.26998,
              0.27826,
              0.28657,
              0.29489,
              0.30324,
              0.31161,
              0.32,
              0.31239,
              0.30476,
              0.29711,
              0.28945,
              0.28176,
              0.27406,
              0.26633,
              0.25859,
              0.25082,
              0.24304,
              0.23523,
              0.22741,
              0.21957,
              0.2117,
              0.20382,
              0.19592,
              0.18799,
              0.18005,
              0.17209,
              0.1641,
              0.1561,
              0.14807,
              0.14003,
              0.13196,
              0.12387,
              0.11576,
              0.10763,
              0.09948,
              0.09131,
              0.08312,
              0.0749,
              0.06667,
              0.05841,
              0.05013,
              0.04183,
              0.03351,
              0.02516,
              0.0168,
              0.00841,
              0,
              0.00759,
              0.0152,
              0.02283,
              0.03048,
              0.03815,
              0.04584,
              0.05355,
              0.06128,
              0.06903,
              0.0768,
              0.08459,
              0.09241,
              0.10024,
              0.1081,
              0.11597,
              0.12387,
              0.13179,
              0.13973,
              0.14769,
              0.15568,
              0.16368,
              0.17171,
              0.17976,
              0.18783,
              0.19592,
              0.20403,
              0.21217,
              0.22033,
              0.22851,
              0.23671,
              0.24494,
              0.25319,
              0.26146,
              0.26975,
              0.27807,
              0.28641,
              0.29477,
              0.30316,
              0.31157,
              0.32,
              0.31243,
              0.30485,
              0.29724,
              0.28961,
              0.28196,
              0.27429,
              0.26659,
              0.25888,
              0.25114,
              0.24338,
              0.2356,
              0.2278,
              0.21997,
              0.21212,
              0.20426,
              0.19636,
              0.18845,
              0.18051,
              0.17255,
              0.16457,
              0.15657,
              0.14854,
              0.14049,
              0.13241,
              0.12432,
              0.1162,
              0.10805,
              0.09988,
              0.09169,
              0.08348,
              0.07524,
              0.06698,
              0.05869,
              0.05038,
              0.04204,
              0.03368,
              0.0253,
              0.01689,
              0.00846,
              0,
              0.00754,
              0.0151,
              0.02269,
              0.0303,
              0.03793,
              0.04558,
              0.05325,
              0.06095,
              0.06867,
              0.07642,
              0.08419,
              0.09198,
              0.09979,
              0.10763,
              0.11549,
              0.12337,
              0.13128,
              0.13921,
              0.14717,
              0.15515,
              0.16316,
              0.17119,
              0.17924,
              0.18732,
              0.19542,
              0.20355,
              0.2117,
              0.21988,
              0.22808,
              0.23631,
              0.24456,
              0.25284,
              0.26114,
              0.26947,
              0.27783,
              0.28621,
              0.29462,
              0.30305,
              0.31151,
              0.32,
              0.31249,
              0.30495,
              0.29739,
              0.28981,
              0.2822,
              0.27457,
              0.26692,
              0.25924,
              0.25154,
              0.24381,
              0.23606,
              0.22828,
              0.22048,
              0.21265,
              0.2048,
              0.19692,
              0.18902,
              0.18109,
              0.17314,
              0.16516,
              0.15716,
              0.14913,
              0.14107,
              0.13299,
              0.12488,
              0.11674,
              0.10858,
              0.10039,
              0.09218,
              0.08393,
              0.07567,
              0.06737,
              0.05904,
              0.05069,
              0.04231,
              0.03391,
              0.02547,
              0.01701,
              0.00852,
              0,
              0.00748,
              0.01498,
              0.02251,
              0.03007,
              0.03765,
              0.04525,
              0.05288,
              0.06054,
              0.06822,
              0.07593,
              0.08367,
              0.09143,
              0.09922,
              0.10703,
              0.11487,
              0.12274,
              0.13063,
              0.13856,
              0.14651,
              0.15448,
              0.16249,
              0.17052,
              0.17858,
              0.18667,
              0.19478,
              0.20293,
              0.2111,
              0.2193,
              0.22753,
              0.23579,
              0.24408,
              0.25239,
              0.26074,
              0.26912,
              0.27752,
              0.28596,
              0.29442,
              0.30292,
              0.31144,
              0.32,
              0.31256,
              0.30509,
              0.29759,
              0.29007,
              0.28252,
              0.27495,
              0.26734,
              0.25971,
              0.25205,
              0.24436,
              0.23665,
              0.22891,
              0.22113,
              0.21333,
              0.2055,
              0.19765,
              0.18976,
              0.18185,
              0.1739,
              0.16593,
              0.15792,
              0.14989,
              0.14182,
              0.13373,
              0.12561,
              0.11745,
              0.10927,
              0.10105,
              0.09281,
              0.08453,
              0.07622,
              0.06788,
              0.05951,
              0.0511,
              0.04267,
              0.0342,
              0.0257,
              0.01716,
              0.0086,
              0,
              0.0074,
              0.01483,
              0.02228,
              0.02977,
              0.03728,
              0.04482,
              0.0524,
              0.06,
              0.06763,
              0.07529,
              0.08299,
              0.09071,
              0.09846,
              0.10625,
              0.11406,
              0.1219,
              0.12978,
              0.13769,
              0.14563,
              0.1536)

    result = pyssage.quadvar.pqv(create_test_transect())
    pyssage.graph.draw_quadvar_result(result, title="PQV Test", figoutput=pyssage.graph.FigOutput(figshow=True))
    for i in range(500):
        assert round(result[i, 1], 5) == answer[i]


def test_tqv():
    # answer calculated from PASSaGE 2 and exported to 5 decimals
    answer = (0.0077,
              0.01542,
              0.02318,
              0.03097,
              0.03879,
              0.04664,
              0.05452,
              0.06244,
              0.07039,
              0.07837,
              0.08638,
              0.09443,
              0.10251,
              0.11062,
              0.11876,
              0.12694,
              0.13516,
              0.1434,
              0.15168,
              0.16,
              0.18305,
              0.20619,
              0.22943,
              0.25277,
              0.27621,
              0.29975,
              0.32338,
              0.34712,
              0.37096,
              0.39489,
              0.41893,
              0.44308,
              0.46732,
              0.49167,
              0.51613,
              0.54069,
              0.56536,
              0.59013,
              0.61501,
              0.64,
              0.61699,
              0.59389,
              0.57068,
              0.54737,
              0.52396,
              0.50044,
              0.47682,
              0.4531,
              0.42927,
              0.40533,
              0.38129,
              0.35714,
              0.33289,
              0.30852,
              0.28404,
              0.25946,
              0.23476,
              0.20995,
              0.18503,
              0.16,
              0.15235,
              0.14466,
              0.13693,
              0.12917,
              0.12138,
              0.11355,
              0.10568,
              0.09778,
              0.08984,
              0.08186,
              0.07385,
              0.06579,
              0.0577,
              0.04958,
              0.04141,
              0.03321,
              0.02496,
              0.01668,
              0.00836,
              0,
              0.00764,
              0.01531,
              0.02302,
              0.03077,
              0.03855,
              0.04638,
              0.05424,
              0.06214,
              0.07007,
              0.07805,
              0.08606,
              0.09412,
              0.10221,
              0.11034,
              0.11852,
              0.12673,
              0.13499,
              0.14328,
              0.15162,
              0.16,
              0.18286,
              0.20583,
              0.22892,
              0.25212,
              0.27544,
              0.29888,
              0.32244,
              0.34612,
              0.36992,
              0.39385,
              0.41789,
              0.44206,
              0.46636,
              0.49078,
              0.51532,
              0.54,
              0.5648,
              0.58974,
              0.6148,
              0.64,
              0.6172,
              0.59429,
              0.57125,
              0.54809,
              0.5248,
              0.50139,
              0.47786,
              0.45419,
              0.4304,
              0.40649,
              0.38244,
              0.35826,
              0.33395,
              0.30951,
              0.28493,
              0.26022,
              0.23537,
              0.21039,
              0.18526,
              0.16,
              0.15242,
              0.1448,
              0.13714,
              0.12944,
              0.12169,
              0.1139,
              0.10606,
              0.09818,
              0.09026,
              0.08229,
              0.07427,
              0.06621,
              0.0581,
              0.04994,
              0.04174,
              0.03349,
              0.02519,
              0.01684,
              0.00845,
              0,
              0.00755,
              0.01515,
              0.02279,
              0.03048,
              0.03821,
              0.04599,
              0.05381,
              0.06169,
              0.06961,
              0.07758,
              0.08559,
              0.09366,
              0.10177,
              0.10994,
              0.11815,
              0.12642,
              0.13474,
              0.14311,
              0.15153,
              0.16,
              0.18257,
              0.20528,
              0.22814,
              0.25114,
              0.27429,
              0.29758,
              0.32102,
              0.34462,
              0.36836,
              0.39226,
              0.41631,
              0.44052,
              0.46489,
              0.48941,
              0.5141,
              0.53895,
              0.56396,
              0.58914,
              0.61449,
              0.64,
              0.61753,
              0.5949,
              0.57212,
              0.54919,
              0.5261,
              0.50286,
              0.47945,
              0.45589,
              0.43216,
              0.40828,
              0.38422,
              0.36,
              0.33561,
              0.31105,
              0.28632,
              0.26141,
              0.23633,
              0.21106,
              0.18562,
              0.16,
              0.15254,
              0.14504,
              0.13747,
              0.12986,
              0.12218,
              0.11445,
              0.10667,
              0.09882,
              0.09092,
              0.08296,
              0.07494,
              0.06687,
              0.05873,
              0.05053,
              0.04226,
              0.03394,
              0.02555,
              0.0171,
              0.00858,
              0,
              0.00741,
              0.01488,
              0.02241,
              0.03,
              0.03765,
              0.04535,
              0.05312,
              0.06095,
              0.06884,
              0.0768,
              0.08482,
              0.0929,
              0.10105,
              0.10927,
              0.11755,
              0.1259,
              0.13432,
              0.14281,
              0.15137,
              0.16,
              0.18209,
              0.20437,
              0.22684,
              0.24949,
              0.27234,
              0.29538,
              0.31863,
              0.34207,
              0.36571,
              0.38957,
              0.41362,
              0.43789,
              0.46238,
              0.48708,
              0.512,
              0.53714,
              0.56251,
              0.58811,
              0.61394,
              0.64,
              0.61808,
              0.59596,
              0.57364,
              0.55111,
              0.52837,
              0.50542,
              0.48225,
              0.45887,
              0.43526,
              0.41143,
              0.38737,
              0.36308,
              0.33855,
              0.31379,
              0.28878,
              0.26353,
              0.23803,
              0.21228,
              0.18627,
              0.16,
              0.15276,
              0.14545,
              0.13807,
              0.13061,
              0.12308,
              0.11546,
              0.10777,
              0.1,
              0.09215,
              0.08421,
              0.07619,
              0.06809,
              0.05989,
              0.05161,
              0.04324,
              0.03478,
              0.02623,
              0.01758,
              0.00884,
              0,
              0.00715,
              0.01438,
              0.02169,
              0.02909,
              0.03657,
              0.04414,
              0.05179,
              0.05953,
              0.06737,
              0.07529,
              0.08331,
              0.09143,
              0.09964)

    result = pyssage.quadvar.tqv(create_test_transect())
    pyssage.graph.draw_quadvar_result(result, title="tQV Test", figoutput=pyssage.graph.FigOutput(figshow=True))
    for i in range(333):
        assert round(result[i, 1], 5) == answer[i]


def test_2nlv():
    # answer calculated from PASSaGE 2 and exported to 5 decimals
    answer = (0.01539,
              0.03084,
              0.04636,
              0.06194,
              0.07758,
              0.09328,
              0.10905,
              0.12488,
              0.14077,
              0.15673,
              0.17276,
              0.18885,
              0.20501,
              0.22123,
              0.23753,
              0.25388,
              0.27031,
              0.2868,
              0.30337,
              0.32,
              0.33657,
              0.35299,
              0.36926,
              0.38543,
              0.40152,
              0.41753,
              0.43348,
              0.44939,
              0.46528,
              0.48113,
              0.49698,
              0.51282,
              0.52866,
              0.54451,
              0.56037,
              0.57625,
              0.59214,
              0.60807,
              0.62402,
              0.64,
              0.59354,
              0.55004,
              0.50927,
              0.47107,
              0.43526,
              0.4017,
              0.37024,
              0.34077,
              0.31315,
              0.28729,
              0.26308,
              0.24044,
              0.21928,
              0.19952,
              0.18108,
              0.16391,
              0.14794,
              0.13311,
              0.11937,
              0.10667,
              0.0949,
              0.08399,
              0.0739,
              0.06459,
              0.05602,
              0.04817,
              0.04101,
              0.03451,
              0.02864,
              0.02339,
              0.01872,
              0.01462,
              0.01107,
              0.00804,
              0.00552,
              0.0035,
              0.00195,
              0.00086,
              0.00021,
              0,
              0.00019,
              0.00075,
              0.00166,
              0.00293,
              0.00454,
              0.00647,
              0.00873,
              0.0113,
              0.01417,
              0.01734,
              0.02081,
              0.02455,
              0.02858,
              0.03287,
              0.03743,
              0.04224,
              0.04732,
              0.05263,
              0.0582,
              0.064,
              0.07,
              0.07618,
              0.08251,
              0.08901,
              0.09567,
              0.10249,
              0.10946,
              0.11658,
              0.12386,
              0.13128,
              0.13885,
              0.14657,
              0.15443,
              0.16243,
              0.17057,
              0.17885,
              0.18727,
              0.19582,
              0.20451,
              0.21333,
              0.20112,
              0.18935,
              0.17803,
              0.16714,
              0.15667,
              0.14662,
              0.13698,
              0.12774,
              0.1189,
              0.11044,
              0.10236,
              0.09465,
              0.08731,
              0.08033,
              0.07371,
              0.06743,
              0.0615,
              0.05591,
              0.05065,
              0.04571,
              0.04108,
              0.03671,
              0.03261,
              0.02876,
              0.02518,
              0.02184,
              0.01876,
              0.01592,
              0.01333,
              0.01097,
              0.00885,
              0.00697,
              0.00532,
              0.00389,
              0.00269,
              0.00172,
              0.00096,
              0.00043,
              0.00011,
              0,
              0.00009,
              0.00037,
              0.00084,
              0.00149,
              0.00232,
              0.00332,
              0.00451,
              0.00587,
              0.00741,
              0.00913,
              0.01101,
              0.01307,
              0.0153,
              0.01769,
              0.02025,
              0.02299,
              0.02588,
              0.02894,
              0.03217,
              0.03556,
              0.03908,
              0.04273,
              0.04649,
              0.05037,
              0.05436,
              0.05847,
              0.0627,
              0.06704,
              0.07149,
              0.07606,
              0.08074,
              0.08554,
              0.09045,
              0.09548,
              0.10061,
              0.10586,
              0.11123,
              0.11671,
              0.1223,
              0.128,
              0.12107,
              0.11436,
              0.10786,
              0.10158,
              0.09551,
              0.08965,
              0.08401,
              0.07857,
              0.07333,
              0.06831,
              0.06349,
              0.05887,
              0.05445,
              0.05023,
              0.04622,
              0.0424,
              0.03878,
              0.03535,
              0.03213,
              0.02909,
              0.02623,
              0.02352,
              0.02096,
              0.01855,
              0.01629,
              0.01418,
              0.01222,
              0.0104,
              0.00873,
              0.00721,
              0.00584,
              0.00461,
              0.00353,
              0.00259,
              0.0018,
              0.00115,
              0.00065,
              0.00029,
              0.00007,
              0,
              0.00006,
              0.00025,
              0.00055,
              0.00098,
              0.00154,
              0.00221,
              0.00301,
              0.00393,
              0.00498,
              0.00614,
              0.00743,
              0.00885,
              0.01038,
              0.01205,
              0.01383,
              0.01574,
              0.01777,
              0.01993,
              0.02221,
              0.02462,
              0.02713,
              0.02972,
              0.03241,
              0.03517,
              0.03802,
              0.04096,
              0.04399,
              0.0471,
              0.0503,
              0.05359,
              0.05697,
              0.06043,
              0.06399,
              0.06763,
              0.07137,
              0.0752,
              0.07912,
              0.08313,
              0.08723,
              0.09143,
              0.0866,
              0.08191,
              0.07736,
              0.07295,
              0.06867,
              0.06454,
              0.06054,
              0.05669,
              0.05297,
              0.04939,
              0.04595,
              0.04266,
              0.0395,
              0.03648,
              0.0336,
              0.03086,
              0.02827,
              0.02581,
              0.0235,
              0.02133,
              0.01929,
              0.01734,
              0.01549,
              0.01375,
              0.01211,
              0.01057,
              0.00913,
              0.00779,
              0.00656,
              0.00543,
              0.00441,
              0.00349,
              0.00268,
              0.00197,
              0.00137,
              0.00088,
              0.0005,
              0.00022,
              0.00006,
              0,
              0.00004,
              0.00018,
              0.0004,
              0.00072,
              0.00113,
              0.00162,
              0.00222,
              0.0029,
              0.00369,
              0.00456,
              0.00554,
              0.00661,
              0.00778,
              0.00905,
              0.01042,
              0.01189,
              0.01347,
              0.01515,
              0.01693,
              0.01882,
              0.0208,
              0.02284,
              0.02493,
              0.0271,
              0.02932,
              0.03161,
              0.03397,
              0.03639,
              0.03889,
              0.04145,
              0.04408,
              0.04678,
              0.04956,
              0.0524,
              0.05533,
              0.05833,
              0.0614,
              0.06456,
              0.06779,
              0.07111,
              0.06741,
              0.0638,
              0.06029,
              0.05688,
              0.05358,
              0.05037,
              0.04727,
              0.04427,
              0.04137,
              0.03859,
              0.03591,
              0.03333,
              0.03087,
              0.02852,
              0.02628,
              0.02416,
              0.02215,
              0.02026,
              0.01849,
              0.01684,
              0.01529,
              0.0138,
              0.01238,
              0.01103,
              0.00976,
              0.00855,
              0.00742,
              0.00636,
              0.00538,
              0.00448,
              0.00365,
              0.0029,
              0.00224,
              0.00166,
              0.00116,
              0.00075,
              0.00042,
              0.00019,
              0.00005,
              0,
              0.00003,
              0.00013,
              0.00029,
              0.00053,
              0.00083,
              0.00121,
              0.00166,
              0.00218,
              0.00279,
              0.00347,
              0.00423,
              0.00508,
              0.00602,
              0.00705,
              0.00816,
              0.00938,
              0.01069,
              0.0121,
              0.01362,
              0.01524,
              0.01693,
              0.01867,
              0.02044,
              0.02224,
              0.02409,
              0.02599,
              0.02792,
              0.02991,
              0.03194,
              0.03402,
              0.03615,
              0.03834,
              0.04059,
              0.0429,
              0.04527,
              0.04771,
              0.05021,
              0.05279,
              0.05545,
              0.05818,
              0.05517,
              0.05223,
              0.04935,
              0.04654,
              0.0438,
              0.04114,
              0.03855,
              0.03604,
              0.03362,
              0.03129,
              0.02905,
              0.0269,
              0.02486,
              0.02292,
              0.0211,
              0.01939,
              0.01781,
              0.01637,
              0.01507,
              0.01391,
              0.01285,
              0.01181,
              0.0108,
              0.00981,
              0.00885,
              0.00792,
              0.00702,
              0.00615,
              0.00533,
              0.00454,
              0.0038,
              0.0031,
              0.00246,
              0.00187,
              0.00135,
              0.0009,
              0.00053,
              0.00024,
              0.00006,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0)

    result = pyssage.quadvar.two_nlv(create_test_transect())
    pyssage.graph.draw_quadvar_result(result, title="2NLV Test", figoutput=pyssage.graph.FigOutput(figshow=True))
    for i in range(499):
        assert round(result[i, 1], 5) == answer[i]


def test_3nlv():
    # answer calculated from PASSaGE 2 and exported to 5 decimals
    answer = (0.00385,
              0.01545,
              0.02196,
              0.03109,
              0.03821,
              0.04692,
              0.05435,
              0.06295,
              0.0706,
              0.07918,
              0.087,
              0.0956,
              0.10358,
              0.11109,
              0.11366,
              0.11294,
              0.10854,
              0.10193,
              0.09259,
              0.0817,
              0.10109,
              0.12259,
              0.14526,
              0.16966,
              0.19495,
              0.2217,
              0.24871,
              0.27738,
              0.30531,
              0.33465,
              0.3633,
              0.39327,
              0.42259,
              0.45317,
              0.48313,
              0.51428,
              0.54485,
              0.57657,
              0.60773,
              0.64,
              0.57801,
              0.52139,
              0.46829,
              0.41994,
              0.37462,
              0.33354,
              0.29508,
              0.26044,
              0.22806,
              0.19915,
              0.17222,
              0.14845,
              0.12642,
              0.1072,
              0.08947,
              0.07363,
              0.05932,
              0.04676,
              0.03559,
              0.02602,
              0.02774,
              0.02866,
              0.02856,
              0.02772,
              0.02593,
              0.02346,
              0.02014,
              0.01703,
              0.01409,
              0.01157,
              0.00922,
              0.00726,
              0.00544,
              0.004,
              0.0027,
              0.00175,
              0.00092,
              0.00043,
              0.00005,
              0,
              0.00005,
              0.00037,
              0.00079,
              0.00147,
              0.00223,
              0.00325,
              0.00435,
              0.00569,
              0.00711,
              0.00877,
              0.01049,
              0.01245,
              0.01447,
              0.01656,
              0.01798,
              0.01888,
              0.0191,
              0.01881,
              0.01788,
              0.01646,
              0.02106,
              0.02642,
              0.03237,
              0.03907,
              0.04634,
              0.05434,
              0.06278,
              0.07199,
              0.08134,
              0.0914,
              0.1016,
              0.1125,
              0.12353,
              0.13526,
              0.14712,
              0.15966,
              0.17234,
              0.18569,
              0.19918,
              0.21333,
              0.19585,
              0.17948,
              0.16367,
              0.14895,
              0.13478,
              0.12167,
              0.10908,
              0.09753,
              0.08649,
              0.07647,
              0.06694,
              0.05841,
              0.05035,
              0.04324,
              0.03652,
              0.0304,
              0.02475,
              0.01967,
              0.01507,
              0.01103,
              0.01189,
              0.01242,
              0.01251,
              0.01227,
              0.01159,
              0.01059,
              0.00919,
              0.00784,
              0.00655,
              0.00543,
              0.00437,
              0.00347,
              0.00263,
              0.00195,
              0.00132,
              0.00086,
              0.00046,
              0.00022,
              0.00003,
              0,
              0.00002,
              0.00018,
              0.00039,
              0.00074,
              0.00113,
              0.00166,
              0.00223,
              0.00295,
              0.00371,
              0.00461,
              0.00556,
              0.00664,
              0.00778,
              0.00896,
              0.00979,
              0.01035,
              0.01055,
              0.01046,
              0.01001,
              0.00928,
              0.01179,
              0.01478,
              0.01815,
              0.02199,
              0.02621,
              0.03092,
              0.03595,
              0.04144,
              0.04705,
              0.05307,
              0.05921,
              0.06579,
              0.07248,
              0.07961,
              0.08687,
              0.09457,
              0.1024,
              0.11069,
              0.11911,
              0.128,
              0.11789,
              0.10837,
              0.09912,
              0.09046,
              0.08207,
              0.07428,
              0.06676,
              0.05984,
              0.05319,
              0.04716,
              0.0414,
              0.03626,
              0.03141,
              0.02713,
              0.02304,
              0.01926,
              0.01572,
              0.01249,
              0.00951,
              0.00684,
              0.00742,
              0.0078,
              0.00791,
              0.0078,
              0.00742,
              0.00682,
              0.00596,
              0.00512,
              0.0043,
              0.00359,
              0.00291,
              0.00232,
              0.00177,
              0.00132,
              0.0009,
              0.00059,
              0.00032,
              0.00015,
              0.00002,
              0,
              0.00001,
              0.00012,
              0.00025,
              0.00047,
              0.00072,
              0.00107,
              0.00146,
              0.00194,
              0.00245,
              0.00307,
              0.00373,
              0.0045,
              0.00531,
              0.00616,
              0.00679,
              0.00724,
              0.00744,
              0.00744,
              0.00718,
              0.00671,
              0.00827,
              0.0102,
              0.01246,
              0.0151,
              0.0181,
              0.02151,
              0.02525,
              0.02929,
              0.03339,
              0.03774,
              0.04216,
              0.04685,
              0.05163,
              0.0567,
              0.06187,
              0.06735,
              0.07295,
              0.0789,
              0.08498,
              0.09143,
              0.08431,
              0.07756,
              0.07096,
              0.06474,
              0.05869,
              0.05306,
              0.04761,
              0.04261,
              0.03783,
              0.03353,
              0.02947,
              0.02595,
              0.0227,
              0.01996,
              0.01721,
              0.01452,
              0.01186,
              0.00928,
              0.00673,
              0.00427,
              0.00473,
              0.0051,
              0.00529,
              0.00536,
              0.00523,
              0.00495,
              0.00445,
              0.00394,
              0.00342,
              0.00295,
              0.00247,
              0.00205,
              0.00163,
              0.00127,
              0.00091,
              0.00062,
              0.00035,
              0.00018,
              0.00002,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0)

    result = pyssage.quadvar.three_nlv(create_test_transect())
    pyssage.graph.draw_quadvar_result(result, title="3NLV Test", figoutput=pyssage.graph.FigOutput(figshow=True))
    for i in range(333):
        assert round(result[i, 1], 5) == answer[i]


def test_ttlqv_random():
    # fixed answer not possible due to stochastic nature of test. instead tests algorithm does not crash and
    # produces a visual result for general insepction
    summary, _ = pyssage.quadvar.quadrat_variance_randomization(pyssage.quadvar.ttlqv, 100, create_test_transect(),
                                                                max_block_size=100)
    pyssage.graph.draw_quadvar_result(summary[:, 0:2], summary[:, 2], title="TTLQV Test with Randomization",
                                      varlabel="Observed", randlabel="{:0.2%} confidence limit".format(0.95),
                                      figoutput=pyssage.graph.FigOutput(figshow=True))


def test_threetlqv_random():
    # fixed answer not possible due to stochastic nature of test. instead tests algorithm does not crash and
    # produces a visual result for general insepction
    summary, _ = pyssage.quadvar.quadrat_variance_randomization(pyssage.quadvar.three_tlqv, 100, create_test_transect(),
                                                                max_block_size=100)
    pyssage.graph.draw_quadvar_result(summary[:, 0:2], summary[:, 2], title="3TLQV Test with Randomization",
                                      varlabel="Observed", randlabel="{:0.2%} confidence limit".format(0.95),
                                      figoutput=pyssage.graph.FigOutput(figshow=True))


def test_pqv_random():
    # fixed answer not possible due to stochastic nature of test. instead tests algorithm does not crash and
    # produces a visual result for general insepction
    summary, _ = pyssage.quadvar.quadrat_variance_randomization(pyssage.quadvar.pqv, 50, create_test_transect(),
                                                                max_block_size=50)
    pyssage.graph.draw_quadvar_result(summary[:, 0:2], summary[:, 2], title="PQV Test with Randomization",
                                      varlabel="Observed", randlabel="{:0.2%} confidence limit".format(0.95),
                                      figoutput=pyssage.graph.FigOutput(figshow=True))


def test_tqv_random():
    # fixed answer not possible due to stochastic nature of test. instead tests algorithm does not crash and
    # produces a visual result for general insepction
    summary, _ = pyssage.quadvar.quadrat_variance_randomization(pyssage.quadvar.tqv, 50, create_test_transect(),
                                                                max_block_size=50)
    pyssage.graph.draw_quadvar_result(summary[:, 0:2], summary[:, 2], title="TQV Test with Randomization",
                                      varlabel="Observed", randlabel="{:0.2%} confidence limit".format(0.95),
                                      figoutput=pyssage.graph.FigOutput(figshow=True))


def test_2nlv_random():
    # fixed answer not possible due to stochastic nature of test. instead tests algorithm does not crash and
    # produces a visual result for general insepction
    summary, _ = pyssage.quadvar.quadrat_variance_randomization(pyssage.quadvar.two_nlv, 100, create_test_transect(),
                                                                max_block_size=100)
    pyssage.graph.draw_quadvar_result(summary[:, 0:2], summary[:, 2], title="2NLV Test with Randomization",
                                      varlabel="Observed", randlabel="{:0.2%} confidence limit".format(0.95),
                                      figoutput=pyssage.graph.FigOutput(figshow=True))


def test_threet_nlv_random():
    # fixed answer not possible due to stochastic nature of test. instead tests algorithm does not crash and
    # produces a visual result for general insepction
    summary, _ = pyssage.quadvar.quadrat_variance_randomization(pyssage.quadvar.three_nlv, 100, create_test_transect(),
                                                                max_block_size=100)
    pyssage.graph.draw_quadvar_result(summary[:, 0:2], summary[:, 2], title="3NLV Test with Randomization",
                                      varlabel="Observed", randlabel="{:0.2%} confidence limit".format(0.95),
                                      figoutput=pyssage.graph.FigOutput(figshow=True))

    """
    Notes:
    
    2NLV and 3NLV do not have the same formula as in the passage manual; in particular the denominator is not the 
    same. Need to check references and see if there is a good reason why.
    
    """


def test_4tlqv():
    # discovered small bug in PASSaGE 2 analysis, which caused a very minor shift in the values. can therefore not
    # use for testing purposes
    result = pyssage.quadvar.four_tlqv(create_test_surface())
    pyssage.graph.draw_quadvar_result(result, title="4TLQV Test", figoutput=pyssage.graph.FigOutput(figshow=True))


def test_9tlqv():
    # answer calculated from PASSaGE 2 and exported to 5 decimals
    answer = (0.04498,
              0.10895,
              0.21302,
              0.35183,
              0.49153,
              0.57159,
              0.57633,
              0.50129,
              0.38749,
              0.27113,
              0.1747,
              0.12292,
              0.08447,
              0.04966,
              0.021,
              0.00554,
              0.00119,
              0.00017,
              0.00001,
              0,
              0,
              0.00007,
              0.00046,
              0.00162,
              0.00354,
              0.00587,
              0.01004,
              0.01471,
              0.01713,
              0.01317,
              0.00329,
              0.00043,
              0.00001)

    result = pyssage.quadvar.nine_tlqv(create_test_surface())
    pyssage.graph.draw_quadvar_result(result, title="9TLQV Test", figoutput=pyssage.graph.FigOutput(figshow=True))
    for i in range(33):
        assert round(result[i, 1], 5) == answer[i]


def test_5qv():
    # answer calculated from PASSaGE 2 and exported to 5 decimals
    #   only testing first 33 values because P2 restricted this to 1/3 of size rather than 1/2
    answer = (0.02174,
              0.05156,
              0.09045,
              0.13951,
              0.2,
              0.29421,
              0.39989,
              0.51837,
              0.65116,
              0.8,
              0.67758,
              0.55568,
              0.43492,
              0.31605,
              0.2,
              0.15017,
              0.10413,
              0.06289,
              0.02768,
              0,
              0.02021,
              0.04847,
              0.08642,
              0.13609,
              0.2,
              0.28611,
              0.38601,
              0.50248,
              0.639,
              0.8,
              0.69197,
              0.57778,
              0.45744)

    result = pyssage.quadvar.five_qv(create_test_surface())
    pyssage.graph.draw_quadvar_result(result, title="5QV Test", figoutput=pyssage.graph.FigOutput(figshow=True))
    for i in range(33):
        assert round(result[i, 1], 5) == answer[i]
