from .features import RegexMatches, Stopwords

name = "albanian"

# No dictionary

# No stemmer

# noqa Copied from https://www.mediawiki.org/wiki/Research:Revision_scoring_as_a_service/Word_lists/sq
stopwords = [
    "administrimi", "ajo", "apo", "artikulli", "ashtu", "ata", "ato",
    "atë", "automjeteve", "biografi", "burimet", "bën", "bërë", "cila",
    "cilat", "cili", "cilën", "cilët", "coordaddon", "cung", "data", "date",
    "demografia", "dendësia", "deri", "dhe", "dhëna", "disa", "duhet", "duke",
    "dytë", "edhe", "emri", "emrin", "faqe", "figura", "fillim", "filloi",
    "fizike", "flamuri", "foto", "fund", "fundit", "gjat", "gjatë", "gjatësi",
    "gjatësia", "gjer", "gjerësi", "gjerësia", "gjitha", "gjithashtu",
    "gjithë", "gjuha", "harta", "herë", "historia", "ish", "ishin",
    "ishte", "janar", "janë", "jashtme", "jeta", "jetojnë", "jetë",
    "jugosllave", "kanë", "kategoria", "kishte", "kjo",
    "kodi", "kohore", "kohë", "kohës", "komuna", "komunën",
    "komunës", "koordinatat", "korrik", "krahina", "kryesore", "kryetari",
    "kundër", "kur", "kësaj", "kështu", "këtij", "këto", "këtë", "lartë",
    "lartësia", "libra", "lidhje", "lindi", "lindje", "lista", "lloji",
    "luftës", "madh", "madhe", "maj", "marrë", "mars", "mbi", "mes", "mirë",
    "mos", "mund", "mëdha", "mënyra", "mënyrë", "name", "ndryshme", "ndër",
    "ndërsa", "nga", "njerëz", "njohur", "një", "nuk", "nën", "ose", "pak",
    "palidhur", "pamje", "pamjes", "para", "partia", "parë", "pas", "pasi",
    "pastaj", "pasur", "per", "pjesë", "popullsia", "por", "postal",
    "prefiksi", "prej", "prill", "pse", "për", "përshkrimi", "qenë",
    "qershor", "rajoni", "ref", "referenca", "referencat", "references",
    "republika", "right", "rreth", "saj", "sepse", "shih", "shiko",
    "shkak", "shkurt", "shtator", "shteti", "shume", "shumë",
    "shënimi", "sipas", "sipërfaqja", "skeda", "sot", "statistika", "stema",
    "tani", "targa", "tek", "territorial", "the", "thumb", "tij",
    "title", "titulli", "tjera", "tjerë", "tjetër", "tre", "tyre",
    "udhëheqëse", "vdekje", "vend", "vendasit", "vendbanim", "verore",
    "vetëm", "vite", "vitet", "viteve", "viti", "vitin", "vitit", "vjet",
    "vogël", "vonë", "zona", "zyrtare", "çdo", "është"
]
"""
:class:`~revscoring.languages.features.Stopwords` features copied from
"""

stopwords = Stopwords(name + ".stopwords", stopwords)

badword_regexes = [
    r"alexeev",
    r"amazingdusseldorf",
    r"amerikanjizor",
    r"baloncesto",
    r"bande",
    r"banya",
    r"bator",
    r"baturina",
    r"beker",
    r"ber",
    r"biuro",
    r"bole",
    r"bolshoj",
    r"brezhnjevit",
    r"budalla",
    r"budalle",
    r"budallë",
    r"bushter",
    r"bushtre",
    r"bushtër",
    r"byth",
    r"bythec",
    r"bythqir",
    r"bythqirë",
    r"bythë",
    r"carët",
    r"categoria",
    r"centurionëve",
    r"cet",
    r"cezanne",
    r"chadwik",
    r"chaika",
    r"cica",
    r"cicë",
    r"cmimi",
    r"commpton",
    r"comt",
    r"condado",
    r"contea",
    r"dcoyrpca",
    r"debil",
    r"debile",
    r"debill",
    r"deripaska",
    r"derr",
    r"deshtak",
    r"dessin",
    r"detoksifikuese",
    r"dheura",
    r"didn",
    r"diplomatrus",
    r"doha",
    r"dolgoruki",
    r"dredharake",
    r"dzial",
    r"dështakë",
    r"dështak",
    r"deshtak",
    r"ehrenfest",
    r"emmss",
    r"esht",
    r"eshte",
    r"fedor",
    r"fermion",
    r"fizikië",
    r"fizioni",
    r"foundin",
    r"freewebtown",
    r"fresko",
    r"fyell",
    r"georgio",
    r"gjith",
    r"gjithe",
    r"gllup",
    r"gomar",
    r"gona",
    r"gonik",
    r"gorkipark",
    r"gorky",
    r"gotingen",
    r"grend",
    r"grise",
    r"gts",
    r"guderian",
    r"guzhine",
    r"hacked",
    r"hajvan",
    r"haodym",
    r"hierarkizuar",
    r"hollet",
    r"homoseksual",
    r"homosexueal",
    r"hor",
    r"horr",
    r"horra",
    r"horre",
    r"hrabstwo",
    r"internacionale",
    r"iovao",
    r"izmaylovsky",
    r"jelgava",
    r"jgbi",
    r"joohr",
    r"kalifatietëria",
    r"kantono",
    r"kar",
    r"karakteirzuar",
    r"kari",
    r"karin",
    r"karit",
    r"karuc",
    r"katunar",
    r"katundar",
    r"kekun",
    r"kolomna",
    r"komshi",
    r"kopil",
    r"kopuk",
    r"koqe",
    r"kot",
    r"krep",
    r"kreten",
    r"krploschad",
    r"kuark",
    r"kujtoini",
    r"kurv",
    r"kurvë",
    r"kurva",
    r"kurvar",
    r"kurve",
    r"kushof",
    r"kushtetucenturionëve",
    r"kushtueshem",
    r"kuytryzertyshtrim",
    r"laekzistencës",
    r"lavire",
    r"lehtënë",
    r"lepton",
    r"lesh",
    r"localgovt",
    r"lope",
    r"lopë",
    r"loqe",
    r"luzhkov",
    r"majakovskaja",
    r"malyi",
    r"managery",
    r"manakor",
    r"margaritit",
    r"marrë",
    r"matuf",
    r"mbikodrinore",
    r"mbretitit",
    r"mbërritjes",
    r"michailowitsch",
    r"mietner",
    r"mockbuster",
    r"mokekao",
    r"mosbesnikëri",
    r"mosco",
    r"moscobha",
    r"moscohuia",
    r"moskov",
    r"moskovas",
    r"moskuas",
    r"moskvich",
    r"mrtix",
    r"musique",
    r"mut",
    r"muti",
    r"mutin",
    r"mështekne",
    r"nadal",
    r"nadals",
    r"name",
    r"nanen",
    r"naryan",
    r"nbsp",
    r"ncedh",
    r"ndenjjeje",
    r"newkosova",
    r"nigga",
    r"njpe",
    r"njëeoria",
    r"nonen",
    r"novy",
    r"osakas",
    r"osht",
    r"palaço",
    r"pallacanestro",
    r"paftyrë",
    r"paftyr",
    r"paftyre",
    r"palloj",
    r"pampered",
    r"pararevolucionarë",
    r"parera",
    r"partnerskie",
    r"paskha",
    r"pavarstorianët",
    r"peder",
    r"pederast",
    r"pedofil",
    r"per",
    r"performuara",
    r"pidh",
    r"pidh",
    r"pidhar",
    r"pidhu",
    r"pie",
    r"pirdhu",
    r"pishinat",
    r"populluarit",
    r"porcelane",
    r"pordha",
    r"pordhe",
    r"prokhorov",
    r"promocji",
    r"prostitut",
    r"prostitutë",
    r"provojmë",
    r"pshurr",
    r"pussy",
    r"përshëndesje",
    r"qelbsir",
    r"qelbsire",
    r"qelbësirë",
    r"qen",
    r"qi",
    r"qifsh",
    r"qifsha",
    r"qiu",
    r"qiu",
    r"qiju",
    r"qsdfesef",
    r"rafa",
    r"rafaels",
    r"rasht",
    r"really",
    r"republshtë",
    r"reçensionit",
    r"rips",
    r"robqire",
    r"robqirë",
    r"robt",
    r"ropt",
    r"rossiya",
    r"rrugac",
    r"rrugaç",
    r"rublev",
    r"sandunovskiye",
    r"semi",
    r"serebryaniy",
    r"setun",
    r"shkalluar",
    r"shkerdhat",
    r"shkerdhatë",
    r"shkërdhej",
    r"shum",
    r"shume",
    r"shurrë",
    r"sib",
    r"sibneft",
    r"sistercities",
    r"slem",
    r"yes",
    r"slita",
    r"sokolniki",
    r"sorrë",
    r"speciale",
    r"sperma",
    r"stalla",
    r"starkov",
    r"stupid",
    r"syrenka",
    r"telefonatëtë",
    r"tells",
    r"tenis",
    r"teniserëve",
    r"tenist",
    r"tenisti",
    r"tenistët",
    r"teplostanskaya",
    r"terrenet",
    r"teveqel",
    r"thi",
    r"tinajxher",
    r"tnjë",
    r"transuranik",
    r"trap",
    r"trapin",
    r"trbrmca",
    r"tretiakov",
    r"tretyakov",
    r"tretyakovi",
    r"tretyakovskaya",
    r"tsvetaevas",
    r"tsvetnoy",
    r"une",
    r"vaginë",
    r"vraft",
    r"warszawy",
    r"wxcvwxcvwxcvwxcvwvc",
    r"xhentilesë",
    r"yausa",
    r"yelena",
    r"zagar",
    r"zezak",
    r"zhyteni",
    r"zuskë",
    r"çerekshekull",
    r"çitt",
    r"ëodyë"
]

badwords = RegexMatches(name + ".badwords", badword_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
badword detecting regexes.
"""

informal_regexes = [
    r"a?h+[aiou]+(h[aeiou]*)*",
    r"alarmues",
    r"btw",
    r"cdo",
    r"cool",
    r"dreq",
    r"eshte",
    r"ftw",
    r"hata",
    r"h+[e]+(h[aeiou]*)+",
    r"hej",
    r"hihi",
    r"joohr",
    r"kohe",
    r"kosov",
    r"kosova",
    r"kosovë",
    r"lol",
    r"mirësevjen",
    r"moj",
    r"mor",
    r"ndersa",
    r"nje",
    r"njerez",
    r"ok",
    r"okej",
    r"old",
    r"omg",
    r"ora",
    r"përshëndetje",
    r"qene",
    r"shqiperi",
    r"shqipëri",
    r"shqipëria",
    r"shqipërisë",
    r"sib",
    r"suck",
    r"te",
    r"the",
    r"vetem",
    r"wow",
    r"yeah",
    r"yes",
    r"yolo"
]

informals = RegexMatches(name + ".informals", informal_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
informal word detecting regexes.
"""
