import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage Groups assigned to an Application
 *
 * @schema CfnGroupApplicationAssociationProps
 */
export interface CfnGroupApplicationAssociationProps {
    /**
     * id of an app
     *
     * @schema CfnGroupApplicationAssociationProps#ApplicationId
     */
    readonly applicationId: string;
    /**
     * unique key of a valid Group
     *
     * @schema CfnGroupApplicationAssociationProps#GroupId
     */
    readonly groupId: string;
}
/**
 * Converts an object of type 'CfnGroupApplicationAssociationProps' to JSON representation.
 */
export declare function toJson_CfnGroupApplicationAssociationProps(obj: CfnGroupApplicationAssociationProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Okta::Group::GroupApplicationAssociation`
 *
 * @cloudformationResource Okta::Group::GroupApplicationAssociation
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-okta-resource-providers.git
 */
export declare class CfnGroupApplicationAssociation extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Okta::Group::GroupApplicationAssociation";
    /**
     * Resource props.
     */
    readonly props: CfnGroupApplicationAssociationProps;
    /**
     * Create a new `Okta::Group::GroupApplicationAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnGroupApplicationAssociationProps);
}
