# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['bcsim']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['bcsim = bcsim.__main__:main']}

setup_kwargs = {
    'name': 'bcsim',
    'version': '1.0.6',
    'description': 'Rolling Ball Clock Simulator',
    'long_description': '![GitHub](https://img.shields.io/github/license/geozeke/bcsim)\n![PyPI](https://img.shields.io/pypi/v/bcsim)\n![PyPI - Status](https://img.shields.io/pypi/status/bcsim)\n![GitHub last commit](https://img.shields.io/github/last-commit/geozeke/bcsim)\n![GitHub issues](https://img.shields.io/github/issues/geozeke/bcsim)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/bcsim)\n![GitHub repo size](https://img.shields.io/github/repo-size/geozeke/bcsim)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/bcsim)\n\n<br>\n\n<img src="https://github.com/geozeke/bcsim/blob/main/docs/logo.png?raw=true" width="120"/>\n\n# Ball Clock Simulator\n\n## A note to developers\n\nIf you\'re just using bcsim, then carry on!\n\nIf you\'re a developer looking to fork this repository and modify bcsim,\nthere are two important considerations:\n\n1. I used [poetry](https://python-poetry.org/) for dependency and publication\n   management when developing bcsim. Poetry is well behaved and if you\'re a\n   Python developer you should check it out. It installs itself in a virtual\n   environment, uninstalls cleanly and easily, and doesn\'t require `sudo` for\n   installation. To install poetry, run this command:\n\n   ```shell\n   curl -sSL https://install.python-poetry.org | python3 -\n   ```\n\n2. I\'ve included a file called `global-gitignore.txt` which is a copy of the\n   `.gitignore` I placed in my home directory and configured globally for all\n   my development projects. The `global-gitignore.txt` file reflects my\n   development setup (for example using tools like vscode), but yours may be\n   different. Just cherry-pick any necessary elements from\n   `global-gitignore.txt` for your own use.\n\n   *Details on gitignore files are available on\n   [GitHub](https://docs.github.com/en/get-started/getting-started-with-git/ignoring-files).*\n\n## Installation\n\nThe Ball Clock Simulator is lightweight, pure Python, with no third-party\ndependencies.\n\n```text\npip3 install bcsim  \n```\n\n## Usage\n\nTo display the help menu, run:\n\n```text\nbcsim -h\n```\n\n## Documentation\n\nSee: [Ball Clock API Documentation](https://geozeke.github.io/bcsim)\n\n## What Is A Ball Clock?\n\nStart with this [YouTube video](https://www.youtube.com/watch?v=F7K6GIBWPQw)\nthat describes exactly what a Ball Clock is. It gives you a good overview of\nhow it works.\n\n## What Does This Program Do?\n\nI have one of the clocks shown in the video (I also have one of [these\nclocks](https://www.idle-tyme.com/)).\n\nOne day, I was staring at it and I thought: *When the clock shows 1:00 and all\nthe balls are in the input tray (what I call the reservoir) they\'re in a\ncertain order. I wonder how long the clock has to run before the balls return\nto that same ordering again.*\n\nIt turns out I\'m not even close to the first person to ask this question. The\n[Ball Clock Problem](http://www.chilton.com/~jimw/ballclk.html) has been\nrattling around the internet as at least as far back as 1995. Just go to\nGitHub, type "Ball Clock", and you\'ll get lots of hits. Like those simulations,\nmy program runs the clock and counts the number of days that pass until the\nballs all return to their original starting order in the reservoir.\n\n## How Is This Ball Clock Simulator Different?\n\nIt\'s written in Python.\n\nIn the [YouTube video](https://www.youtube.com/watch?v=F7K6GIBWPQw), starting\naround 2:10, you\'ll hear a description of a little plastic lever (what I call\nthe "cam") that prevents the balls in the 5-min rail from colliding with the\nballs in the hr-rail when the clock strikes 1:00. The physical clock would have\nissues if that cam were not present, but there\'s no need for it in a virtual\nclock. I\'ve been able to reproduce the results of others, which assume the cam\nis not present, but the combinatorics are radically different when the cam is\nthere. In that regard my simulation is a little unique.\n\nBesides choosing to model the cam, I noticed another variation on how some\nother simulators assume the clock mechanics work.\n\nThere seems to broad consensus about how the clock mechanics work until you go\nfrom 12:59 to 1:00. All the other simulators I\'ve seen assume that the last\nball to drop between 12:59 and 1:00 comes back into the reservoir last. After\nobserving my own clock carefully and stepping through the YouTube video, I feel\nconfident that the last ball to drop between 12:59 and 1:00 actually cycles\nback to the reservoir just ***before*** the balls in the hour rail. To see what\nI mean, set the playback speed on [the\nvideo]((https://www.youtube.com/watch?v=F7K6GIBWPQw)) to 0.25x, advance it to\nthe 4:00 mark, and press play. I found it fascinating that this one little\ndifference also had a massive effect on the simulation results.\n\nThe simulator allows you to concurrently run different scenarios from 27 (the\nminimum number of balls required to run the clock) up to 1,000 balls, and you\ncan save your results to a csv file for later analysis. It uses multiprocessing\nto concurrently cycle *n* clocks at a time, where *n* is the number of\navailable CPUs on your computer. In addition to utilizing multiprocessing, the\nsimulator takes advantage of a unique repeating pattern to further speed up\ncalculations.\n\nAt each 12-hr interval, all the balls in the clock are in the reservoir. If you\nstart with a fresh clock and brute-force cycle it for 720 minutes (12-hrs),\nthen you get what I call a permutation vector in the reservoir. You can now\ntreat each ball number in the reservoir as an index (position) for the movement\nof the balls every 12-hrs.\n\nFor example: if cycling a fresh clock 12-hrs results in ball #10 ending up in\nposition #2, that means every 12-hrs the ball in position #10 will migrate to\nposition #2. Using two Python lists, we can now cycle the clock for 12-hrs each\n"tick", rather then 1-minute for each "tick". The speed gains in clock cycling\nare dramatic.\n\nI also found that several clocks will cycle back to the initial condition in a\nfractional number of days -- 18.5 days in the case of a clock with 38 balls.\nThis may have something to do with the way I\'ve modeled the clock mechanics,\nbut I couldn\'t find another solution to the Ball Clock problem that cycled a\ngiven clock on the 12-hr boundary; they all cycled for a whole number of days.\n\n## Peer(less) Review\n\nWriting this simulator gave me some great practice with Python programming\ntopics: argument parsing, classes, multiprocessing, inter-process\ncommunication, queues and project packaging (pypi). While not required to use\nthe program, I also included detailed API documentation for those who are\ninterested.\n\nIt\'s not really practical to validate my assumptions using a physical clock --\nin some cases it takes billions of simulated days to cycle back to the starting\nposition. I would love it if someone coded this up independently, using the\nsame clock mechanics I describe, and validated or invalidated the program\'s\nresults.\n\n## Version History\n\n* 1.0.6 (2022-10-23)\n  * Migrated dependency/build management to [poetry](https://python-poetry.org/).<br><br>\n* 1.0.5 (2022-01-17)\n  * Code/documentation linting and cleanup.<br><br>\n* 1.0.4 (2022-01-09)\n  * Fixed a display glitch in the window that counts the number of clocks in\n    queue.<br><br>\n* 1.0.3 (2022-01-03)\n  * Adjusted display width to support counting days with up to three digits in\n    the trillions column: 999,999,999,999,999.<br><br>\n* 1.0.2 (2021-12-23)\n  * Documentation cleanup.\n  * Added site logo to README.md file.<br><br>\n* 1.0.1 (2021-12-13)\n  * Initial release\n',
    'author': 'Peter Nardi',
    'author_email': 'pete@nardi.com',
    'maintainer': 'Peter Nardi',
    'maintainer_email': 'pete@nardi.com',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
