/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.utils;

import hex.genmodel.utils.ByteBufferWrapper;

public class GenmodelBitSet {
    private byte[] _val;
    private int _byteoff;
    private int _nbits;
    private int _bitoff;

    public GenmodelBitSet(int nbits) {
        this(nbits, 0);
    }

    public GenmodelBitSet(int nbits, int bitoff) {
        if (bitoff + nbits <= 32) {
            bitoff = 0;
            nbits = 32;
        }
        this.fill(nbits <= 0 ? null : new byte[GenmodelBitSet.bytes(nbits)], 0, nbits, bitoff);
    }

    public int getNBits() {
        return this._nbits;
    }

    public void fill(byte[] v2, int byteoff, int nbits, int bitoff) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        if (byteoff < 0) {
            throw new IndexOutOfBoundsException("byteoff < 0: " + byteoff);
        }
        if (bitoff < 0) {
            throw new IndexOutOfBoundsException("bitoff < 0: " + bitoff);
        }
        assert (v2 == null || byteoff + GenmodelBitSet.bytes(nbits) <= v2.length);
        this._val = v2;
        this._nbits = nbits;
        this._bitoff = bitoff;
        this._byteoff = byteoff;
    }

    public boolean isInRange(int b2) {
        return (b2 -= this._bitoff) >= 0 && b2 < this._nbits;
    }

    public boolean contains(int idx) {
        assert ((idx -= this._bitoff) >= 0 && idx < this._nbits) : "Must have " + this._bitoff + " <= idx <= " + (this._bitoff + this._nbits - 1) + ": " + idx;
        return (this._val[this._byteoff + (idx >> 3)] & 1 << (idx & 7)) != 0;
    }

    public void fill2(byte[] bits, ByteBufferWrapper ab) {
        this.fill(bits, ab.position(), 32, 0);
        ab.skip(4);
    }

    public void fill3(byte[] bits, ByteBufferWrapper ab) {
        char bitoff = ab.get2();
        int nbits = ab.get4();
        this.fill(bits, ab.position(), nbits, bitoff);
        ab.skip(GenmodelBitSet.bytes(nbits));
    }

    private static int bytes(int nbits) {
        return (nbits - 1 >> 3) + 1;
    }

    public boolean contains0(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("idx < 0: " + idx);
        }
        return (idx -= this._bitoff) >= 0 && idx < this._nbits && (this._val[this._byteoff + (idx >> 3)] & 1 << (idx & 7)) != 0;
    }

    public void fill3_1(byte[] bits, ByteBufferWrapper ab) {
        char bitoff = ab.get2();
        char nbytes = ab.get2();
        this.fill_1(bits, ab.position(), nbytes << 3, bitoff);
        ab.skip(nbytes);
    }

    public void fill_1(byte[] v2, int byteoff, int nbits, int bitoff) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        if (byteoff < 0) {
            throw new IndexOutOfBoundsException("byteoff < 0: " + byteoff);
        }
        if (bitoff < 0) {
            throw new IndexOutOfBoundsException("bitoff < 0: " + bitoff);
        }
        assert (v2 == null || byteoff + (nbits - 1 >> 3) + 1 <= v2.length);
        this._val = v2;
        this._nbits = nbits;
        this._bitoff = bitoff;
        this._byteoff = byteoff;
    }
}

