/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.isofor;

import hex.genmodel.algos.tree.SharedTreeMojoModel;

public final class IsolationForestMojoModel
extends SharedTreeMojoModel {
    int _min_path_length;
    int _max_path_length;
    boolean _outputAnomalyFlag;

    public IsolationForestMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        return this.score0(row, 0.0, preds);
    }

    @Override
    public double[] score0(double[] row, double offset, double[] preds) {
        super.scoreAllTrees(row, preds);
        return this.unifyPreds(row, offset, preds);
    }

    @Override
    public double[] unifyPreds(double[] row, double offset, double[] preds) {
        double score;
        double mpLength = 0.0;
        if (this._ntree_groups >= 1 && preds.length > 1) {
            mpLength = preds[0] / (double)this._ntree_groups;
        }
        double d2 = score = this._max_path_length > this._min_path_length ? ((double)this._max_path_length - preds[0]) / (double)(this._max_path_length - this._min_path_length) : 1.0;
        if (this._outputAnomalyFlag) {
            preds[0] = score > this._defaultThreshold ? 1.0 : 0.0;
            preds[1] = score;
            preds[2] = mpLength;
        } else {
            preds[0] = score;
            preds[1] = mpLength;
        }
        return preds;
    }

    @Override
    public double getInitF() {
        return 0.0;
    }

    @Override
    public int getPredsSize() {
        return this._outputAnomalyFlag ? 3 : 2;
    }

    @Override
    public String[] getOutputNames() {
        if (this._outputAnomalyFlag) {
            return new String[]{"predict", "score", "mean_length"};
        }
        return new String[]{"predict", "mean_length"};
    }
}

