/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.util;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class ModelReader
implements Closeable {
    private final InputStream stream;
    private byte[] buffer;

    @Deprecated
    public ModelReader(String filename) throws IOException {
        this(new FileInputStream(filename));
    }

    public ModelReader(InputStream in) {
        this.stream = in;
    }

    private int fillBuffer(int numBytes) throws IOException {
        int numBytesRead;
        int count;
        if (this.buffer == null || this.buffer.length < numBytes) {
            this.buffer = new byte[numBytes];
        }
        for (numBytesRead = 0; numBytesRead < numBytes; numBytesRead += count) {
            count = this.stream.read(this.buffer, numBytesRead, numBytes - numBytesRead);
            if (count >= 0) continue;
            return numBytesRead;
        }
        return numBytesRead;
    }

    public int readByteAsInt() throws IOException {
        return this.stream.read();
    }

    public byte[] readByteArray(int numBytes) throws IOException {
        int numBytesRead = this.fillBuffer(numBytes);
        if (numBytesRead < numBytes) {
            throw new EOFException(String.format("Cannot read byte array (shortage): expected = %d, actual = %d", numBytes, numBytesRead));
        }
        byte[] result = new byte[numBytes];
        System.arraycopy(this.buffer, 0, result, 0, numBytes);
        return result;
    }

    public int readInt() throws IOException {
        return this.readInt(ByteOrder.LITTLE_ENDIAN);
    }

    public int readIntBE() throws IOException {
        return this.readInt(ByteOrder.BIG_ENDIAN);
    }

    private int readInt(ByteOrder byteOrder) throws IOException {
        int numBytesRead = this.fillBuffer(4);
        if (numBytesRead < 4) {
            throw new EOFException("Cannot read int value (shortage): " + numBytesRead);
        }
        return ByteBuffer.wrap(this.buffer).order(byteOrder).getInt();
    }

    public int[] readIntArray(int numValues) throws IOException {
        int numBytesRead = this.fillBuffer(numValues * 4);
        if (numBytesRead < numValues * 4) {
            throw new EOFException(String.format("Cannot read int array (shortage): expected = %d, actual = %d", numValues * 4, numBytesRead));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN);
        int[] result = new int[numValues];
        for (int i2 = 0; i2 < numValues; ++i2) {
            result[i2] = byteBuffer.getInt();
        }
        return result;
    }

    public int readUnsignedInt() throws IOException {
        int result = this.readInt();
        if (result < 0) {
            throw new IOException("Cannot read unsigned int (overflow): " + result);
        }
        return result;
    }

    public long readLong() throws IOException {
        int numBytesRead = this.fillBuffer(8);
        if (numBytesRead < 8) {
            throw new IOException("Cannot read long value (shortage): " + numBytesRead);
        }
        return ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public float asFloat(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public int asUnsignedInt(byte[] bytes) throws IOException {
        int result = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        if (result < 0) {
            throw new IOException("Cannot treat as unsigned int (overflow): " + result);
        }
        return result;
    }

    public float readFloat() throws IOException {
        int numBytesRead = this.fillBuffer(4);
        if (numBytesRead < 4) {
            throw new IOException("Cannot read float value (shortage): " + numBytesRead);
        }
        return ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public float[] readFloatArray(int numValues) throws IOException {
        int numBytesRead = this.fillBuffer(numValues * 4);
        if (numBytesRead < numValues * 4) {
            throw new EOFException(String.format("Cannot read float array (shortage): expected = %d, actual = %d", numValues * 4, numBytesRead));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN);
        float[] result = new float[numValues];
        for (int i2 = 0; i2 < numValues; ++i2) {
            result[i2] = byteBuffer.getFloat();
        }
        return result;
    }

    public double[] readDoubleArrayBE(int numValues) throws IOException {
        int numBytesRead = this.fillBuffer(numValues * 8);
        if (numBytesRead < numValues * 8) {
            throw new EOFException(String.format("Cannot read double array (shortage): expected = %d, actual = %d", numValues * 8, numBytesRead));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer).order(ByteOrder.BIG_ENDIAN);
        double[] result = new double[numValues];
        for (int i2 = 0; i2 < numValues; ++i2) {
            result[i2] = byteBuffer.getDouble();
        }
        return result;
    }

    public void skip(long numBytes) throws IOException {
        long numBytesRead = this.stream.skip(numBytes);
        if (numBytesRead < numBytes) {
            throw new IOException("Cannot skip bytes: " + numBytesRead);
        }
    }

    public String readString() throws IOException {
        long length = this.readLong();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Too long string: " + length);
        }
        return this.readString((int)length);
    }

    public String readString(int numBytes) throws IOException {
        int numBytesRead = this.fillBuffer(numBytes);
        if (numBytesRead < numBytes) {
            throw new IOException(String.format("Cannot read string(%d) (shortage): %d", numBytes, numBytesRead));
        }
        return new String(this.buffer, 0, numBytes, Charset.forName("UTF-8"));
    }

    public String readUTF() throws IOException {
        int utflen = this.readByteAsInt();
        utflen = (short)(utflen << 8 | this.readByteAsInt());
        return this.readUTF(utflen);
    }

    public String readUTF(int utflen) throws IOException {
        int c2;
        int count;
        int numBytesRead = this.fillBuffer(utflen);
        if (numBytesRead < utflen) {
            throw new EOFException(String.format("Cannot read UTF string bytes: expected = %d, actual = %d", utflen, numBytesRead));
        }
        char[] chararr = new char[utflen];
        int chararr_count = 0;
        for (count = 0; count < utflen && (c2 = this.buffer[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c2;
        }
        block6: while (count < utflen) {
            c2 = this.buffer[count] & 0xFF;
            switch (c2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c2;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = this.buffer[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c2 & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = this.buffer[count - 2];
                    byte char3 = this.buffer[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c2 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

