/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.AbstractConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.NegativeSubsumer;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ModifiableLinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.collections.HashSetMultimap;
import org.semanticweb.elk.util.collections.Multimap;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ModifiableLinkImpl;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;

public class Propagation
extends AbstractConclusion {
    private static final Logger LOGGER_ = Logger.getLogger(Propagation.class);
    private final IndexedPropertyChain relation_;
    private final IndexedClassExpression carry_;

    public Propagation(IndexedPropertyChain relation, IndexedClassExpression carry) {
        this.relation_ = relation;
        this.carry_ = carry;
    }

    public String toString() {
        return "Propagation " + this.relation_ + "->" + this.carry_;
    }

    public void apply(BasicSaturationStateWriter writer, Context context) {
        Multimap<IndexedPropertyChain, Context> backLinks = context.getBackwardLinksByObjectProperty();
        Collection targets = backLinks.get((Object)this.relation_);
        for (Context target : targets) {
            writer.produce(target, new NegativeSubsumer(this.carry_));
        }
    }

    @Override
    public <R> R accept(ConclusionVisitor<R> visitor, Context context) {
        return visitor.visit(this, context);
    }

    @Override
    public Context getSourceContext(Context contextWhereStored) {
        return null;
    }

    public boolean addToContextBackwardLinkRule(Context context) {
        return ((ThisBackwardLinkRule)context.getBackwardLinkRuleChain().getCreate(ThisBackwardLinkRule.MATCHER_, ThisBackwardLinkRule.FACTORY_)).addPropagationByObjectProperty(this.relation_, this.carry_);
    }

    public boolean removeFromContextBackwardLinkRule(Context context) {
        ThisBackwardLinkRule rule = (ThisBackwardLinkRule)context.getBackwardLinkRuleChain().find(ThisBackwardLinkRule.MATCHER_);
        return rule != null ? rule.removePropagationByObjectProperty(this.relation_, this.carry_) : false;
    }

    public boolean containsBackwardLinkRule(Context context) {
        ThisBackwardLinkRule rule = (ThisBackwardLinkRule)context.getBackwardLinkRuleChain().find(ThisBackwardLinkRule.MATCHER_);
        return rule != null ? rule.containsPropagationByObjectProperty(this.relation_, this.carry_) : false;
    }

    public static class ThisBackwardLinkRule
    extends ModifiableLinkImpl<ModifiableLinkRule<BackwardLink>>
    implements ModifiableLinkRule<BackwardLink> {
        private static final String NAME = "Propagation Over BackwardLink";
        private final Multimap<IndexedPropertyChain, IndexedClassExpression> propagationsByObjectProperty_ = new HashSetMultimap(1);
        private static Matcher<ModifiableLinkRule<BackwardLink>, ThisBackwardLinkRule> MATCHER_ = new SimpleTypeBasedMatcher(ThisBackwardLinkRule.class);
        private static ReferenceFactory<ModifiableLinkRule<BackwardLink>, ThisBackwardLinkRule> FACTORY_ = new ReferenceFactory<ModifiableLinkRule<BackwardLink>, ThisBackwardLinkRule>(){

            public ThisBackwardLinkRule create(ModifiableLinkRule<BackwardLink> tail) {
                return new ThisBackwardLinkRule(tail);
            }
        };

        ThisBackwardLinkRule(ModifiableLinkRule<BackwardLink> tail) {
            super(tail);
        }

        public Multimap<IndexedPropertyChain, IndexedClassExpression> getPropagationsByObjectProperty() {
            return this.propagationsByObjectProperty_;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public void apply(BasicSaturationStateWriter writer, BackwardLink link) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Applying Propagation Over BackwardLink to " + link));
            }
            for (IndexedClassExpression carry : this.propagationsByObjectProperty_.get((Object)link.getRelation())) {
                writer.produce(link.getSource(), new NegativeSubsumer(carry));
            }
        }

        @Override
        public void accept(RuleApplicationVisitor visitor, BasicSaturationStateWriter writer, BackwardLink backwardLink) {
            visitor.visit(this, writer, backwardLink);
        }

        private boolean addPropagationByObjectProperty(IndexedPropertyChain propRelation, IndexedClassExpression conclusion) {
            return this.propagationsByObjectProperty_.add((Object)propRelation, (Object)conclusion);
        }

        private boolean removePropagationByObjectProperty(IndexedPropertyChain propRelation, IndexedClassExpression conclusion) {
            return this.propagationsByObjectProperty_.remove((Object)propRelation, (Object)conclusion);
        }

        private boolean containsPropagationByObjectProperty(IndexedPropertyChain propRelation, IndexedClassExpression conclusion) {
            return this.propagationsByObjectProperty_.contains((Object)propRelation, (Object)conclusion);
        }
    }
}

