/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions;

import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.Conclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.Contradiction;
import org.semanticweb.elk.reasoner.saturation.conclusions.DisjointnessAxiom;
import org.semanticweb.elk.reasoner.saturation.conclusions.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.NegativeSubsumer;
import org.semanticweb.elk.reasoner.saturation.conclusions.PositiveSubsumer;
import org.semanticweb.elk.reasoner.saturation.conclusions.Propagation;
import org.semanticweb.elk.reasoner.saturation.context.Context;

public class ConclusionSourceUnsaturationVisitor
implements ConclusionVisitor<Boolean> {
    private final BasicSaturationStateWriter writer_;

    public ConclusionSourceUnsaturationVisitor(BasicSaturationStateWriter writer) {
        this.writer_ = writer;
    }

    Boolean mark(Conclusion conclusion, Context context) {
        Context sourceContext = conclusion.getSourceContext(context);
        return sourceContext != null ? this.writer_.markAsNotSaturated(sourceContext) : false;
    }

    @Override
    public Boolean visit(NegativeSubsumer negSCE, Context context) {
        if (negSCE.getExpression().occurs()) {
            return this.mark(negSCE, context);
        }
        return false;
    }

    @Override
    public Boolean visit(PositiveSubsumer posSCE, Context context) {
        if (posSCE.getExpression().occurs()) {
            return this.mark(posSCE, context);
        }
        return false;
    }

    @Override
    public Boolean visit(BackwardLink link, Context context) {
        return this.mark(link, context);
    }

    @Override
    public Boolean visit(ForwardLink link, Context context) {
        return this.mark(link, context);
    }

    @Override
    public Boolean visit(Contradiction bot, Context context) {
        return this.mark(bot, context);
    }

    @Override
    public Boolean visit(Propagation propagation, Context context) {
        return this.mark(propagation, context);
    }

    @Override
    public Boolean visit(DisjointnessAxiom disjointnessAxiom, Context context) {
        return this.mark(disjointnessAxiom, context);
    }
}

