/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap_lite.io;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import uk.ac.ox.krr.logmap_lite.io.OutputMappingsFormat;

public class OAEIAlignmentOutput
extends OutputMappingsFormat {
    File alignmentFile;
    FileWriter fw;

    public OAEIAlignmentOutput(String name, String oiri1, String oiri2) throws Exception {
        super(name);
        this.setOutput();
        this.printHeader(oiri1, oiri2);
    }

    @Override
    protected void setOutput() throws Exception {
        this.alignmentFile = File.createTempFile(this.output_file, ".rdf");
        this.fw = new FileWriter(this.alignmentFile);
    }

    private void printHeader(String oiri1, String oiri2) throws Exception {
        this.fw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        this.fw.write("<rdf:RDF xmlns=\"http://knowledgeweb.semanticweb.org/heterogeneity/alignment\"\n");
        this.fw.write("\txmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n");
        this.fw.write("\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\">\n");
        this.fw.write("\n");
        this.fw.write("<Alignment>\n");
        this.fw.write("<xml>yes</xml>\n");
        this.fw.write("<level>0</level>\n");
        this.fw.write("<type>??</type>\n");
        this.fw.write("<onto1>" + oiri1 + "</onto1>\n");
        this.fw.write("<onto2>" + oiri2 + "</onto2>\n");
        this.fw.write("<uri1>" + oiri1 + "</uri1>\n");
        this.fw.write("<uri2>" + oiri2 + "</uri2>\n");
    }

    private void printTail() throws Exception {
        this.fw.write("</Alignment>\n");
        this.fw.write("</rdf:RDF>\n");
    }

    @Override
    public void addClassMapping2Output(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        this.addMapping2Output(iri_str1, iri_str2, dir_mapping, conf);
    }

    @Override
    public void addDataPropMapping2Output(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        this.addMapping2Output(iri_str1, iri_str2, dir_mapping, conf);
    }

    @Override
    public void addObjPropMapping2Output(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        this.addMapping2Output(iri_str1, iri_str2, dir_mapping, conf);
    }

    @Override
    public void addInstanceMapping2Output(String iri_str1, String iri_str2, double conf) throws Exception {
        this.addMapping2Output(iri_str1, iri_str2, -2, conf);
    }

    private void addMapping2Output(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        this.fw.write("<map>\n");
        this.fw.write("\t<Cell>\n");
        this.fw.write("\t\t<entity1 rdf:resource=\"" + iri_str1 + "\"/>\n");
        this.fw.write("\t\t<entity2 rdf:resource=\"" + iri_str2 + "\"/>\n");
        this.fw.write("\t\t<measure rdf:datatype=\"xsd:float\">" + this.getRoundConfidence(conf) + "</measure>\n");
        if (dir_mapping == -2) {
            this.fw.write("\t\t<relation>=</relation>\n");
        } else if (dir_mapping == 0) {
            this.fw.write("\t\t<relation>&lt;</relation>\n");
        } else {
            this.fw.write("\t\t<relation>&gt;</relation>\n");
        }
        this.fw.write("\t</Cell>\n");
        this.fw.write("</map>\n");
    }

    @Override
    public void saveOutputFile() throws Exception {
        this.printTail();
        this.fw.flush();
        this.fw.close();
    }

    public URL returnAlignmentFile() throws Exception {
        return this.alignmentFile.toURI().toURL();
    }
}

