/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.repair.hornSAT;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.repair.hornSAT.HornClause;
import uk.ac.ox.krr.logmap2.repair.hornSAT.Link;

public class DowlingGallierHornSAT {
    private Map<Integer, HornClause> clauses = new HashMap<Integer, HornClause>();
    private Set<HornClause> conflictive_disjointness = new HashSet<HornClause>();
    private Set<HornClause> conflictive_mappings = new HashSet<HornClause>();
    private Set<HornClause> mappings_involved_in_error = new HashSet<HornClause>();
    private Set<HornClause> disjointness_involved_in_error = new HashSet<HornClause>();
    private Map<Integer, Set<Link>> FS = new HashMap<Integer, Set<Link>>();
    private Map<Integer, Set<Link>> additionalIgnoreFS = new HashMap<Integer, Set<Link>>();
    private Map<Integer, Set<Link>> generalIgnoreFS = new HashMap<Integer, Set<Link>>();
    private Vector<Integer> N = new Vector();
    private Vector<Integer> N_copy;
    private Stack<Integer> Q = new Stack();
    private Set<Integer> R = new HashSet<Integer>();
    private int TRUE = -1;
    private int FALSE = -2;
    private int clause_num = 0;
    private int last_onto1_id;

    public DowlingGallierHornSAT(Set<Integer> fromTrue, Map<Integer, Set<Integer>> taxonomyReversed, Map<Integer, Set<Integer>> disjointness) {
        this.FS.put(this.TRUE, new HashSet());
        this.addTrueClauses(fromTrue, 0);
        this.addTaxClauses(taxonomyReversed, 0);
        this.addDisjClauses(disjointness, 0);
        this.Q.addAll(fromTrue);
        this.R.addAll(fromTrue);
        LogOutput.print(this.FS.toString());
        LogOutput.print(this.N.toString());
        LogOutput.print(this.Q.toString());
    }

    public DowlingGallierHornSAT(Map<Integer, Set<Integer>> taxonomyReversed1, Map<Integer, Set<Integer>> taxonomyReversed2, Map<Integer, Set<Integer>> disjointness1, Map<Integer, Set<Integer>> disjointness2, Map<Set<Integer>, Integer> generalHornAxioms1, Map<Set<Integer>, Integer> generalHornAxioms2, Map<Integer, Set<Integer>> fixedmappings, Map<Integer, Set<Integer>> mappings, Set<HornClause> mappings2ignore) {
        this.addTaxClauses(taxonomyReversed1, 1);
        this.addTaxClauses(taxonomyReversed2, 1);
        this.addDisjClauses(disjointness1, 1);
        this.addDisjClauses(disjointness2, 1);
        this.addGeneralHornAxioms(generalHornAxioms1, 1);
        this.addGeneralHornAxioms(generalHornAxioms2, 1);
        this.addMappingClauses1N(mappings, mappings2ignore, false);
        this.addMappingClauses1N(fixedmappings, mappings2ignore, true);
        this.N.add(0);
    }

    public DowlingGallierHornSAT(Map<Integer, Set<Integer>> taxonomy, Map<Integer, Set<Integer>> equivalences, Map<Integer, Set<Integer>> disjointness, Map<Set<Integer>, Integer> generalHornAxioms, boolean addClassTypes, Map<Integer, Set<Integer>> indivClassTypes, Map<Integer, Set<Integer>> fixedmappings, Map<Integer, Set<Integer>> mappings, Set<HornClause> mappings2ignore) {
        this.addTaxClauses(taxonomy, 1);
        if (addClassTypes) {
            this.addIndivClassTypeClauses(indivClassTypes, 1);
        }
        this.addEquivalentClauses(equivalences, 1);
        this.addDisjClauses(disjointness, 1);
        this.addGeneralHornAxioms(generalHornAxioms, 1);
        this.addMappingClauses1N(mappings, mappings2ignore, false);
        this.addMappingClauses1N(fixedmappings, mappings2ignore, true);
        this.N.add(0);
    }

    public boolean isSatisfiable() {
        boolean satisfiable = this.VisitGraph();
        if (!satisfiable) {
            LogOutput.print("These clauses are the cause of error: ");
            LogOutput.print(this.mappings_involved_in_error.toString());
            LogOutput.print(this.disjointness_involved_in_error.toString());
        }
        return satisfiable;
    }

    public boolean isSatisfiable(int entity) {
        return this.isSatisfiable(entity, Collections.EMPTY_MAP);
    }

    public boolean isSatisfiable(int entity, Map<Integer, Set<Link>> ignoreLinks) {
        this.mappings_involved_in_error.clear();
        this.disjointness_involved_in_error.clear();
        this.N_copy = new Vector<Integer>(this.N);
        this.Q.clear();
        this.R.clear();
        this.R.add(entity);
        this.Q.add(entity);
        Link link = new Link(this.clause_num, entity);
        this.FS.put(this.TRUE, new HashSet());
        this.FS.get(this.TRUE).add(link);
        this.additionalIgnoreFS = ignoreLinks;
        boolean satisfiable = this.VisitGraph();
        return satisfiable;
    }

    public void addGeneralLink2Ignore(int origin, int label, int target) {
        if (!this.generalIgnoreFS.containsKey(origin)) {
            this.generalIgnoreFS.put(origin, new HashSet());
        }
        this.generalIgnoreFS.get(origin).add(new Link(label, target));
    }

    public Map<Integer, Set<Link>> getGeneralLink2Ignore() {
        return this.generalIgnoreFS;
    }

    public Set<HornClause> getMappingsInvolvedInError() {
        return this.mappings_involved_in_error;
    }

    public void setConflictiveMappingsAsInvolvedMappings() {
        this.conflictive_mappings.clear();
        this.conflictive_mappings.addAll(this.mappings_involved_in_error);
    }

    public void incrementConflictiveMappingsWithNewInvolvedMappings() {
        this.conflictive_mappings.addAll(this.mappings_involved_in_error);
    }

    public void setConflictiveDisjointnessAsInvolvedDisjointness() {
        this.conflictive_disjointness.clear();
        this.conflictive_disjointness.addAll(this.disjointness_involved_in_error);
    }

    public Set<HornClause> getConflictiveMappings() {
        return this.conflictive_mappings;
    }

    public Set<HornClause> getConflictiveDisjointness() {
        return this.conflictive_disjointness;
    }

    public void addConflictiveMapping(HornClause mapping) {
        this.conflictive_mappings.add(mapping);
    }

    public void clearConflictiveMappings() {
        this.conflictive_mappings.clear();
    }

    public Set<HornClause> getDisjointnessInvolvedInError() {
        return this.disjointness_involved_in_error;
    }

    private void addTrueClauses(Set<Integer> fromTrue, int shift) {
        for (int init : fromTrue) {
            this.FS.get(this.TRUE).add(new Link(this.clause_num, init + shift));
            this.N.add(0);
            ++this.clause_num;
        }
    }

    private void addTaxClauses(Map<Integer, Set<Integer>> taxonomy, int origin) {
        for (int parent : taxonomy.keySet()) {
            for (int child : taxonomy.get(parent)) {
                this.clauses.put(this.clause_num, new HornClause(child, parent, this.clause_num, origin, 0));
                if (!this.FS.containsKey(child)) {
                    this.FS.put(child, new HashSet());
                }
                this.FS.get(child).add(new Link(this.clause_num, parent));
                this.N.add(1);
                ++this.clause_num;
            }
        }
        LogOutput.print("TAX clause num: " + this.clause_num);
    }

    private void addIndivClassTypeClauses(Map<Integer, Set<Integer>> classTypes, int origin) {
        for (int indiv_child : classTypes.keySet()) {
            for (int cls_parent : classTypes.get(indiv_child)) {
                this.clauses.put(this.clause_num, new HornClause(indiv_child, cls_parent, this.clause_num, origin, 0));
                if (!this.FS.containsKey(indiv_child)) {
                    this.FS.put(indiv_child, new HashSet());
                }
                this.FS.get(indiv_child).add(new Link(this.clause_num, cls_parent));
                this.N.add(1);
                ++this.clause_num;
            }
        }
        LogOutput.print("INDIV CLASS TYPES clause num: " + this.clause_num);
    }

    private void addEquivalentClauses(Map<Integer, Set<Integer>> equivalents, int origin_clause) {
        for (int origin : equivalents.keySet()) {
            for (int target : equivalents.get(origin)) {
                this.clauses.put(this.clause_num, new HornClause(origin, target, this.clause_num, origin_clause, 0));
                if (!this.FS.containsKey(origin)) {
                    this.FS.put(origin, new HashSet());
                }
                this.FS.get(origin).add(new Link(this.clause_num, target));
                this.N.add(1);
                ++this.clause_num;
            }
        }
        LogOutput.print("Equiv clause num: " + this.clause_num);
    }

    private void addDisjClauses(Map<Integer, Set<Integer>> disjointness, int origin) {
        HashSet<Pair> disj_clauses = new HashSet<Pair>();
        for (int ent : disjointness.keySet()) {
            if (!this.FS.containsKey(ent)) {
                this.FS.put(ent, new HashSet());
            }
            for (int disj : disjointness.get(ent)) {
                Pair pair1 = new Pair(ent, disj);
                if (disj_clauses.contains(pair1)) continue;
                disj_clauses.add(pair1);
                this.clauses.put(this.clause_num, new HornClause(ent, disj, this.FALSE, this.clause_num, origin, 0));
                this.FS.get(ent).add(new Link(this.clause_num, this.FALSE));
                if (!this.FS.containsKey(disj)) {
                    this.FS.put(disj, new HashSet());
                }
                this.FS.get(disj).add(new Link(this.clause_num, this.FALSE));
                this.N.add(2);
                ++this.clause_num;
            }
        }
        disj_clauses.clear();
        LogOutput.print("D&G DISJ clause num: " + this.clause_num);
    }

    private void addGeneralHornAxioms(Map<Set<Integer>, Integer> generalHornAxioms, int origin) {
        for (Set<Integer> body : generalHornAxioms.keySet()) {
            int head = generalHornAxioms.get(body);
            for (Integer ent : body) {
                if (!this.FS.containsKey(ent)) {
                    this.FS.put(ent, new HashSet());
                }
                this.clauses.put(this.clause_num, new HornClause(body, head, this.clause_num, origin, 0));
                this.FS.get(ent).add(new Link(this.clause_num, head));
            }
            this.N.add(body.size());
            ++this.clause_num;
        }
        LogOutput.print("D&G general axioms clause num: " + this.clause_num);
    }

    private void addMappingClauses1N(Map<Integer, Set<Integer>> mappings, Set<HornClause> mappings2ignore, boolean fixedMap) {
        int type_mapping = fixedMap ? 3 : 0;
        int num = 0;
        for (int origin : mappings.keySet()) {
            for (int target : mappings.get(origin)) {
                HornClause clause;
                int clause_type;
                if (origin < target) {
                    clause_type = 0;
                    clause = new HornClause(origin, target, this.clause_num, type_mapping, clause_type);
                } else {
                    clause_type = -1;
                    clause = new HornClause(target, origin, this.clause_num, type_mapping, clause_type);
                }
                if (mappings2ignore.contains(clause)) continue;
                ++num;
                if (!this.FS.containsKey(origin)) {
                    this.FS.put(origin, new HashSet());
                }
                this.clauses.put(this.clause_num, clause);
                this.FS.get(origin).add(new Link(this.clause_num, target));
                this.N.add(1);
                ++this.clause_num;
            }
        }
        LogOutput.print("D&G mappings clause num: " + this.clause_num);
        LogOutput.print("D&G mapping links: " + num + "  " + mappings2ignore.size());
    }

    private boolean VisitGraph() {
        boolean satisfiable = true;
        while (!this.Q.empty()) {
            int P = this.Q.pop();
            if (!this.FS.containsKey(P)) continue;
            for (Link link : this.FS.get(P)) {
                if (this.generalIgnoreFS.containsKey(P) && this.generalIgnoreFS.get(P).contains(link) || this.additionalIgnoreFS.containsKey(P) && this.additionalIgnoreFS.get(P).contains(link)) continue;
                this.N_copy.set(link.getLabelLink(), this.N_copy.get(link.getLabelLink()) - 1);
                if (this.N_copy.get(link.getLabelLink()) != 0) continue;
                if (link.getTargetLink() == this.FALSE) {
                    this.disjointness_involved_in_error.add(this.clauses.get(link.getLabelLink()));
                    satisfiable = false;
                    continue;
                }
                if (this.R.contains(link.getTargetLink())) continue;
                this.Q.push(link.getTargetLink());
                this.R.add(link.getTargetLink());
                if (this.clauses.get(link.getLabelLink()).getOrigin() != 0) continue;
                this.mappings_involved_in_error.add(this.clauses.get(link.getLabelLink()));
            }
        }
        return satisfiable;
    }

    public static void main(String[] args) {
        HashSet fromTrue1 = new HashSet();
        HashMap<Integer, Set<Integer>> tax1 = new HashMap<Integer, Set<Integer>>();
        HashMap<Integer, Set<Integer>> disjointness1 = new HashMap<Integer, Set<Integer>>();
        HashMap<Integer, Set<Integer>> types = new HashMap<Integer, Set<Integer>>();
        HashSet fromTrue2 = new HashSet();
        HashMap<Integer, Set<Integer>> mappings = new HashMap<Integer, Set<Integer>>();
        disjointness1.put(2, new HashSet());
        ((Set)disjointness1.get(2)).add(3);
        disjointness1.put(7, new HashSet());
        ((Set)disjointness1.get(7)).add(10);
        tax1.put(1, new HashSet());
        tax1.put(2, new HashSet());
        tax1.put(3, new HashSet());
        tax1.put(4, new HashSet());
        ((Set)tax1.get(1)).add(2);
        ((Set)tax1.get(1)).add(3);
        ((Set)tax1.get(3)).add(4);
        ((Set)tax1.get(4)).add(5);
        tax1.put(6, new HashSet());
        tax1.put(7, new HashSet());
        ((Set)tax1.get(6)).add(7);
        ((Set)tax1.get(6)).add(10);
        ((Set)tax1.get(7)).add(8);
        ((Set)tax1.get(7)).add(9);
        mappings.put(3, new HashSet());
        ((Set)mappings.get(3)).add(7);
        mappings.put(4, new HashSet());
        ((Set)mappings.get(4)).add(10);
        mappings.put(7, new HashSet());
        ((Set)mappings.get(7)).add(3);
        mappings.put(10, new HashSet());
        ((Set)mappings.get(10)).add(4);
        HashMap<Integer, Set<Link>> ignoreFS = new HashMap<Integer, Set<Link>>();
        ignoreFS.put(4, new HashSet());
        ((Set)ignoreFS.get(4)).add(new Link(13, 10));
        ignoreFS.put(10, new HashSet());
        ((Set)ignoreFS.get(10)).add(new Link(15, 4));
        HashMap<Set<Integer>, Integer> generalHornAxioms1 = new HashMap<Set<Integer>, Integer>();
        HashMap<Integer, Set<Integer>> fixedmappings = new HashMap<Integer, Set<Integer>>();
        HashMap<Integer, Set<Integer>> equiv = new HashMap<Integer, Set<Integer>>();
        equiv.put(4, new HashSet());
        ((Set)equiv.get(4)).add(44);
        equiv.put(44, new HashSet());
        ((Set)equiv.get(44)).add(4);
        HashSet<HornClause> mappings2ignore = new HashSet<HornClause>();
        LogOutput.showOutpuLog(true);
        DowlingGallierHornSAT dgSat = new DowlingGallierHornSAT(tax1, equiv, disjointness1, generalHornAxioms1, false, types, fixedmappings, mappings, mappings2ignore);
        LogOutput.print("Is sat 1?: " + dgSat.isSatisfiable(1));
        LogOutput.print("Is sat 1i?: " + dgSat.isSatisfiable(1, ignoreFS));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 2?: " + dgSat.isSatisfiable(2));
        LogOutput.print("Is sat 2i?: " + dgSat.isSatisfiable(2, ignoreFS));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 3?: " + dgSat.isSatisfiable(3));
        LogOutput.print("Is sat 3i?: " + dgSat.isSatisfiable(3, ignoreFS));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 4?: " + dgSat.isSatisfiable(4));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 4i?: " + dgSat.isSatisfiable(4, ignoreFS));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 44?: " + dgSat.isSatisfiable(44));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 44i?: " + dgSat.isSatisfiable(44, ignoreFS));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 5?: " + dgSat.isSatisfiable(5));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 5i?: " + dgSat.isSatisfiable(5, ignoreFS));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 6?: " + dgSat.isSatisfiable(6));
        LogOutput.print("Is sat 6i?: " + dgSat.isSatisfiable(6, ignoreFS));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 7?: " + dgSat.isSatisfiable(7));
        LogOutput.print("Is sat 7i?: " + dgSat.isSatisfiable(7, ignoreFS));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 8?: " + dgSat.isSatisfiable(8));
        LogOutput.print("Is sat 8i?: " + dgSat.isSatisfiable(8, ignoreFS));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 9?: " + dgSat.isSatisfiable(9));
        LogOutput.print("Is sat 9i?: " + dgSat.isSatisfiable(9, ignoreFS));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 10?: " + dgSat.isSatisfiable(10));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
        LogOutput.print("Is sat 10i?: " + dgSat.isSatisfiable(10, ignoreFS));
        LogOutput.print(dgSat.getMappingsInvolvedInError().toString());
    }

    protected class Pair {
        int elem1;
        int elem2;

        public Pair(int el1, int el2) {
            this.elem1 = el1;
            this.elem2 = el2;
        }

        public int getElement1() {
            return this.elem1;
        }

        public int getElement2() {
            return this.elem2;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair i = (Pair)o;
            return this.equals(i);
        }

        public boolean equals(Pair i) {
            if (this.elem1 == i.getElement1() && this.elem2 == i.getElement2()) {
                return true;
            }
            return this.elem1 == i.getElement2() && this.elem2 == i.getElement1();
        }

        public int hashCode() {
            int code = 10;
            code = 40 * code * this.elem1 * this.elem2;
            return code;
        }

        public String toString() {
            return "<" + this.elem1 + ", " + this.elem2 + ">";
        }
    }
}

