/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.reasoning.explanation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLAxiom;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.utilities.PrecomputeIndexCombination;

public class PlanExtractor {
    private Map<Integer, OWLAxiom> ident2axiom;
    private Map<OWLAxiom, Set<Integer>> axioms2justifications;
    protected TreeSet<OWLAxiom> listOrderedAxioms;
    private PrecomputeIndexCombination precomputeIndexCombination = new PrecomputeIndexCombination();
    private List<Set<Integer>> setOfRepairPlans_int;
    private List<Set<OWLAxiom>> setOfRepairPlans_ax;
    private int num_justifications;
    private Set<Integer> justification_ids = new HashSet<Integer>();
    private Set<OWLAxiom> set_axioms = new HashSet<OWLAxiom>();

    public PlanExtractor(List<Set<OWLAxiom>> allJustifications) {
        this.ident2axiom = new HashMap<Integer, OWLAxiom>();
        this.axioms2justifications = new HashMap<OWLAxiom, Set<Integer>>();
        this.setOfRepairPlans_int = new ArrayList<Set<Integer>>();
        this.setOfRepairPlans_ax = new ArrayList<Set<OWLAxiom>>();
        this.precomputeIndexCombination.clearCombinations();
        this.precomputeIndexCombination.preComputeIdentifierCombination();
        this.num_justifications = allJustifications.size();
        int ident = 0;
        for (int index_just = 0; index_just < allJustifications.size(); ++index_just) {
            for (OWLAxiom ax : allJustifications.get(index_just)) {
                if (!this.axioms2justifications.containsKey(ax)) {
                    this.axioms2justifications.put(ax, new HashSet());
                }
                this.axioms2justifications.get(ax).add(index_just);
            }
        }
        this.orderAxiomsByImact();
        Iterator<OWLAxiom> it = this.listOrderedAxioms.iterator();
        while (it.hasNext()) {
            this.ident2axiom.put(ident, it.next());
            ++ident;
        }
    }

    public void extractPlans_old(int maxNumberOfPlans, int maxSizeOfPlans) {
        this.setOfRepairPlans_int.clear();
        this.setOfRepairPlans_ax.clear();
        LogOutput.printAlways("\tAxioms for plans: " + this.axioms2justifications.size());
        int maxSize4Plans = maxSizeOfPlans > this.axioms2justifications.size() ? this.axioms2justifications.size() : maxSizeOfPlans;
        for (int size_plan = 1; size_plan <= maxSize4Plans; ++size_plan) {
            Set<Set<Integer>> candidate_plans = this.precomputeIndexCombination.getIdentifierCombination(this.axioms2justifications.size(), size_plan);
            LogOutput.print("Candidates size: " + candidate_plans.size());
            if (candidate_plans.size() > 50000) {
                this.setOfRepairPlans_int.add(new HashSet<Integer>(this.precomputeIndexCombination.getMaxCombinationSet(this.axioms2justifications.size())));
                LogOutput.printAlways("Adding plan involving all axioms.");
                break;
            }
            for (Set<Integer> candidate_plan : candidate_plans) {
                if (this.isaGoodPlan(candidate_plan)) {
                    this.setOfRepairPlans_int.add(new HashSet<Integer>(candidate_plan));
                }
                if (this.setOfRepairPlans_int.size() < maxNumberOfPlans) continue;
                break;
            }
            if (this.setOfRepairPlans_int.size() >= maxNumberOfPlans || !this.setOfRepairPlans_int.isEmpty()) break;
            if (size_plan < maxSize4Plans || !this.setOfRepairPlans_int.isEmpty()) continue;
            System.out.println("Incrementing size candidate plan: " + size_plan + "  " + maxSize4Plans);
            ++maxSize4Plans;
        }
        for (int i = 0; i < this.setOfRepairPlans_int.size(); ++i) {
            this.setOfRepairPlans_ax.add(new HashSet<OWLAxiom>(this.getAxioms4PlanIde(i)));
        }
    }

    public void extractPlans() {
        this.setOfRepairPlans_int.clear();
        this.setOfRepairPlans_ax.clear();
        int maxSize4Plans = 20;
        int combineOver = this.axioms2justifications.size() > 20 ? this.getNumberOfAxiomsWithHighImpact(1) : this.axioms2justifications.size();
        LogOutput.printAlways("\tAxioms for plans: " + this.axioms2justifications.size());
        LogOutput.printAlways("\tAxioms for plans (reduced): " + combineOver);
        maxSize4Plans = combineOver > 150 ? 1 : (combineOver > 50 ? 2 : (combineOver > 20 ? 3 : (combineOver > 15 ? 4 : combineOver)));
        for (int size_plan = 1; size_plan <= maxSize4Plans; ++size_plan) {
            Set<Set<Integer>> candidate_plans = this.precomputeIndexCombination.getIdentifierCombination(combineOver, size_plan);
            LogOutput.print("Candidates size: " + candidate_plans.size());
            for (Set<Integer> candidate_plan : candidate_plans) {
                if (!this.isaGoodPlan(candidate_plan)) continue;
                this.setOfRepairPlans_int.add(new HashSet<Integer>(candidate_plan));
            }
            if (!this.setOfRepairPlans_int.isEmpty()) break;
        }
        if (this.setOfRepairPlans_int.isEmpty()) {
            this.setOfRepairPlans_ax.add(new HashSet<OWLAxiom>(this.createIncrementalPlan()));
        } else {
            for (int i = 0; i < this.setOfRepairPlans_int.size(); ++i) {
                this.setOfRepairPlans_ax.add(new HashSet<OWLAxiom>(this.getAxioms4PlanIde(i)));
            }
        }
    }

    private int getNumberOfAxiomsWithHighImpact(int min_impact) {
        int count = 0;
        for (OWLAxiom ax : this.axioms2justifications.keySet()) {
            if (this.getImpact(ax) <= 1) continue;
            ++count;
        }
        return count;
    }

    private boolean isaGoodPlan(Set<Integer> candidate_plan) {
        this.justification_ids.clear();
        for (Set<Integer> repair : this.setOfRepairPlans_int) {
            if (!candidate_plan.containsAll(repair)) continue;
            return false;
        }
        Iterator<Object> iterator = candidate_plan.iterator();
        while (iterator.hasNext()) {
            int ide_ax = (Integer)iterator.next();
            this.justification_ids.addAll((Collection<Integer>)this.axioms2justifications.get(this.ident2axiom.get(ide_ax)));
            if (this.justification_ids.size() != this.num_justifications) continue;
            return true;
        }
        return false;
    }

    private boolean isaGoodPlanAx(Set<OWLAxiom> candidate_plan) {
        this.justification_ids.clear();
        for (OWLAxiom ax : candidate_plan) {
            this.justification_ids.addAll((Collection<Integer>)this.axioms2justifications.get(ax));
            if (this.justification_ids.size() != this.num_justifications) continue;
            return true;
        }
        return false;
    }

    private List<Set<Integer>> getAllPlansInt() {
        return this.setOfRepairPlans_int;
    }

    public List<Set<OWLAxiom>> getAllPlansAx() {
        return this.setOfRepairPlans_ax;
    }

    private Set<OWLAxiom> createIncrementalPlan() {
        Iterator<OWLAxiom> it = this.listOrderedAxioms.iterator();
        HashSet<OWLAxiom> axioms_plan = new HashSet<OWLAxiom>();
        while (it.hasNext()) {
            axioms_plan.add(it.next());
            if (!this.isaGoodPlanAx(axioms_plan)) continue;
            break;
        }
        return axioms_plan;
    }

    private void orderAxiomsByImact() {
        this.listOrderedAxioms = new TreeSet<OWLAxiom>(new RepairMappingComparator());
        for (OWLAxiom ax : this.axioms2justifications.keySet()) {
            this.listOrderedAxioms.add(ax);
        }
    }

    private Set<OWLAxiom> getAxioms4PlanIde(int idePlan) {
        this.set_axioms.clear();
        for (int ide : this.setOfRepairPlans_int.get(idePlan)) {
            this.set_axioms.add(this.ident2axiom.get(ide));
        }
        return this.set_axioms;
    }

    private Set<OWLAxiom> getAxioms4PlanInt(Set<Integer> plan_int) {
        this.set_axioms.clear();
        for (int ide : plan_int) {
            this.set_axioms.add(this.ident2axiom.get(ide));
        }
        return this.set_axioms;
    }

    public int getImpact(OWLAxiom ax) {
        return this.axioms2justifications.get(ax).size();
    }

    private class RepairMappingComparator
    implements Comparator<OWLAxiom> {
        private RepairMappingComparator() {
        }

        @Override
        public int compare(OWLAxiom m1, OWLAxiom m2) {
            if (PlanExtractor.this.getImpact(m1) < PlanExtractor.this.getImpact(m2)) {
                return 1;
            }
            return -1;
        }
    }
}

