/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.bioportal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.ox.krr.logmap2.bioportal.BioPortalAccess;
import uk.ac.ox.krr.logmap2.bioportal.BioPortalMapping;
import uk.ac.ox.krr.logmap2.bioportal.BioPortalOntologyInfo;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.WriteFile;

public class RESTBioPortalAccess
implements BioPortalAccess {
    private final String REST_URL = "http://data.bioontology.org";
    private final String API_KEY_Ernesto = "5b0306a7-d116-4aea-9a65-24f281599114";
    private final String API_KEY_Xi = "5736787d-b5dc-4e79-b60c-ca5f1e08a52b";
    private final ObjectMapper mapper = new ObjectMapper();
    private final int LEARNING_CALLS = 20;
    private final int MAX_ONTOLOGIES = 10;
    private final int MAX_SIZE_ONTOLOGY = 20000;
    protected final String COLLECTION = "collection";
    protected final String PREFLABEL = "prefLabel";
    protected final String SYNONYM = "synonym";
    protected final String MAPPINGS = "mappings";
    protected final String LINKS = "links";
    protected final String SELF = "self";
    protected final String ONTOLOGY = "ontology";
    protected final String CLASSES = "classes";
    protected final String MAXDEPTH = "maxDepth";
    protected final String NEXTPAGE = "nextPage";
    protected final String ID = "@id";
    protected final String TYPE = "@type";
    protected final String PROCESS = "process";
    protected final String NAME = "name";
    protected final String PAGECOUNT = "pageCount";
    protected final String NOSOURCE = "nosource";
    protected final String owl_clas = "http://www.w3.org/2002/07/owl#Class";
    protected final String ONTOLOGY_LANGUAGE = "hasOntologyLanguage";
    private final String XREF = "xref";
    private final String LOOM = "loom";
    private final String CUI = "cui";
    private final String NULL = "null";
    private final String SAMEURIS = "same_uris";
    private final String SAMEURI = "same_uri";
    private final String MRMAP = "mrmap";
    private final String SOURCE = "source";
    private Set<String> usefulSources = new HashSet<String>();
    private int numQuestionsBioPortal_searchAll = 0;

    @Override
    public boolean isActive() {
        try {
            HttpURLConnection conn = this.getConnection("http://data.bioontology.org/ontologies/BFO/metrics");
            if (conn.getResponseCode() == 200) {
                return true;
            }
            System.out.println("BioPortal is not active: " + conn.getResponseCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Set<String> getSynonyms4Label(String label) {
        HashSet<String> synonyms = new HashSet<String>();
        try {
            JsonNode jsonConcepts = this.getConcepts4Label(label);
            for (JsonNode concept : jsonConcepts) {
                if (concept.has("prefLabel")) {
                    synonyms.add(concept.get("prefLabel").asText());
                }
                if (!concept.has("synonym")) continue;
                this.usefulSources.add(this.getOntologyAcronym(concept.get("links").get("ontology").asText()));
                for (JsonNode syn : concept.get("synonym")) {
                    synonyms.add(this.processSynonym(syn.asText()));
                }
            }
        }
        catch (JsonProcessingException e) {
            System.out.println("Error performing the BioPortal call for: " + label);
        }
        catch (IOException e) {
            System.out.println("Error performing the BioPortal call for: " + label);
        }
        return synonyms;
    }

    @Override
    public Set<String> getSuitableOntologiesForLabels(Set<String> labels) {
        return null;
    }

    public void getSynonymsAndMappings4Label(String label, Set<String> synonyms, Set<String> set) {
        try {
            JsonNode jsonConcepts = this.getConcepts4Label(label);
            for (JsonNode concept : jsonConcepts) {
                String idUrl = concept.findValue("@id").asText();
                set.add(idUrl);
            }
        }
        catch (IOException e) {
            System.out.println("Error performing the BioPortal call for: " + label);
        }
    }

    public void getSynonymsAndMappings4Label2(String label, Set<String> synonyms, Set<String> set) {
        HashSet<String> mappingURLSet = new HashSet<String>();
        try {
            JsonNode jsonConcepts = this.getConcepts4Label(label);
            for (JsonNode concept : jsonConcepts) {
                String idUrl = concept.findValue("@id").asText();
                set.add(idUrl);
                String url = concept.findValue("mappings").asText();
                mappingURLSet.add(url);
            }
        }
        catch (IOException e) {
            System.out.println("Error performing the BioPortal call for: " + label);
        }
        for (String url : mappingURLSet) {
            try {
                JsonNode jasonMapping = this.jsonToNode(this.getRequest(url));
                List selfURL = jasonMapping.findValuesAsText("@id");
                set.addAll(selfURL);
            }
            catch (IOException e) {
                System.out.println("Error performing the BioPortal call for: " + label);
            }
        }
    }

    public BioPortalOntologyInfo getMetricInfo4Onto(String ontoAcronym) {
        int classes = 0;
        int depth = 0;
        String language = "UNKNOWN";
        try {
            JsonNode ontologyNode = this.jsonToNode(this.getRequest("http://data.bioontology.org/ontologies/" + ontoAcronym + "/metrics"));
            if (ontologyNode.size() != 0) {
                JsonNode ontologyNode2;
                if (ontologyNode.has("classes")) {
                    classes = ontologyNode.get("classes").asInt();
                }
                if (ontologyNode.has("maxDepth")) {
                    depth = ontologyNode.get("maxDepth").asInt();
                }
                if ((ontologyNode2 = this.jsonToNode(this.getRequest("http://data.bioontology.org/ontologies/" + ontoAcronym + "/submissions"))).size() != 0 && ontologyNode2.isArray() && ontologyNode2.get(0).has("hasOntologyLanguage")) {
                    language = ontologyNode2.get(0).get("hasOntologyLanguage").asText();
                }
            }
            return new BioPortalOntologyInfo(ontoAcronym, classes, depth, language);
        }
        catch (IOException e) {
            LogOutput.printError("Error getting metrics from bioportal ontology.");
            return new BioPortalOntologyInfo(ontoAcronym);
        }
    }

    public Set<String> getUsefulSources() {
        return this.usefulSources;
    }

    public int getNumberOfBioPortalCalls() {
        return this.numQuestionsBioPortal_searchAll;
    }

    private String processLabel(String label) {
        label = label.replaceAll("_", " ");
        try {
            return URLEncoder.encode(label, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return label;
        }
    }

    private String processSynonym(String synonym) {
        if (synonym.contains("(")) {
            int idx = synonym.indexOf("(");
            synonym = idx != 0 ? synonym.substring(0, idx - 1) : synonym;
        }
        return synonym.toLowerCase();
    }

    public String getOntologyAcronym(String ontologyURI) {
        return ontologyURI.substring(ontologyURI.lastIndexOf("/") + 1);
    }

    public JsonNode getConcepts4Label(String label, boolean exact) throws JsonProcessingException, IOException {
        ++this.numQuestionsBioPortal_searchAll;
        String query = this.processLabel(label);
        return this.jsonToNode(this.getRequest("http://data.bioontology.org/search?q=" + query + this.getExactMatchParameter(exact))).get("collection");
    }

    public JsonNode getConcepts4Label(String label) throws JsonProcessingException, IOException {
        return this.getConcepts4Label(label, true);
    }

    public void getMappingsForGivenOntologies(String source_onto, Set<String> target_ontos, Set<BioPortalMapping> mapping_objects, WriteFile writer) {
        this.getMappingsForGivenOntologies(source_onto, target_ontos, mapping_objects, 1, 100, writer);
    }

    public void getMappingsForGivenOntologies(String source_onto, Set<String> target_ontos, Set<BioPortalMapping> mapping_objects, int starting_page, int pagesize, WriteFile writer) {
        try {
            String mapping_request = "http://data.bioontology.org/ontologies/" + source_onto + "/mappings?pagesize=" + pagesize + "&page=" + starting_page;
            JsonNode mappings_page = this.jsonToNode(this.getRequest(mapping_request));
            this.getMappingsFromPageForGivenOntologies(mapping_request, mappings_page, source_onto, target_ontos, mapping_objects, writer);
        }
        catch (JsonProcessingException e) {
            System.out.println("Error extracting the mappings for: " + source_onto + " and " + target_ontos);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Error extracting the mappings for: " + source_onto + " and " + target_ontos);
            e.printStackTrace();
        }
    }

    private void getMappingsFromPageForGivenOntologies(String original_request, JsonNode mappings_page, String source_onto, Set<String> target_ontos, Set<BioPortalMapping> mapping_objects, WriteFile writer) throws JsonProcessingException, IOException {
        int nextPageNumber = -1;
        if (!(mappings_page.get("nextPage").isNull() || (nextPageNumber = mappings_page.get("nextPage").asInt()) != 1 && nextPageNumber != 5 && nextPageNumber != 100 && nextPageNumber != 200 && nextPageNumber != 500 && nextPageNumber != 1000 && nextPageNumber != 1500 && nextPageNumber != 2000 && nextPageNumber != 2500 && nextPageNumber != 2770 && nextPageNumber != 3000 && nextPageNumber != 3500 && nextPageNumber != 4200 && nextPageNumber != 4000 && nextPageNumber != 4500 && nextPageNumber != 5000 && nextPageNumber != 5500 && nextPageNumber != 6000)) {
            System.out.println("Getting page: " + nextPageNumber);
        }
        JsonNode nextPage = mappings_page.get("links").get("nextPage");
        int numberOfPages = mappings_page.get("pageCount").asInt();
        JsonNode mappings = mappings_page.get("collection");
        int numErroneous_mappings = 0;
        for (JsonNode mapping : mappings) {
            try {
                String onto2acronym;
                String onto1acronym;
                String uri2;
                String uri1;
                Set<String> sources = this.getMappingSources(mapping);
                if (mapping.get("classes").isNull()) {
                    System.out.println("No CLASSES!!");
                }
                if (mapping.get("classes").isNull() || mapping.get("classes").size() != 2) {
                    ++numErroneous_mappings;
                    continue;
                }
                JsonNode classA = mapping.get("classes").get(0);
                String onto_acronymA = this.getOntologyAcronym(classA.get("links").get("ontology").asText());
                JsonNode classB = mapping.get("classes").get(1);
                String onto_acronymB = this.getOntologyAcronym(classB.get("links").get("ontology").asText());
                String type1 = classA.get("@type").asText();
                String type2 = classB.get("@type").asText();
                if (!type1.equals("http://www.w3.org/2002/07/owl#Class") || !type2.equals("http://www.w3.org/2002/07/owl#Class")) {
                    System.out.println("MAPPING INVOLVING NO CLASSES!!");
                }
                if (source_onto.equals(onto_acronymB)) {
                    uri1 = classB.get("@id").asText();
                    uri2 = classA.get("@id").asText();
                    onto1acronym = onto_acronymB;
                    onto2acronym = onto_acronymA;
                } else {
                    uri1 = classA.get("@id").asText();
                    uri2 = classB.get("@id").asText();
                    onto1acronym = onto_acronymA;
                    onto2acronym = onto_acronymB;
                }
                writer.writeLine(uri1 + "|" + uri2 + "|" + onto1acronym + "|" + onto2acronym + "|" + this.set2string(sources));
                if (this.filterMappingBySource(sources) || !target_ontos.contains(onto_acronymA) && !target_ontos.contains(onto_acronymB)) continue;
                mapping_objects.add(new BioPortalMapping(uri1, uri2, onto1acronym, onto2acronym, sources));
            }
            catch (Exception e) {
                ++numErroneous_mappings;
            }
        }
        if (numErroneous_mappings > 0) {
            System.out.println("\tNumber of mappings which led to an error: " + numErroneous_mappings + " in page before of " + nextPage);
        }
        if (!nextPage.isNull() && nextPage.asText().length() != 0) {
            try {
                this.getMappingsFromPageForGivenOntologies(original_request, this.jsonToNode(this.getRequest(nextPage.asText())), source_onto, target_ontos, mapping_objects, writer);
            }
            catch (Exception e) {
                System.out.println("\tError accessing next page: " + nextPageNumber + " of " + numberOfPages + " -> " + nextPage.asText());
            }
        }
    }

    private String set2string(Set<String> set) {
        String string = "";
        for (String s : set) {
            string = string + s + ";";
        }
        return string.substring(0, string.length() - 1);
    }

    private Set<String> getMappingSources(JsonNode mapping) {
        HashSet<String> source_list = new HashSet<String>();
        try {
            JsonNode mappings_sources = mapping.get("process");
            for (JsonNode source : mappings_sources) {
                if (source.get("name").asText().equals("null")) {
                    source_list.add("nosource");
                    continue;
                }
                source_list.add(source.get("name").asText());
            }
            source_list.add(mapping.get("source").asText().toLowerCase());
            if (source_list.isEmpty()) {
                source_list.add("nosource");
            }
        }
        catch (Exception e) {
            System.err.println("Error accessing mapping sources.");
        }
        if (source_list.isEmpty()) {
            source_list.add("nosource");
        }
        return source_list;
    }

    private boolean filterMappingBySource(Set<String> sources) {
        if (sources.contains("same_uris") || sources.contains("same_uri")) {
            return true;
        }
        return !sources.contains("loom") && !sources.contains("cui") && !sources.contains("mrmap");
    }

    private String getFilterByOntology() {
        StringBuilder filter = new StringBuilder();
        if (this.numQuestionsBioPortal_searchAll > 20 && !this.usefulSources.isEmpty()) {
            filter.append("&ontologies=");
            for (String string : this.usefulSources) {
                filter.append(string);
                filter.append(",");
            }
            return filter.substring(0, filter.length() - 1);
        }
        return filter.toString();
    }

    private String getExactMatchParameter(boolean exact) {
        return "&exact_match=" + String.valueOf(exact).toLowerCase();
    }

    private JsonNode jsonToNode(String json) throws JsonProcessingException, IOException {
        return this.mapper.readTree(json);
    }

    private String getRequest(String urlToGet) throws IOException {
        String result = "";
        boolean success = false;
        int attempts = 0;
        while (!success && attempts < 3) {
            ++attempts;
            try {
                String line;
                HttpURLConnection conn = this.getConnection(urlToGet);
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = rd.readLine()) != null) {
                    result = result + line;
                }
                rd.close();
                if (result.isEmpty()) continue;
                success = true;
            }
            catch (IOException e) {
                System.out.println("Error accessing: " + urlToGet + "  Attempt: " + attempts);
            }
        }
        if (!success) {
            throw new IOException();
        }
        if (attempts > 1) {
            System.out.println("SUCCESS accessing: " + urlToGet + "  Attempt: " + attempts);
        }
        return result;
    }

    private HttpURLConnection getConnection(String urlToGet) throws IOException {
        URL url = new URL(urlToGet);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "apikey token=5b0306a7-d116-4aea-9a65-24f281599114");
        conn.setRequestProperty("Accept", "application/json");
        return conn;
    }

    public OWLOntology downLoadOntology(String ontoAcronym, int attempts) {
        String urlToGet = "http://data.bioontology.org/ontologies/" + ontoAcronym + "/download";
        System.out.println("Downloading ontology " + ontoAcronym + ". Attempt: " + attempts);
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntologyLoaderConfiguration config = new OWLOntologyLoaderConfiguration();
        config.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
        manager.setOntologyLoaderConfiguration(config);
        OWLOntology MOOntology = null;
        try {
            HttpURLConnection conn = this.getConnection(urlToGet);
            conn.setReadTimeout(600000);
            InputStream in = conn.getInputStream();
            MOOntology = manager.loadOntologyFromOntologyDocument(in);
        }
        catch (IOException e) {
            if (attempts < 3) {
                return this.downLoadOntology(ontoAcronym, attempts + 1);
            }
            System.err.println("Error downloading the ontology " + ontoAcronym + " from BioPortal.");
        }
        catch (OWLOntologyCreationException e) {
            if (attempts < 3) {
                return this.downLoadOntology(ontoAcronym, attempts + 1);
            }
            System.err.println("Error creating BioPortal ontology " + ontoAcronym + " from input stream.");
            e.printStackTrace();
        }
        return MOOntology;
    }

    public static void main(String[] args) throws Exception {
        RESTBioPortalAccess bioportal = new RESTBioPortalAccess();
        if (bioportal.isActive()) {
            System.out.println("BioPortal is active: ");
            long init = Calendar.getInstance().getTimeInMillis();
            HashSet mapping_set = new HashSet();
            System.out.println("Axioms UBERON: " + bioportal.downLoadOntology("UBERON", 1).getAxiomCount());
            System.out.println("Axioms UBERON: " + bioportal.downLoadOntology("MP", 1).getAxiomCount());
            long end = Calendar.getInstance().getTimeInMillis();
            System.out.println("TIME: " + ((double)end - (double)init) / 1000.0);
        }
    }
}

