/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.ox.krr.logmap2.LogMap2_Matcher;
import uk.ac.ox.krr.logmap2.LogMap3_RepairFacility;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.bioportal.MediatingOntologyExtractor;
import uk.ac.ox.krr.logmap2.io.OAEIAlignmentOutput;
import uk.ac.ox.krr.logmap2.io.OWLAlignmentFormat;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.oaei.oracle.OracleManager;
import uk.ac.ox.krr.logmap2.oaei.reader.RDFAlignReader;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;
import uk.ac.ox.krr.logmap2.reasoning.SatisfiabilityIntegration;
import uk.ac.ox.krr.logmap2.statistics.StatisticsTimeMappings;

public class LogMap2_OAEI_BioPortal {
    OAEIAlignmentOutput alignment_output;
    MediatingOntologyExtractor MO_extractor;
    OWLOntology O1;
    OWLOntology O2;
    OWLOntology MO;
    String str_uri_onto1;
    String str_uri_onto2;
    LogMap2_Matcher logmap2;
    Set<MappingObjectStr> mappings = new HashSet<MappingObjectStr>();
    Map<MappingObjectStr, Integer> mappings2votes = new HashMap<MappingObjectStr, Integer>();
    private final int MIN_VOTES = 2;
    public static Set<MappingObjectStr> reference = new HashSet<MappingObjectStr>();

    public void align(URL source, URL target) throws Exception {
        this.align(source.toURI().toString(), target.toURI().toString());
    }

    public void align(String source_iri, String target_iri) throws Exception {
        long init_global = StatisticsTimeMappings.getCurrentTimeInMillis();
        Parameters.allow_interactivity = false;
        OracleManager.allowOracle(Parameters.allow_interactivity);
        this.O1 = this.loadOWLOntology(source_iri);
        this.O2 = this.loadOWLOntology(target_iri);
        StatisticsTimeMappings.setCurrentInitTime();
        this.logmap2 = new LogMap2_Matcher(this.O1, this.O2);
        this.getPrecisionRecall(this.logmap2.getLogmap2_Mappings());
        this.print("Representative elements: " + this.logmap2.getRepresentativeLabelsForMappings().size());
        this.print("Time performing matching with input ontologies O1 and O2 (s): " + StatisticsTimeMappings.getRunningTime());
        Parameters.ratio_second_chance_discarded = 5;
        this.print("Extracting up to " + Parameters.max_mediating_ontologies + " mediating ontologies from BioPortal.");
        StatisticsTimeMappings.setCurrentInitTime();
        this.MO_extractor = new MediatingOntologyExtractor(this.logmap2.getRepresentativeLabelsForMappings());
        this.print("Time extracting Mediating Ontologies (s): " + StatisticsTimeMappings.getRunningTime() + "\n");
        Parameters.cleanD_G = true;
        int num_used_MO = 0;
        for (String ontoAcronym : this.MO_extractor.getSelectedMediatingOntologies()) {
            this.print("\n\n" + num_used_MO + ". MO ONTOLOGY: " + ontoAcronym);
            StatisticsTimeMappings.setCurrentInitTime();
            Set<MappingObjectStr> composed_mappings = this.performComposedMatchingWithMediatingOntology(ontoAcronym);
            this.print("\nTime performing composed matching with MO '" + ontoAcronym + "' (s): " + StatisticsTimeMappings.getRunningTime());
            this.print("Composed mappings: " + composed_mappings.size());
            this.getPrecisionRecall(composed_mappings);
            this.getPrecisionRecall(this.mappings2votes.keySet());
            if (composed_mappings.size() > 0) {
                ++num_used_MO;
            }
            if (num_used_MO < this.MO_extractor.MAX_MO_FOR_MATCHING) continue;
            break;
        }
        this.print("\nResults Composed mappings: ");
        this.getComposedMappings(1);
        this.getComposedMappings(2);
        this.getComposedMappings(3);
        this.getComposedMappings(4);
        this.getComposedMappings(5);
        this.getComposedMappings();
        this.getComposedMappings2();
        this.getComposedMappings3();
        this.getComposedMappings4();
        this.print("\n");
        StatisticsTimeMappings.setCurrentInitTime();
        LogMap3_RepairFacility logmap_repair = new LogMap3_RepairFacility(this.O1, this.O2, this.logmap2.getLogmap2_Mappings(), this.getComposedMappings4());
        this.mappings.addAll(logmap_repair.getCleanMappings());
        this.print("\nTime performing mapping repir (s): " + StatisticsTimeMappings.getRunningTime());
        this.print("Number of total computed mappings: " + this.mappings.size());
        this.getPrecisionRecall(this.mappings);
        this.print("LogMap 2 (with BioPortal) total matching time (s): " + StatisticsTimeMappings.getRunningTime(init_global));
    }

    public URL returnAlignmentFile() throws Exception {
        return this.returnAlignmentFile("alignment");
    }

    public URL returnAlignmentFile(String file_name) throws Exception {
        this.alignment_output = new OAEIAlignmentOutput(file_name, this.str_uri_onto1, this.str_uri_onto2);
        for (MappingObjectStr mapping : this.mappings) {
            int dir_mapping;
            if (Parameters.output_class_mappings && mapping.isClassMapping()) {
                dir_mapping = mapping.getMappingDirection();
                if (Parameters.output_equivalences_only) {
                    dir_mapping = -2;
                }
                if (!mapping.getIRIStrEnt1().equals(mapping.getIRIStrEnt2())) {
                    this.alignment_output.addClassMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), dir_mapping, mapping.getConfidence());
                }
            }
            if (Parameters.output_prop_mappings) {
                if (mapping.isDataPropertyMapping()) {
                    dir_mapping = mapping.getMappingDirection();
                    if (!mapping.getIRIStrEnt1().equals(mapping.getIRIStrEnt2())) {
                        this.alignment_output.addDataPropMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), dir_mapping, mapping.getConfidence());
                    }
                }
                if (mapping.isObjectPropertyMapping()) {
                    dir_mapping = mapping.getMappingDirection();
                    if (!mapping.getIRIStrEnt1().equals(mapping.getIRIStrEnt2())) {
                        this.alignment_output.addObjPropMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), dir_mapping, mapping.getConfidence());
                    }
                }
            }
            if (!Parameters.perform_instance_matching || !Parameters.output_instance_mappings || !mapping.isInstanceMapping()) continue;
            dir_mapping = mapping.getMappingDirection();
            if (mapping.getIRIStrEnt1().equals(mapping.getIRIStrEnt2())) continue;
            this.alignment_output.addInstanceMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getConfidence());
        }
        this.alignment_output.saveOutputFile();
        return this.alignment_output.returnAlignmentFile();
    }

    private Set<MappingObjectStr> performComposedMatchingWithMediatingOntology(String ontoAcronym) {
        StatisticsTimeMappings.setCurrentInitTime();
        OWLOntology MO = this.MO_extractor.downloadBioPortalOntology(ontoAcronym, 1);
        this.print("\nTime downloading MO '" + ontoAcronym + "' (s): " + StatisticsTimeMappings.getRunningTime());
        HashSet<MappingObjectStr> composed_mappings = new HashSet<MappingObjectStr>();
        if (MO != null) {
            StatisticsTimeMappings.setCurrentInitTime();
            LogMap2_Matcher logmap2_matcher_mo1 = new LogMap2_Matcher(this.O1, MO);
            this.print("Time matching O1 with MO '" + ontoAcronym + "' (s): " + StatisticsTimeMappings.getRunningTime());
            StatisticsTimeMappings.setCurrentInitTime();
            LogMap2_Matcher logmap2_matcher_mo2 = new LogMap2_Matcher(MO, this.O2);
            this.print("Time matching O2 with MO '" + ontoAcronym + "' (s): " + StatisticsTimeMappings.getRunningTime());
            StatisticsTimeMappings.setCurrentInitTime();
            Set<MappingObjectStr> mappings_mo1 = logmap2_matcher_mo1.getLogmap2_Mappings();
            Set<MappingObjectStr> mappings_mo2 = logmap2_matcher_mo2.getLogmap2_Mappings();
            composed_mappings = new HashSet();
            for (MappingObjectStr map_mo1 : mappings_mo1) {
                if (!map_mo1.isClassMapping()) continue;
                for (MappingObjectStr map_mo2 : mappings_mo2) {
                    if (!map_mo2.isClassMapping() || !map_mo1.getIRIStrEnt2().equals(map_mo2.getIRIStrEnt1())) continue;
                    MappingObjectStr mapping = new MappingObjectStr(map_mo1.getIRIStrEnt1(), map_mo2.getIRIStrEnt2(), (map_mo1.getConfidence() + map_mo2.getConfidence()) / 2.0, -2, 0);
                    composed_mappings.add(mapping);
                    this.addVote2Mappings(mapping);
                }
            }
            this.print("Time creating composed mappings for'" + ontoAcronym + "' (s): " + StatisticsTimeMappings.getRunningTime());
        }
        return composed_mappings;
    }

    private void addVote2Mappings(MappingObjectStr mapping) {
        this.addVote2Mappings(mapping, 0);
    }

    private void addVote2Mappings(MappingObjectStr mapping, int init_vote) {
        if (!this.mappings2votes.containsKey(mapping)) {
            this.mappings2votes.put(mapping, init_vote);
        }
        this.mappings2votes.put(mapping, this.mappings2votes.get(mapping) + 1);
    }

    private Set<MappingObjectStr> getComposedMappings() {
        HashSet<MappingObjectStr> composed_mappings = new HashSet<MappingObjectStr>();
        for (MappingObjectStr mapping : this.mappings2votes.keySet()) {
            if (this.logmap2.getLogmap2_Mappings().contains(mapping)) continue;
            if (this.mappings2votes.get(mapping) >= 2) {
                composed_mappings.add(mapping);
                continue;
            }
            if (!(mapping.getConfidence() > Parameters.confidence_composed_mappings2)) continue;
            composed_mappings.add(mapping);
        }
        this.getPrecisionRecall(composed_mappings);
        return composed_mappings;
    }

    private Set<MappingObjectStr> getComposedMappings2() {
        HashSet<MappingObjectStr> composed_mappings = new HashSet<MappingObjectStr>();
        for (MappingObjectStr mapping : this.mappings2votes.keySet()) {
            if (this.logmap2.getLogmap2_Mappings().contains(mapping)) continue;
            if (this.mappings2votes.get(mapping) >= 2) {
                composed_mappings.add(mapping);
                continue;
            }
            if (this.mappings2votes.get(mapping) < 2 || !(mapping.getConfidence() > Parameters.confidence_composed_mappings2)) continue;
            composed_mappings.add(mapping);
        }
        this.getPrecisionRecall(composed_mappings);
        return composed_mappings;
    }

    private Set<MappingObjectStr> getComposedMappings3() {
        HashSet<MappingObjectStr> composed_mappings = new HashSet<MappingObjectStr>();
        for (MappingObjectStr mapping : this.mappings2votes.keySet()) {
            if (this.logmap2.getLogmap2_Mappings().contains(mapping)) continue;
            if (this.mappings2votes.get(mapping) >= 2) {
                composed_mappings.add(mapping);
                continue;
            }
            if (this.mappings2votes.get(mapping) >= 2 && mapping.getConfidence() > Parameters.confidence_composed_mappings2) {
                composed_mappings.add(mapping);
                continue;
            }
            if (this.mappings2votes.get(mapping) < 1 || !(mapping.getConfidence() > Parameters.confidence_composed_mappings1)) continue;
            composed_mappings.add(mapping);
        }
        this.getPrecisionRecall(composed_mappings);
        return composed_mappings;
    }

    private Set<MappingObjectStr> getComposedMappings4() {
        HashSet<MappingObjectStr> composed_mappings = new HashSet<MappingObjectStr>();
        for (MappingObjectStr mapping : this.mappings2votes.keySet()) {
            if (this.logmap2.getLogmap2_Mappings().contains(mapping)) continue;
            if (this.mappings2votes.get(mapping) >= 2 && mapping.getConfidence() > Parameters.confidence_composed_mappings2) {
                composed_mappings.add(mapping);
                continue;
            }
            if (this.mappings2votes.get(mapping) < 1 || !(mapping.getConfidence() > Parameters.confidence_composed_mappings1)) continue;
            composed_mappings.add(mapping);
        }
        this.getPrecisionRecall(composed_mappings);
        return composed_mappings;
    }

    private Set<MappingObjectStr> getComposedMappings(int min_votes) {
        HashSet<MappingObjectStr> composed_mappings = new HashSet<MappingObjectStr>();
        for (MappingObjectStr mapping : this.mappings2votes.keySet()) {
            if (this.logmap2.getLogmap2_Mappings().contains(mapping) || this.mappings2votes.get(mapping) < min_votes) continue;
            composed_mappings.add(mapping);
        }
        this.getPrecisionRecall(composed_mappings);
        return composed_mappings;
    }

    private OWLOntology loadOWLOntology(String iri_onto) throws OWLOntologyCreationException {
        OWLOntologyManager managerOnto = SynchronizedOWLManager.createOWLOntologyManager();
        OWLOntologyLoaderConfiguration config = new OWLOntologyLoaderConfiguration();
        config.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
        managerOnto.setOntologyLoaderConfiguration(config);
        return managerOnto.loadOntology(IRI.create((String)iri_onto));
    }

    private void checkSatisfiabilityMappings() throws Exception {
        OWLOntology mappins_owl_onto = this.getOWLOntology4GivenMappings(this.mappings);
        SatisfiabilityIntegration.setTimeoutClassSatisfiabilityCheck(60);
        SatisfiabilityIntegration sat_checker = new SatisfiabilityIntegration(this.O1, this.O2, mappins_owl_onto, true, true, false);
        this.print("Num unsat classes lead by LogMap mappings: " + sat_checker.getNumUnsatClasses());
    }

    private OWLOntology getOWLOntology4GivenMappings(Set<MappingObjectStr> mappings) throws Exception {
        OWLAlignmentFormat owlformat = new OWLAlignmentFormat("");
        for (MappingObjectStr mapping : mappings) {
            if (mapping.getTypeOfMapping() == 12) {
                owlformat.addInstanceMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getConfidence());
                continue;
            }
            if (mapping.getTypeOfMapping() == 0) {
                owlformat.addClassMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
                continue;
            }
            if (mapping.getTypeOfMapping() == 2) {
                owlformat.addObjPropMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
                continue;
            }
            if (mapping.getTypeOfMapping() != 1) continue;
            owlformat.addDataPropMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
        }
        return owlformat.getOWLOntology();
    }

    private void getPrecisionRecall(Set<MappingObjectStr> mappingsToTest) {
        boolean printPR = false;
        try {
            if (printPR) {
                int size_mappings = mappingsToTest.size();
                HashSet<MappingObjectStr> mappings = new HashSet<MappingObjectStr>(mappingsToTest);
                mappings.retainAll(reference);
                int good_mappings = mappings.size();
                double p = (double)good_mappings / (double)size_mappings;
                double r = (double)good_mappings / (double)reference.size();
                double f = 2.0 * r * p / (r + p);
                this.print("P: " + p + ", R: " + r + ", F: " + f + ", Num: " + mappingsToTest.size());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Set<MappingObjectStr> loadReference(String ref) {
        try {
            RDFAlignReader readerref = new RDFAlignReader(ref);
            return readerref.getMappingObjects();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void print(String text) {
        System.out.println(text);
    }

    public static void main(String[] args) {
        String iri1 = "file:/home/ernesto/Documents/OAEI_Datasets-revise/mouse/mouse2012.owl";
        String iri2 = "file:/home/ernesto/Documents/OAEI_Datasets-revise/mouse/human2012.owl";
        String ref = "/home/ernesto/Documents/OAEI_Datasets-revise/mouse/reference2012.rdf";
        String file_out = "/home/ernesto/Documents/OAEI_Datasets-revise/mouse/logmapbio-test";
        reference = LogMap2_OAEI_BioPortal.loadReference(ref);
        LogMap2_OAEI_BioPortal logmap_Bio = new LogMap2_OAEI_BioPortal();
        try {
            logmap_Bio.align(iri1, iri2);
            logmap_Bio.returnAlignmentFile(file_out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

