/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.ox.krr.logmap2.indexing.JointIndexManager;
import uk.ac.ox.krr.logmap2.indexing.OntologyProcessing;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.OutPutFilesManager;
import uk.ac.ox.krr.logmap2.io.ReadFile;
import uk.ac.ox.krr.logmap2.lexicon.LexicalUtilities;
import uk.ac.ox.krr.logmap2.mappings.CandidateMappingManager;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public class AddConfidence2Mappings {
    private long init_global;
    private long init;
    private long fin;
    private OntologyProcessing onto_process1;
    private OntologyProcessing onto_process2;
    private JointIndexManager index;
    private CandidateMappingManager mapping_manager;
    private OWLOntology onto1;
    private OWLOntology onto2;
    private Set<MappingObjectStr> input_mappings = new HashSet<MappingObjectStr>();
    private String ouput_file;

    public AddConfidence2Mappings(OWLOntology ont1, OWLOntology ont2, Set<MappingObjectStr> mappings, String outPutFileName) {
        this.onto1 = ont1;
        this.onto2 = ont2;
        this.input_mappings = mappings;
        this.ouput_file = outPutFileName;
        try {
            this.setUpStructures();
            this.associateType2Mappings();
            this.addConfidenceToMapping();
            this.saveMappings();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.onto_process1.clearReasoner();
        this.onto_process1.getClass2Identifier().clear();
        this.onto_process2.clearReasoner();
        this.onto_process2.getClass2Identifier().clear();
    }

    private void setUpStructures() throws Exception {
        LogOutput.showOutpuLog(false);
        this.index = new JointIndexManager();
        this.onto_process1 = new OntologyProcessing(this.onto1, this.index, new LexicalUtilities());
        this.onto_process2 = new OntologyProcessing(this.onto2, this.index, new LexicalUtilities());
        this.mapping_manager = new CandidateMappingManager(this.index, this.onto_process1, this.onto_process2);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.onto_process1.precessLexicon(true);
        this.onto_process2.precessLexicon(true);
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time indexing entities (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.onto_process1.setTaxonomicData();
        this.onto_process2.setTaxonomicData();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time extracting structural information (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
    }

    private void associateType2Mappings() {
        int num_original_class_mappings = 0;
        int num_original_dprop_mappings = 0;
        int num_original_oprop_mappings = 0;
        int num_original_instance_mappings = 0;
        int num_mixed_mappings = 0;
        for (MappingObjectStr map : this.input_mappings) {
            if (this.onto1.containsClassInSignature(IRI.create((String)map.getIRIStrEnt1()), true) && this.onto2.containsClassInSignature(IRI.create((String)map.getIRIStrEnt2()), true)) {
                map.setTypeOfMapping(0);
                this.addClassMapping(map);
                ++num_original_class_mappings;
                continue;
            }
            if (this.onto1.containsObjectPropertyInSignature(IRI.create((String)map.getIRIStrEnt1()), true) && this.onto2.containsObjectPropertyInSignature(IRI.create((String)map.getIRIStrEnt2()), true)) {
                map.setTypeOfMapping(2);
                ++num_original_oprop_mappings;
                continue;
            }
            if (this.onto1.containsDataPropertyInSignature(IRI.create((String)map.getIRIStrEnt1()), true) && this.onto2.containsDataPropertyInSignature(IRI.create((String)map.getIRIStrEnt2()), true)) {
                map.setTypeOfMapping(1);
                ++num_original_dprop_mappings;
                continue;
            }
            if (this.onto1.containsIndividualInSignature(IRI.create((String)map.getIRIStrEnt1()), true) && this.onto2.containsIndividualInSignature(IRI.create((String)map.getIRIStrEnt2()), true)) {
                map.setTypeOfMapping(3);
                ++num_original_instance_mappings;
                continue;
            }
            System.out.println("Mixed Entities or entities not in signature of ontologies: ");
            System.out.println("\t" + map.getIRIStrEnt1());
            System.out.println("\t" + map.getIRIStrEnt2());
            ++num_mixed_mappings;
        }
        LogOutput.printAlways("Num original mappings: " + this.input_mappings.size());
        LogOutput.printAlways("\tNum original class mappings: " + num_original_class_mappings);
        LogOutput.printAlways("\tNum original object property mappings: " + num_original_oprop_mappings);
        LogOutput.printAlways("\tNum original data property mappings: " + num_original_dprop_mappings);
        LogOutput.printAlways("\tNum original instance mappings: " + num_original_instance_mappings);
        LogOutput.printAlways("\tNum mixed mappings: " + num_mixed_mappings);
    }

    private void addClassMapping(MappingObjectStr map) {
        int ide1 = this.onto_process1.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
        int ide2 = this.onto_process2.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
        if (ide1 < 0 || ide2 < 0) {
            LogOutput.print("Classes not found in ontology.");
            LogOutput.print("\t" + ide1 + "  " + map.getIRIStrEnt1());
            LogOutput.print("\t" + ide2 + "  " + map.getIRIStrEnt2());
            return;
        }
        if (map.getMappingDirection() == -2) {
            this.mapping_manager.addSubMapping2ListOfAnchors(ide1, ide2);
            this.mapping_manager.addSubMapping2ListOfAnchors(ide2, ide1);
        } else if (map.getMappingDirection() == 0) {
            this.mapping_manager.addSubMapping2ListOfAnchors(ide1, ide2);
        } else {
            this.mapping_manager.addSubMapping2ListOfAnchors(ide2, ide1);
        }
    }

    private void addConfidenceToMapping() {
        for (MappingObjectStr map : this.input_mappings) {
            int ide2;
            int ide1;
            if (map.getTypeOfMapping() == 0) {
                ide1 = this.onto_process1.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
                ide2 = this.onto_process2.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
                map.setConfidenceMapping(0.5 * this.mapping_manager.getIsubScore4ConceptsLabels(ide1, ide2) + 0.5 * this.mapping_manager.getScopeISUB4Neighbourhood(ide1, ide2));
                continue;
            }
            if (map.getTypeOfMapping() == 2) {
                ide1 = this.onto_process1.getIdentifier4ObjectPropName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
                ide2 = this.onto_process2.getIdentifier4ObjectPropName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
                map.setConfidenceMapping(this.mapping_manager.getIsubScore4ObjectPropertyLabels(ide1, ide2));
                continue;
            }
            if (map.getTypeOfMapping() == 1) {
                ide1 = this.onto_process1.getIdentifier4DataPropName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
                ide2 = this.onto_process2.getIdentifier4DataPropName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
                map.setConfidenceMapping(this.mapping_manager.getIsubScore4DataPropertyLabels(ide1, ide2));
                continue;
            }
            if (map.getTypeOfMapping() != 3) continue;
            ide1 = this.onto_process1.getIdentifier4InstanceName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
            ide2 = this.onto_process2.getIdentifier4InstanceName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
            map.setConfidenceMapping(this.mapping_manager.getIsubScore4IndividualLabels(ide1, ide2));
        }
    }

    private void saveMappings() {
        OutPutFilesManager outPutFilesManager = new OutPutFilesManager();
        try {
            outPutFilesManager.createOutFiles(this.ouput_file, 4, this.onto1.getOntologyID().getOntologyIRI().toString(), this.onto2.getOntologyID().getOntologyIRI().toString());
            for (MappingObjectStr map : this.input_mappings) {
                if (map.getTypeOfMapping() == 0) {
                    outPutFilesManager.addClassMapping2Files(map.getIRIStrEnt1(), map.getIRIStrEnt2(), map.getMappingDirection(), map.getConfidence());
                    continue;
                }
                if (map.getTypeOfMapping() == 2) {
                    outPutFilesManager.addObjPropMapping2Files(map.getIRIStrEnt1(), map.getIRIStrEnt2(), map.getMappingDirection(), map.getConfidence());
                    continue;
                }
                if (map.getTypeOfMapping() == 1) {
                    outPutFilesManager.addDataPropMapping2Files(map.getIRIStrEnt1(), map.getIRIStrEnt2(), map.getMappingDirection(), map.getConfidence());
                    continue;
                }
                if (map.getTypeOfMapping() != 3) continue;
                outPutFilesManager.addInstanceMapping2Files(map.getIRIStrEnt1(), map.getIRIStrEnt2(), map.getConfidence());
            }
            outPutFilesManager.closeAndSaveFiles();
        }
        catch (Exception e) {
            System.err.println("Error saving mappings...");
            e.printStackTrace();
        }
    }

    private static Set<MappingObjectStr> loadInputMappings(String path) throws Exception {
        ReadFile reader = new ReadFile(path);
        HashSet<MappingObjectStr> mappings = new HashSet<MappingObjectStr>();
        String line = reader.readLine();
        while (line != null) {
            if (line.indexOf("|") < 0) {
                System.out.println("Wrong line: " + line);
                line = reader.readLine();
                continue;
            }
            String[] elements = line.split("\\|");
            MappingObjectStr mapping = new MappingObjectStr(elements[0], elements[1]);
            if (!mappings.contains(mapping)) {
                mappings.add(mapping);
            } else {
                System.out.println("Duplicated line: " + line);
            }
            line = reader.readLine();
        }
        reader.closeBuffer();
        return mappings;
    }

    private static void StatisticsOAEI2012() throws Exception {
        int onto_pair = 2;
        AddConfidence2Mappings.StatisticsOAEI2012("/usr/local/data/DataUMLS/UMLS_Onto_Versions/", onto_pair);
    }

    private static void StatisticsOAEI2012(String path_base, int ontoPair) throws Exception {
        String path_input_mappings;
        String base_path = path_base;
        int onto_pair = ontoPair;
        String rootpath_fma2nci = base_path + "OAEI_datasets/oaei_2012/fma2nci/";
        String rootpath_fma2snomed = base_path + "OAEI_datasets/oaei_2012/fma2snmd/";
        String rootpath_snomed2nci = base_path + "OAEI_datasets/oaei_2012/snmd2nci/";
        String irirootpath_fma2nci = "file:" + rootpath_fma2nci;
        String irirootpath_fma2snomed = "file:" + rootpath_fma2snomed;
        String irirootpath_snomed2nci = "file:" + rootpath_snomed2nci;
        String format_mappings = "TXT";
        String output_file = base_path + "OAEI_datasets/oaei_2013/";
        if (onto_pair == 0) {
            path_input_mappings = base_path + "OAEI_datasets/UMLS_txt_mappings/onto_mappings_FMA_NCI_dirty.txt";
            String irirootpath = irirootpath_fma2nci;
            String onto1 = irirootpath + "oaei2012_FMA_whole_ontology.owl";
            String onto2 = irirootpath + "oaei2012_NCI_whole_ontology.owl";
            output_file = output_file + "onto_mappings_FMA_NCI_dirty_confidence";
        } else if (onto_pair == 1) {
            path_input_mappings = base_path + "OAEI_datasets/UMLS_txt_mappings/onto_mappings_FMA_SNOMED_dirty.txt";
            String irirootpath = irirootpath_fma2snomed;
            String onto1 = irirootpath_fma2nci + "oaei2012_FMA_whole_ontology.owl";
            String onto2 = irirootpath + "oaei2012_SNOMED_whole_ontology.owl.zip";
            output_file = output_file + "onto_mappings_FMA_SNOMED_dirty_confidence";
        } else {
            path_input_mappings = base_path + "OAEI_datasets/UMLS_txt_mappings/onto_mappings_SNOMED_NCI_dirty.txt";
            String irirootpath = irirootpath_snomed2nci;
            String onto2 = irirootpath_fma2nci + "oaei2012_NCI_whole_ontology.owl";
            String onto1 = irirootpath_fma2snomed + "oaei2012_SNOMED_whole_ontology.owl.zip";
            output_file = output_file + "onto_mappings_SNOMED_NCI_dirty_confidence";
        }
        AddConfidence2Mappings.loadInputMappings(path_input_mappings);
    }

    public static void main(String[] args) {
        try {
            AddConfidence2Mappings.StatisticsOAEI2012();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

