# Contributing Guide

Please read this document in its entirety.

## General

- Be nice and respectful of maintainers’ and contributors’ time and viewpoints
- Be as descriptive as possible! More info is always better than not enough
- Be patient, there may be a lot of in-flight work, some of it across multiple projects not related to the repo being contributed to
- Have fun!

## Contributing

Contributing comes in many forms! We are incredibly grateful to anyone who can do any of the following:

- Add new features
- Fix bugs
- Fix typos
- Improve docs
- Improve tests
- Triage issues
- Review pull requests
- Share opinions and viewpoints on issues

## Issues

- If your issue is security related, please follow the [SECURITY guide](https://github.com/easypost/.github/SECURITY.md)
- Before opening a new issue, check for existing issues that are related, including closed ones
- Provide as much information as possible about the issue, including how to reproduce the problem and the expected behavior
- Don't needlessly bump issues (eg: if there hasn’t been progress for more than a few weeks, feel free to reach back out)

## Pull Requests

- All Pull Requests should be accompanied first by an issue describing the reason why the Pull Request is needed
- Be as descriptive as possible in your PR description about why the changes are being made and what the changes contain
- Pull Requests should be as small as possible
- Don't make unrelated changes in your Pull Request
- Don't open a Pull Request if you don't plan to see it through. PRs submitted by individuals that cannot complete additional work to get a PR merged may be closed without completion
- Adhere to the existing code style of the repo, even if it differs from your personal preference
- When applicable, add tests that provide ample coverage of the logic added or changed
- Pull Requests should come from branches and never the default `master` branch
- Pull Requests must pass CI, including linting and testing
- Pull Requests must go through code review before they can be merged to the main branch
- Do not include "version bump" changes in the same PR as your code changes; these will be handled as a separate PR and releasing process
- Make sure the `Allow edits from maintainers` checkbox is checked. That way EasyPost engineers can make certain minor changes as needed, allowing your pull request to be merged sooner.

You agree and acknowledge that you have necessary intellectual property rights to provide your Contribution and hereby assign to EasyPost all right, title and interest in such Contribution.
