"""
Django settings for test_app project.
Generated by 'django-admin startproject' using Django 3.1.7.
For more information on this file, see
https://docs.djangoproject.com/en/3.1/topics/settings/
For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.1/ref/settings/
"""

from pathlib import Path


# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/3.1/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = "uhtgm(e2y3@5%0x!wy#re#fn+51h*ck88^ocm7d1=hx^@(&7$7"

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = [
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    "django.contrib.staticfiles",
]

MIDDLEWARE = [
    "django.middleware.security.SecurityMiddleware",
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
]

ROOT_URLCONF = "test_app.urls"

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": [],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
            ],
        },
    },
]

WSGI_APPLICATION = "test_app.wsgi.application"


# Database
# https://docs.djangoproject.com/en/3.1/ref/settings/#databases

DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": "test",
    }
}

# Password validation
# https://docs.djangoproject.com/en/3.1/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        "NAME": "django.contrib.auth.password_validation.UserAttributeSimilarityValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.MinimumLengthValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.CommonPasswordValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.NumericPasswordValidator",
    },
]


# Internationalization
# https://docs.djangoproject.com/en/3.1/topics/i18n/

LANGUAGE_CODE = "en-us"

TIME_ZONE = "UTC"

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/3.1/howto/static-files/

STATIC_URL = "/static/"


# Sentry

import logging
# from urllib.parse import urlparse
# import sentry_sdk
from sentry_sdk.integrations.django.transactions import LEGACY_RESOLVER
from sentry_sdk.integrations.django import DjangoIntegration
from sentry_sdk.integrations.logging import LoggingIntegration
#
# def urlconf_callback():
#     return "config.urls"
#
# def print_to_stdout(event, _hint):
#     print(f"{event}")
#
# def before_send(event, _hint):
#     print_to_stdout(event, _hint)
#     if "request" in event and "url" in event["request"]:
#         url = event["request"]["url"]
#         path = urlparse(url).path
#         urlconf = urlconf_callback()
#         event["transaction"] = LEGACY_RESOLVER.resolve(path, urlconf=urlconf)
#     return event
#
DER_SENTRY_DSN = "https://absolutely-cannot-be-valid@o99999.ingest.sentry.io/9999999"

sentry_logging = LoggingIntegration(
    level=logging.ERROR,  # Capture info and above as breadcrumbs
    event_level=logging.ERROR,  # Send errors as events
)
DER_SENTRY_INTEGRATIONS = [
    sentry_logging,
    DjangoIntegration(),
]
#
# sentry_sdk.init(
#     dsn=SENTRY_DSN,
#     debug=DEBUG,
#     traces_sample_rate=0.0,
#     integrations=integrations,
#     environment="localhost",
#     release="0.0",
#     send_default_pii=True,
#     before_send=before_send,
#     request_bodies="always"
# )


# Error Reporting

INSTALLED_APPS += [
    "django_error_reporting.apps.DjangoErrorReportingConfig",
    "ddtrace.contrib.django",
    "django_datadog_logger",
]

MIDDLEWARE += [
    "django_error_reporting.middleware.ErrorReportingMiddleware",
    "django_error_reporting.middleware.DataDogExceptionMiddleware",
    "django_datadog_logger.middleware.error_log.ErrorLoggingMiddleware",
    "django_datadog_logger.middleware.request_log.RequestLoggingMiddleware"
]

def error_reporting_cb(request, add_event_tag, dd_scope=None):
    add_event_tag(
        "test1",
        "hi, i'm a test tag",
        dd_scope
    )

    add_event_tag(
        "test2",
        request.META.get("HTTP_USER_AGENT"),
        dd_scope
    )


DER_REQUEST_TAGGING_CB = error_reporting_cb
