/*
 * Decompiled with CFR 0.152.
 */
import edu.cmu.parex.ParaphraseExtractor;
import java.io.File;
import java.text.DecimalFormat;

public class Parex {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 5) {
            Parex.printUsage();
            System.exit(0);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        File file = new File(stringArray[4]);
        double d = 0.001;
        if (stringArray.length > 5) {
            d = Double.parseDouble(stringArray[5]);
        }
        double d2 = 0.001;
        if (stringArray.length > 6) {
            d2 = Double.parseDouble(stringArray[6]);
        }
        double d3 = 0.01;
        if (stringArray.length > 7) {
            d2 = Double.parseDouble(stringArray[7]);
        }
        String string5 = "~`!@#$%^&*()-_=+[{]}\\|;:'\",<.>/?";
        if (stringArray.length > 8) {
            string5 = stringArray[8];
        }
        if (file.exists()) {
            System.err.println("Directory exists, exiting: " + file.getPath());
            System.exit(1);
        }
        file.mkdir();
        String string6 = new File(file, "parex").getPath();
        System.err.println("Step 1: building common word lists");
        System.err.println("+ foreign");
        String string7 = string6 + ".f";
        ParaphraseExtractor.findCommonWords(string, string7, d2);
        System.err.println("+ english");
        String string8 = string6 + ".e";
        ParaphraseExtractor.findCommonWords(string2, string8, d2);
        System.err.println("Step 2: extracting paraphrases");
        String string9 = string6 + ".raw.gz";
        ParaphraseExtractor.extractParaphrases(string4, string3, string7, string8, string9, d, string5);
        System.err.println("Step 3: grouping paraphrases");
        String string10 = string6 + ".group.gz";
        ParaphraseExtractor.groupParaphrases(string9, string10);
        System.err.println("Step 4: combining and filtering paraphrases");
        String string11 = new File(file, "paraphrase.gz").getPath();
        ParaphraseExtractor.combineParaphrases(string10, string11, d3);
    }

    public static void printUsage() {
        DecimalFormat decimalFormat = new DecimalFormat("0.##########");
        System.err.println("Paraphrase Extractor");
        System.err.println();
        System.err.println("Usage: java -XX:+UseCompressedOops -Xmx12G -cp meteor-*.jar Parex <fCorpus> <eCorpus> <phrase-table.gz> <eTgtCorpus> <outDir> [minTP] [minRF] [minFinalP] [symbols]");
        System.err.println();
        System.err.println("Args:");
        System.err.println("<fCorpus> foreign corpus");
        System.err.println("<eCorpus> english corpus");
        System.err.println("<phrase-table.gz> phrasetable built from corpora (gzipped)");
        System.err.println("<eTgtCorpus> english target corpus to paraphrase (paraphrases will be extracted that match phrases in this text)");
        System.err.println("<outDir> directory for output files");
        System.err.println("[minTP] (default " + decimalFormat.format(0.001) + ") minimum paraphrase translation probability");
        System.err.println("[minRF] (default " + decimalFormat.format(0.001) + ") minimum word relative frequency for common word list");
        System.err.println("[minFinalP] (default " + decimalFormat.format(0.01) + ") minimum final (merged) paraphrase probability");
        System.err.println("[symbols] string of symbols to filter");
    }
}

