/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.tuebadz;

import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.trees.GrammaticalFunctionTreeNormalizer;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.OrderedCombinationTreeNormalizer;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZPennTreeNormalizer;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;

public class TueBaDZTreeReaderFactory
implements TreeReaderFactory,
Serializable {
    private static final long serialVersionUID = 1614799885744961795L;
    private TreebankLanguagePack tlp;
    private int nodeCleanup;

    public TueBaDZTreeReaderFactory(TreebankLanguagePack tlp) {
        this(tlp, 0);
    }

    public TueBaDZTreeReaderFactory(TreebankLanguagePack tlp, int nodeCleanup) {
        this.tlp = tlp;
        this.nodeCleanup = nodeCleanup;
    }

    @Override
    public TreeReader newTreeReader(Reader in) {
        GrammaticalFunctionTreeNormalizer tn1 = new GrammaticalFunctionTreeNormalizer(this.tlp, this.nodeCleanup);
        TueBaDZPennTreeNormalizer tn2 = new TueBaDZPennTreeNormalizer(this.tlp, this.nodeCleanup);
        OrderedCombinationTreeNormalizer norm = new OrderedCombinationTreeNormalizer(Arrays.asList(tn1, tn2));
        return new PennTreeReader(in, new LabeledScoredTreeFactory(new StringLabelFactory()), norm);
    }
}

